/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.debug;

import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.InterpreterDirectives;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.debug.Bits;
import com.oracle.svm.interpreter.debug.DebuggerEvents;
import com.oracle.svm.interpreter.debug.EventHandler;
import com.oracle.svm.interpreter.debug.EventKind;
import com.oracle.svm.interpreter.debug.Location;
import com.oracle.svm.interpreter.debug.SteppingControl;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.IsolateThread;

public final class DebuggerEventsImpl
implements DebuggerEvents {
    private static int globalEnabledEventsMask;
    private static final FastThreadLocalInt perThreadEnabledEventsMask;
    private static final FastThreadLocalObject<SteppingControl> perThreadSteppingControl;
    private static EventHandler eventHandler;

    @Override
    public void setEventEnabled(Thread thread, EventKind eventKind, boolean enable) {
        if (thread == null) {
            globalEnabledEventsMask = Bits.setBit(globalEnabledEventsMask, eventKind.ordinal(), enable);
        } else {
            int newMask;
            int oldMask;
            IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(thread);
            while (!perThreadEnabledEventsMask.compareAndSet(isolateThread, oldMask = perThreadEnabledEventsMask.getVolatile(isolateThread), newMask = Bits.setBit(oldMask, eventKind.ordinal(), enable))) {
            }
        }
    }

    private static int enabledEventsMask(Thread thread) {
        if (thread == null) {
            return globalEnabledEventsMask;
        }
        IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(thread);
        return globalEnabledEventsMask | perThreadEnabledEventsMask.get(isolateThread);
    }

    @Override
    public boolean isEventEnabled(Thread thread, EventKind eventKind) {
        return Bits.testBit(DebuggerEventsImpl.enabledEventsMask(thread), eventKind.ordinal());
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Intentional.")
    public void setEventHandler(EventHandler eventHandler) {
        DebuggerEventsImpl.eventHandler = eventHandler;
    }

    @Override
    public EventHandler getEventHandler() {
        return eventHandler;
    }

    @Override
    public void toggleBreakpoint(ResolvedJavaMethod method, int bci, boolean enable) {
        InterpreterResolvedJavaMethod interpreterMethod = (InterpreterResolvedJavaMethod)method;
        interpreterMethod.ensureCanSetBreakpointAt(bci);
        interpreterMethod.toggleBreakpoint(bci, enable);
        InterpreterUtil.traceInterpreter(enable ? "Setting" : "Unsetting").string(" breakpoint for method=").string(interpreterMethod.toString()).string(" at bci=").signed(bci).newline();
        if (enable) {
            InterpreterDirectives.ensureInterpreterExecution(interpreterMethod);
        }
    }

    @Override
    public void toggleMethodEnterEvent(ResolvedJavaType clazz, boolean enable) {
        DebuggerEventsImpl.toggleDeclaredMethodsInterpreterExecution(clazz, enable);
        ((InterpreterResolvedJavaType)clazz).toggleMethodEnterEvent(enable);
    }

    @Override
    public void toggleMethodExitEvent(ResolvedJavaType clazz, boolean enable) {
        DebuggerEventsImpl.toggleDeclaredMethodsInterpreterExecution(clazz, enable);
        ((InterpreterResolvedJavaType)clazz).toggleMethodExitEvent(enable);
    }

    private static void toggleDeclaredMethodsInterpreterExecution(ResolvedJavaType clazz, boolean enable) {
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        for (ResolvedJavaMethod resolvedJavaMethod : universe.getAllDeclaredMethods(clazz)) {
            InterpreterResolvedJavaMethod method = (InterpreterResolvedJavaMethod)resolvedJavaMethod;
            Object token = method.getInterpreterExecToken();
            if (enable) {
                if (token != null) continue;
                token = InterpreterDirectives.ensureInterpreterExecution(method);
                method.setInterpreterExecToken(token);
                continue;
            }
            if (token == null) continue;
            method.setInterpreterExecToken(null);
        }
    }

    @Override
    public SteppingControl getSteppingControl(Thread thread) {
        VMError.guarantee(thread != null);
        IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(thread);
        return perThreadSteppingControl.get(isolateThread);
    }

    @Override
    public void setSteppingFromLocation(Thread thread, int depth, int size, Location location) {
        VMError.guarantee(thread != null);
        IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(thread);
        SteppingControl value = new SteppingControl(thread, depth, size);
        perThreadSteppingControl.set(isolateThread, value);
        if (location != null) {
            value.setStartingLocation(location);
        }
    }

    @Override
    public void clearStepping(Thread thread) {
        VMError.guarantee(thread != null);
        IsolateThread isolateThread = PlatformThreads.getIsolateThreadUnsafe(thread);
        perThreadSteppingControl.set(isolateThread, null);
    }

    static {
        perThreadEnabledEventsMask = FastThreadLocalFactory.createInt("Debugger.perThreadEnabledEventsMask");
        perThreadSteppingControl = FastThreadLocalFactory.createObject(SteppingControl.class, "Debugger.perThreadSteppingControl");
    }
}

