/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class InterpreterUtil {
    public static void guarantee(boolean condition, String simpleFormat, Object arg1) {
        if (!condition) {
            VMError.guarantee(condition, MetadataUtil.fmt(simpleFormat, arg1));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void log(String msg) {
        if (InterpreterOptions.InterpreterBuildTimeLogging.getValue().booleanValue()) {
            System.out.println(msg);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void log(String simpleFormat, Object arg1) {
        if (InterpreterOptions.InterpreterBuildTimeLogging.getValue().booleanValue()) {
            System.out.println(MetadataUtil.fmt(simpleFormat, arg1));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void log(String simpleFormat, Object arg1, Object arg2) {
        if (InterpreterOptions.InterpreterBuildTimeLogging.getValue().booleanValue()) {
            System.out.println(MetadataUtil.fmt(simpleFormat, arg1, arg2));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void log(String simpleFormat, Object arg1, Object arg2, Object arg3) {
        if (InterpreterOptions.InterpreterBuildTimeLogging.getValue().booleanValue()) {
            System.out.println(MetadataUtil.fmt(simpleFormat, arg1, arg2, arg3));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void log(Throwable t) {
        if (InterpreterOptions.InterpreterBuildTimeLogging.getValue().booleanValue()) {
            t.printStackTrace(System.out);
        }
    }

    public static Log traceInterpreter(String msg) {
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue() && InterpreterOptions.InterpreterTrace.getValue().booleanValue()) {
            return Log.log().string(msg);
        }
        return Log.noopLog();
    }
}

