/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.aarch64.SubstrateAArch64MacroAssembler;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.aarch64.AArch64InterpreterStubs;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import java.util.Collection;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class AArch64InterpreterStubSection
extends InterpreterStubSection {
    private int resolverPatchOffset = -1;

    public AArch64InterpreterStubSection() {
        this.target = ConfigurationValues.getTarget();
        this.registerConfig = new SubstrateAArch64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NATIVE_TO_JAVA, null, this.target, true);
        this.valueKindFactory = javaKind -> LIRKind.fromJavaKind((Architecture)this.target.arch, (JavaKind)javaKind);
    }

    @Override
    protected byte[] generateEnterStubs(Collection<InterpreterResolvedJavaMethod> methods) {
        SubstrateAArch64MacroAssembler masm = new SubstrateAArch64MacroAssembler(this.target);
        if (SubstrateControlFlowIntegrity.enabled()) {
            VMError.unimplemented("GR-63035: Add CFI support for interpreter stubs");
        }
        Label interpEnterStub = new Label();
        masm.bind(interpEnterStub);
        try (AArch64MacroAssembler.ScratchRegister jmpTargetRegister = masm.getScratchRegister();){
            Register jmpTarget = jmpTargetRegister.getRegister();
            masm.setCodePatchingAnnotationConsumer(this::recordEnterStubForPatching);
            masm.adrpAdd(jmpTarget);
            masm.jmp(jmpTarget);
        }
        for (InterpreterResolvedJavaMethod method : methods) {
            VMError.guarantee(method.getEnterStubOffset() != -5);
            InterpreterUtil.log("[svm_interp] Adding stub for %s", method);
            this.recordEnterTrampoline(method, masm.position());
            masm.mov(AArch64InterpreterStubs.TRAMPOLINE_ARGUMENT, method.getEnterStubOffset());
            masm.jmp(interpEnterStub);
        }
        return masm.close(true);
    }

    @Override
    public int getVTableStubSize() {
        return 8;
    }

    @Override
    protected byte[] generateVTableEnterStubs(int maxVTableIndex) {
        SubstrateAArch64MacroAssembler masm = new SubstrateAArch64MacroAssembler(this.target);
        if (SubstrateControlFlowIntegrity.enabled()) {
            VMError.unimplemented("GR-63035: Add CFI support for interpreter stubs");
        }
        Label interpEnterStub = new Label();
        masm.bind(interpEnterStub);
        try (AArch64MacroAssembler.ScratchRegister jmpTargetRegister = masm.getScratchRegister();){
            Register jmpTarget = jmpTargetRegister.getRegister();
            masm.setCodePatchingAnnotationConsumer(this::recordEnterStubForPatching);
            masm.adrpAdd(jmpTarget);
            masm.jmp(jmpTarget);
        }
        masm.align(this.getVTableStubSize());
        this.recordVTableStubBaseOffset(masm.position());
        for (int vTableIndex = 0; vTableIndex < maxVTableIndex; ++vTableIndex) {
            int expectedStubEnd = masm.position() + this.getVTableStubSize();
            masm.mov(AArch64InterpreterStubs.TRAMPOLINE_ARGUMENT, vTableIndex);
            masm.jmp(interpEnterStub);
            masm.align(this.getVTableStubSize());
            assert (masm.position() == expectedStubEnd);
        }
        return masm.close(true);
    }

    private void recordEnterStubForPatching(Assembler.CodeAnnotation a) {
        if (this.resolverPatchOffset != -1) {
            return;
        }
        assert (a instanceof AArch64MacroAssembler.AdrpAddMacroInstruction);
        AArch64MacroAssembler.AdrpAddMacroInstruction annotation = (AArch64MacroAssembler.AdrpAddMacroInstruction)a;
        this.resolverPatchOffset = annotation.instructionPosition;
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void markEnterStubPatch(ObjectFile.ProgbitsSectionImpl pltBuffer, ResolvedJavaMethod enterStub) {
        pltBuffer.markRelocationSite(this.resolverPatchOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, NativeImage.localSymbolNameForMethod(enterStub), 0L);
        pltBuffer.markRelocationSite(this.resolverPatchOffset + 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, NativeImage.localSymbolNameForMethod(enterStub), 0L);
    }
}

