/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.proxy;

import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ProxyConfigurationParser;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.reflect.proxy.DynamicProxySupport;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import java.util.function.BiConsumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;

@AutomaticallyRegisteredFeature
public final class DynamicProxyFeature
implements InternalFeature {
    private int loadedConfigurations;
    private ProxyRegistry proxyRegistry;

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        DynamicProxySupport dynamicProxySupport = new DynamicProxySupport();
        ImageSingletons.add(DynamicProxyRegistry.class, (Object)dynamicProxySupport);
        ImageSingletons.add(RuntimeProxyCreationSupport.class, (Object)dynamicProxySupport);
        this.proxyRegistry = new ProxyRegistry(dynamicProxySupport, imageClassLoader);
        ImageSingletons.add(ProxyRegistry.class, (Object)this.proxyRegistry);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(imageClassLoader, ClassInitializationSupport.singleton());
        ProxyConfigurationParser parser = new ProxyConfigurationParser((ConfigurationConditionResolver)conditionResolver, ConfigurationFiles.Options.getConfigurationParserOptions(), (BiConsumer)this.proxyRegistry);
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)parser, imageClassLoader, "dynamic proxy", ConfigurationFiles.Options.DynamicProxyConfigurationFiles, ConfigurationFiles.Options.DynamicProxyConfigurationResources, ConfigurationFile.DYNAMIC_PROXY.getFileName());
    }

    private static ProxyRegistry proxyRegistry() {
        return (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        DynamicProxyFeature.proxyRegistry().setAnalysisAccess(access);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest proxyFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).proxyFallback;
        if (proxyFallback != null && this.loadedConfigurations == 0) {
            throw proxyFallback;
        }
    }
}

