/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisGraphDecoder;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.fieldfolding.IsStaticFinalFieldInitializedNode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import jdk.vm.ci.meta.ResolvedJavaType;

public class InlineBeforeAnalysisGraphDecoderImpl
extends InlineBeforeAnalysisGraphDecoder {
    private final SimulateClassInitializerSupport simulateClassInitializerSupport = SimulateClassInitializerSupport.singleton();
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();

    public InlineBeforeAnalysisGraphDecoderImpl(BigBang bb, InlineBeforeAnalysisPolicy policy, StructuredGraph graph, HostedProviders providers) {
        super(bb, policy, graph, providers, null);
    }

    protected Node doCanonicalizeFixedNode(InlineBeforeAnalysisGraphDecoder.InlineBeforeAnalysisMethodScope methodScope, GraphDecoder.LoopScope loopScope, Node initialNode) {
        Node node = super.doCanonicalizeFixedNode(methodScope, loopScope, initialNode);
        if (node instanceof EnsureClassInitializedNode) {
            EnsureClassInitializedNode ensureClassInitializedNode = (EnsureClassInitializedNode)node;
            node = this.handleEnsureClassInitializedNode(ensureClassInitializedNode);
        } else if (node instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            node = this.handleLoadFieldNode(loadFieldNode);
        } else if (node instanceof IsStaticFinalFieldInitializedNode) {
            IsStaticFinalFieldInitializedNode isStaticFinalFieldInitializedNode = (IsStaticFinalFieldInitializedNode)node;
            node = this.handleIsStaticFinalFieldInitializedNode(isStaticFinalFieldInitializedNode);
        }
        return node;
    }

    private Node handleEnsureClassInitializedNode(EnsureClassInitializedNode node) {
        AnalysisType type = (AnalysisType)node.constantTypeOrNull(this.bb.getConstantReflectionProvider());
        if (type != null) {
            this.processClassInitializer(type);
            if (this.simulateClassInitializerSupport.isClassInitializerSimulated(type) && !ClassInitializationSupport.singleton().requiresInitializationNodeForTypeReached((ResolvedJavaType)type)) {
                return null;
            }
        }
        return node;
    }

    private void processClassInitializer(AnalysisType type) {
        if (type.isReachable()) {
            type.getInitializeMetaDataTask().ensureDone();
        } else {
            this.simulateClassInitializerSupport.trySimulateClassInitializer(this.bb, type);
        }
    }

    private Node handleLoadFieldNode(LoadFieldNode node) {
        ConstantNode canonicalized;
        AnalysisField field = (AnalysisField)node.field();
        if (field.isStatic()) {
            this.processClassInitializer(field.getDeclaringClass());
        }
        if ((canonicalized = this.simulateClassInitializerSupport.tryCanonicalize(this.bb, node)) != null) {
            return canonicalized;
        }
        ValueNode intrinsified = this.fieldValueInterceptionSupport.tryIntrinsifyFieldLoad(this.providers, node);
        if (intrinsified != null) {
            return intrinsified;
        }
        return node;
    }

    private Node handleIsStaticFinalFieldInitializedNode(IsStaticFinalFieldInitializedNode node) {
        AnalysisField field = (AnalysisField)node.getField();
        if (this.simulateClassInitializerSupport.isClassInitializerSimulated(field.getDeclaringClass())) {
            return ConstantNode.forBoolean((boolean)true);
        }
        return node;
    }

    protected MethodCallTargetNode createCallTargetNode(ResolvedMethodHandleCallTargetNode t) {
        return new SubstrateMethodCallTargetNode(t.invokeKind(), t.targetMethod(), (ValueNode[])t.arguments().toArray((Object[])ValueNode.EMPTY_ARRAY), t.returnStamp(), t.getTypeProfile());
    }
}

