/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.util.ImageBuildStatistics;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.phases.Phase;

public class ImageBuildStatisticsCounterPhase
extends Phase {
    private final ImageBuildStatistics.CheckCountLocation location;

    public ImageBuildStatisticsCounterPhase(ImageBuildStatistics.CheckCountLocation location) {
        this.location = location;
    }

    protected void run(StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            if (!(node instanceof BytecodeExceptionNode) && !(node instanceof ThrowBytecodeExceptionNode)) continue;
            assert (node.isAlive()) : "ImageBuildStatisticsCounterPhase must be run after proper canonicalization to get the right numbers. Found not alive node: " + String.valueOf(node);
            BytecodeExceptionNode.BytecodeExceptionKind bytecodeExceptionKind = node instanceof BytecodeExceptionNode ? ((BytecodeExceptionNode)node).getExceptionKind() : ((ThrowBytecodeExceptionNode)node).getExceptionKind();
            ImageBuildStatistics.counters().incByteCodeException(bytecodeExceptionKind, this.location);
        }
    }
}

