/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.hosted.AnalyzeJavaHomeAccessFeature;
import java.util.List;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnalyzeJavaHomeAccessPhase
extends BasePhase<CoreProviders> {
    public static final String GET_PROPERTY_FUNCTION_NAME = "getProperty";
    public static final String JAVA_HOME = "java.home";
    private final boolean trackJavaHomeLocations;
    private final ResolvedJavaType typeJavaLangSystem;
    private final AnalyzeJavaHomeAccessFeature singleton = AnalyzeJavaHomeAccessFeature.instance();

    public AnalyzeJavaHomeAccessPhase(boolean trackJavaHomeLocations, AnalysisMetaAccess metaAccess) {
        this.trackJavaHomeLocations = trackJavaHomeLocations;
        this.typeJavaLangSystem = metaAccess.lookupJavaType(System.class);
    }

    protected void run(StructuredGraph graph, CoreProviders context) {
        List callTargetNodes = graph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        for (MethodCallTargetNode callTarget : callTargetNodes) {
            NodeSourcePosition nspToShow;
            String argValue = this.getSystemGetPropertyConstantArgument(callTarget, context);
            if (argValue == null || !argValue.equals(JAVA_HOME)) continue;
            this.singleton.setJavaHomeUsed();
            if (!this.trackJavaHomeLocations || (nspToShow = callTarget.getNodeSourcePosition()) == null) continue;
            int bci = nspToShow.getBCI();
            this.singleton.addJavaHomeUsageLocation(nspToShow.getMethod().asStackTraceElement(bci).toString());
        }
    }

    private String getSystemGetPropertyConstantArgument(MethodCallTargetNode callTarget, CoreProviders context) {
        ValueNode arg;
        ResolvedJavaMethod targetMethod = callTarget.targetMethod();
        ResolvedJavaType declaringClass = targetMethod.getDeclaringClass();
        if (declaringClass.equals((Object)this.typeJavaLangSystem) && targetMethod.getName().equals(GET_PROPERTY_FUNCTION_NAME) && (arg = (ValueNode)callTarget.arguments().first()).isJavaConstant()) {
            assert (arg.asJavaConstant() != null) : "Preventing warnings. Already checked.";
            if (arg.asJavaConstant().getJavaKind().isObject()) {
                return (String)context.getSnippetReflection().asObject(String.class, arg.asJavaConstant());
            }
        }
        return null;
    }
}

