/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

public class HostedField
extends HostedElement
implements OriginalFieldProvider,
SharedField,
WrappedJavaField {
    static final int LOC_UNMATERIALIZED_STATIC_CONSTANT = -10;
    public static final HostedField[] EMPTY_ARRAY = new HostedField[0];
    public final AnalysisField wrapped;
    private final HostedType holder;
    private final HostedType type;
    protected int location;
    private int installedLayerNum;

    public HostedField(AnalysisField wrapped, HostedType holder, HostedType type) {
        this.wrapped = wrapped;
        this.holder = holder;
        this.type = type;
        this.location = -1;
        this.installedLayerNum = -3;
    }

    public AnalysisField getWrapped() {
        return this.wrapped;
    }

    public void setLocation(int newLocation, int newInstallLayerNum) {
        assert (this.location == -1);
        assert (newLocation >= 0 || newLocation == -10);
        if (newLocation != -10) {
            this.wrapped.checkGuaranteeFolded();
        }
        this.location = newLocation;
        this.setInstalledLayerNum(newInstallLayerNum);
    }

    private void setInstalledLayerNum(int newInstallLayerNum) {
        assert (this.installedLayerNum == -3);
        assert (newInstallLayerNum != -3);
        if (this.wrapped.isStatic() ? !$assertionsDisabled && !(!ImageLayerBuildingSupport.buildingImageLayer() ? newInstallLayerNum == -1 : newInstallLayerNum >= 0) : !$assertionsDisabled && newInstallLayerNum != -2) {
            throw new AssertionError();
        }
        this.installedLayerNum = newInstallLayerNum;
    }

    protected void setUnmaterializedStaticConstant(int newInstalledLayerNum) {
        assert (this.isStatic());
        if (this.location == -10) {
            assert (this.installedLayerNum != newInstalledLayerNum);
            return;
        }
        this.setLocation(-10, newInstalledLayerNum);
    }

    public boolean isUnmaterialized() {
        return this.location == -10;
    }

    public boolean hasLocation() {
        return this.location >= 0;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.wrapped.isAccessed();
    }

    @Override
    public boolean isReachable() {
        return this.wrapped.isReachable();
    }

    public boolean isRead() {
        return this.wrapped.isRead();
    }

    @Override
    public boolean isWritten() {
        return this.wrapped.isWritten();
    }

    @Override
    public boolean isValueAvailable() {
        return FieldValueInterceptionSupport.singleton().isValueAvailable(this.wrapped);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public HostedType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public boolean isInternal() {
        return this.wrapped.isInternal();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public String toString() {
        return "HostedField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", location: " + this.location + ">";
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.wrapped;
    }

    public boolean hasInstalledLayerNum() {
        return this.installedLayerNum != -3 && this.installedLayerNum != -2;
    }

    @Override
    public int getInstalledLayerNum() {
        VMError.guarantee(this.hasInstalledLayerNum(), "Bad installed layer value: %s %s", this.installedLayerNum, this);
        return this.installedLayerNum;
    }
}

