/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.VMFeature;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.code.IncompatibleClassChangeFallbackMethod;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.methodhandles.InjectedInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.NodeClassMap;
import jdk.graal.compiler.util.ObjectCopier;
import jdk.graal.compiler.util.ObjectCopierInputStream;
import jdk.graal.compiler.util.ObjectCopierOutputStream;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageLayerSnapshotUtil {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final String PERSISTED = "persisted";
    public static final String TRACKED_REASON = "reachable from a graph";
    public static final int UNDEFINED_CONSTANT_ID = -1;
    public static final int UNDEFINED_FIELD_INDEX = -1;
    public static final String GENERATED_SERIALIZATION = "jdk.internal.reflect.GeneratedSerializationConstructorAccessor";
    static final Field companion = ReflectionUtil.lookupField(DynamicHub.class, (String)"companion");
    static final Field name = ReflectionUtil.lookupField(DynamicHub.class, (String)"name");
    static final Field componentType = ReflectionUtil.lookupField(DynamicHub.class, (String)"componentType");
    static final Field classInitializationInfo = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"classInitializationInfo");
    static final Field superHub = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"superHub");
    static final Field interfacesEncoding = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"interfacesEncoding");
    static final Field enumConstantsReference = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"enumConstantsReference");
    static final Field arrayHub = ReflectionUtil.lookupField(DynamicHubCompanion.class, (String)"arrayHub");
    protected static final Set<Field> dynamicHubRelinkedFields = Set.of(companion, name, componentType);
    protected static final Set<Field> dynamicHubCompanionRelinkedFields = Set.of(classInitializationInfo, superHub, arrayHub);
    private static final Class<?> sourceRoots = ReflectionUtil.lookupClass((String)"com.oracle.svm.hosted.image.sources.SourceCache$SourceRoots");
    private static final Class<?> completableFuture = ReflectionUtil.lookupClass((String)"com.oracle.svm.core.jdk.CompletableFutureFieldHolder");
    protected final Map<AnalysisType, Set<Integer>> fieldsToRelink = new ConcurrentHashMap<AnalysisType, Set<Integer>>();
    private final ImageClassLoader imageClassLoader;
    protected final List<Field> externalValueFields;
    protected Map<Object, Field> externalValues;

    public SVMImageLayerSnapshotUtil(ImageClassLoader imageClassLoader) {
        try {
            this.externalValueFields = ObjectCopier.getExternalValueFields();
        }
        catch (IOException e) {
            throw AnalysisError.shouldNotReachHere((String)"Unexpected exception when creating external value fields list", (Throwable)e);
        }
        this.imageClassLoader = imageClassLoader;
        this.addSVMExternalValueFields();
    }

    private void addSVMExternalValueFields() {
        for (URI svmURI : this.getBuilderLocations()) {
            for (String className : this.imageClassLoader.classLoaderSupport.classes(svmURI)) {
                try {
                    Class<?> clazz = this.imageClassLoader.forName(className);
                    this.externalValueFields.addAll(this.getStaticFinalObjectFields(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw AnalysisError.shouldNotReachHere((String)"The class %s from the modulePath %s was not found".formatted(className, svmURI.getPath()), (Throwable)e);
                }
            }
        }
    }

    public List<Field> getStaticFinalObjectFields(Class<?> clazz) {
        String packageName = clazz.getPackageName();
        if (!this.shouldScanPackage(packageName)) {
            return List.of();
        }
        if (!SVMImageLayerSnapshotUtil.shouldScanClass(clazz)) {
            return List.of();
        }
        Module module = clazz.getModule();
        if (module.getName() != null) {
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ObjectCopier.class, (boolean)false, (String)module.getName(), (String[])new String[]{packageName});
        }
        return ObjectCopier.getStaticFinalObjectFields(clazz);
    }

    protected Set<URI> getBuilderLocations() {
        try {
            Class<?> vmFeatureClass = ((VMFeature)ImageSingletons.lookup(VMFeature.class)).getClass();
            URI svmURI = VMFeature.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (vmFeatureClass == VMFeature.class) {
                return Set.of(svmURI);
            }
            return Set.of(svmURI, vmFeatureClass.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere("Error when trying to get SVM URI", e);
        }
    }

    protected boolean shouldScanPackage(String packageName) {
        return true;
    }

    private static boolean shouldScanClass(Class<?> clazz) {
        return !clazz.equals(sourceRoots) && !clazz.equals(completableFuture);
    }

    public Set<Integer> getRelinkedFields(AnalysisType type, AnalysisMetaAccess metaAccess) {
        Set result = this.fieldsToRelink.computeIfAbsent(type, key -> {
            Class clazz = type.getJavaClass();
            if (clazz == Class.class) {
                return SVMImageLayerSnapshotUtil.getRelinkedFields(type, dynamicHubRelinkedFields, metaAccess);
            }
            if (clazz == DynamicHubCompanion.class) {
                return SVMImageLayerSnapshotUtil.getRelinkedFields(type, dynamicHubCompanionRelinkedFields, metaAccess);
            }
            return null;
        });
        if (result == null) {
            return Set.of();
        }
        return result;
    }

    private static Set<Integer> getRelinkedFields(AnalysisType type, Set<Field> typeRelinkedFieldsSet, AnalysisMetaAccess metaAccess) {
        type.getInstanceFields(true);
        return typeRelinkedFieldsSet.stream().map(arg_0 -> ((AnalysisMetaAccess)metaAccess).lookupJavaField(arg_0)).map(AnalysisField::getPosition).collect(Collectors.toSet());
    }

    public SVMGraphEncoder getGraphEncoder(NodeClassMap nodeClassMap) {
        return new SVMGraphEncoder(this.externalValues, nodeClassMap);
    }

    public AbstractSVMGraphDecoder getGraphHostedToAnalysisElementsDecoder(SVMImageLayerLoader imageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider, NodeClassMap nodeClassMap) {
        return new SVMGraphHostedToAnalysisElementsDecoder(EncodedGraph.class.getClassLoader(), imageLayerLoader, analysisMethod, snippetReflectionProvider, nodeClassMap);
    }

    public AbstractSVMGraphDecoder getGraphDecoder(SVMImageLayerLoader imageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider, NodeClassMap nodeClassMap) {
        return new SVMGraphDecoder(EncodedGraph.class.getClassLoader(), imageLayerLoader, analysisMethod, snippetReflectionProvider, nodeClassMap);
    }

    public void initializeExternalValues() {
        assert (this.externalValues == null) : "The external values should be computed only once.";
        this.externalValues = ObjectCopier.Encoder.gatherExternalValues(this.externalValueFields);
    }

    public String getTypeDescriptor(AnalysisType type) {
        String javaName = type.toJavaName(true);
        if (javaName.contains(GENERATED_SERIALIZATION)) {
            return SVMImageLayerSnapshotUtil.getGeneratedSerializationName(type);
        }
        if (ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)type)) {
            return javaName;
        }
        return SVMImageLayerSnapshotUtil.addModuleName(javaName, type.getJavaClass().getModule().getName());
    }

    public String getMethodDescriptor(AnalysisMethod method) {
        Executable originalMethod;
        AnalysisType declaringClass = method.getDeclaringClass();
        String moduleName = declaringClass.getJavaClass().getModule().getName();
        if (declaringClass.toJavaName(true).contains(GENERATED_SERIALIZATION)) {
            return SVMImageLayerSnapshotUtil.getGeneratedSerializationName(declaringClass) + ":" + method.getName();
        }
        ResolvedJavaMethod resolvedJavaMethod = method.wrapped;
        if (resolvedJavaMethod instanceof FactoryMethod) {
            FactoryMethod factoryMethod = (FactoryMethod)resolvedJavaMethod;
            AnalysisMethod targetConstructor = method.getUniverse().lookup((JavaMethod)factoryMethod.getTargetConstructor());
            return SVMImageLayerSnapshotUtil.addModuleName(targetConstructor.getDeclaringClass().toJavaName(true) + SVMImageLayerSnapshotUtil.getQualifiedName(method), moduleName);
        }
        if (method.wrapped instanceof IncompatibleClassChangeFallbackMethod && (originalMethod = method.getJavaMethod()) != null) {
            return SVMImageLayerSnapshotUtil.addModuleName(method.getQualifiedName() + " " + method.getJavaMethod().toString(), moduleName);
        }
        if (!(method.wrapped instanceof HotSpotResolvedJavaMethod)) {
            return SVMImageLayerSnapshotUtil.addModuleName(SVMImageLayerSnapshotUtil.getQualifiedName(method), moduleName);
        }
        if (LambdaUtils.isLambdaType((ResolvedJavaType)declaringClass) || InjectedInvokerRenamingSubstitutionProcessor.isInjectedInvokerType((ResolvedJavaType)declaringClass) || MethodHandleInvokerRenamingSubstitutionProcessor.isMethodHandleType((ResolvedJavaType)declaringClass) || ProxyRenamingSubstitutionProcessor.isProxyType((ResolvedJavaType)declaringClass)) {
            return SVMImageLayerSnapshotUtil.getQualifiedName(method);
        }
        originalMethod = OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)method);
        if (originalMethod != null) {
            return SVMImageLayerSnapshotUtil.addModuleName(originalMethod.toString(), moduleName);
        }
        return SVMImageLayerSnapshotUtil.addModuleName(SVMImageLayerSnapshotUtil.getQualifiedName(method), moduleName);
    }

    private static String getGeneratedSerializationName(AnalysisType type) {
        Class constructorAccessor = type.getJavaClass();
        SerializationSupport serializationRegistry = SerializationSupport.currentLayer();
        SerializationSupport.SerializationLookupKey serializationLookupKey = serializationRegistry.getKeyFromConstructorAccessorClass(constructorAccessor);
        return SVMImageLayerSnapshotUtil.generatedSerializationClassName(serializationLookupKey);
    }

    private static String generatedSerializationClassName(SerializationSupport.SerializationLookupKey serializationLookupKey) {
        return "jdk.internal.reflect.GeneratedSerializationConstructorAccessor:" + String.valueOf(serializationLookupKey.getDeclaringClass()) + "," + String.valueOf(serializationLookupKey.getTargetConstructorClass());
    }

    private static String addModuleName(String elementName, String moduleName) {
        return moduleName + ":" + elementName;
    }

    private static String getQualifiedName(AnalysisMethod method) {
        return ((AnalysisType)method.getSignature().getReturnType()).toJavaName(true) + " " + method.getQualifiedName();
    }

    public static void forcePersistConstant(ImageHeapConstant imageHeapConstant) {
        AnalysisUniverse universe = imageHeapConstant.getType().getUniverse();
        universe.getHeapScanner().markReachable((JavaConstant)imageHeapConstant, ObjectScanner.OtherReason.PERSISTED);
        imageHeapConstant.getType().registerAsTrackedAcrossLayers((Object)imageHeapConstant);
        ConstantReflectionProvider constantReflection = universe.getBigbang().getConstantReflectionProvider();
        AnalysisType typeFromClassConstant = (AnalysisType)constantReflection.asJavaType((Constant)imageHeapConstant);
        if (typeFromClassConstant != null) {
            typeFromClassConstant.registerAsTrackedAcrossLayers((Object)imageHeapConstant);
        }
    }

    private static int encodeField(AnalysisField field) {
        field.registerAsTrackedAcrossLayers((Object)TRACKED_REASON);
        return field.getId();
    }

    private static AnalysisField decodeField(SVMImageLayerLoader imageLayerLoader, int id) {
        return imageLayerLoader.getAnalysisFieldForBaseLayerId(id);
    }

    private static AnalysisType getAnalysisType(SVMImageLayerLoader imageLayerLoader, ObjectCopierInputStream stream) throws IOException {
        int id = stream.readPackedUnsignedInt();
        return imageLayerLoader.getAnalysisTypeForBaseLayerId(id);
    }

    private static AnalysisMethod getAnalysisMethod(SVMImageLayerLoader imageLayerLoader, ObjectCopierInputStream stream) throws IOException {
        int id = stream.readPackedUnsignedInt();
        return imageLayerLoader.getAnalysisMethodForBaseLayerId(id);
    }

    private static void makeStaticFieldIds(ObjectCopier.Encoder encoder, ObjectCopier.ObjectPath objectPath, Object object) {
        Field staticField = (Field)encoder.getExternalValues().get(object);
        encoder.makeStringId(staticField.getDeclaringClass().getName(), objectPath);
        encoder.makeStringId(staticField.getName(), objectPath);
    }

    private static void writeStaticField(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object object) throws IOException {
        Field staticField = (Field)encoder.getExternalValues().get(object);
        encoder.writeString(stream, staticField.getDeclaringClass().getName());
        encoder.writeString(stream, staticField.getName());
    }

    private static <T> T readStaticFieldAndGetObject(ObjectCopier.Decoder decoder, ObjectCopierInputStream stream) throws IOException {
        String className = decoder.readString(stream);
        String fieldName = decoder.readString(stream);
        Class declaringClass = ReflectionUtil.lookupClass((boolean)false, (String)className);
        return (T)ReflectionUtil.readStaticField((Class)declaringClass, (String)fieldName);
    }

    public static class SVMGraphEncoder
    extends ObjectCopier.Encoder {
        public SVMGraphEncoder(Map<Object, Field> externalValues, NodeClassMap nodeClassMap) {
            super(externalValues);
            this.addBuiltin(new ImageHeapConstantBuiltIn(null));
            this.addBuiltin(new AnalysisTypeBuiltIn(null));
            this.addBuiltin(new AnalysisMethodBuiltIn(null, null));
            this.addBuiltin(new AnalysisFieldBuiltIn(null));
            this.addBuiltin(new FieldLocationIdentityBuiltIn(null));
            this.addBuiltin(new HostedTypeBuiltIn(null));
            this.addBuiltin(new HostedMethodBuiltIn(null));
            this.addBuiltin(new HostedOptionValuesBuiltIn());
            this.addBuiltin(new HostedSnippetReflectionProviderBuiltIn(null));
            this.addBuiltin(new CInterfaceLocationIdentityBuiltIn());
            this.addBuiltin(new FastThreadLocalLocationIdentityBuiltIn());
            this.addBuiltin(new VMThreadLocalInfoBuiltIn());
            if (nodeClassMap != null) {
                this.addBuiltin(new NodeClassMapBuiltin(nodeClassMap));
            }
        }

        protected void prepareObject(Object obj) {
            if (obj instanceof CounterKey) {
                CounterKey counterKey = (CounterKey)obj;
                counterKey.getName();
            }
        }
    }

    public static class SVMGraphHostedToAnalysisElementsDecoder
    extends AbstractSVMGraphDecoder {
        public SVMGraphHostedToAnalysisElementsDecoder(ClassLoader classLoader, SVMImageLayerLoader svmImageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider, NodeClassMap nodeClassMap) {
            super(classLoader, svmImageLayerLoader, analysisMethod, snippetReflectionProvider, nodeClassMap);
            this.addBuiltin(new HostedToAnalysisTypeDecoderBuiltIn(svmImageLayerLoader));
            this.addBuiltin(new HostedToAnalysisMethodDecoderBuiltIn(svmImageLayerLoader));
        }
    }

    public static class SVMGraphDecoder
    extends AbstractSVMGraphDecoder {
        public SVMGraphDecoder(ClassLoader classLoader, SVMImageLayerLoader svmImageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider, NodeClassMap nodeClassMap) {
            super(classLoader, svmImageLayerLoader, analysisMethod, snippetReflectionProvider, nodeClassMap);
            this.addBuiltin(new HostedTypeBuiltIn(svmImageLayerLoader));
            this.addBuiltin(new HostedMethodBuiltIn(svmImageLayerLoader));
        }
    }

    public static class VMThreadLocalInfoBuiltIn
    extends ObjectCopier.Builtin {
        protected VMThreadLocalInfoBuiltIn() {
            super(VMThreadLocalInfo.class, new Class[0]);
        }

        private static FastThreadLocal getThreadLocal(Object obj) {
            VMThreadLocalCollector vmThreadLocalCollector = (VMThreadLocalCollector)ImageSingletons.lookup(VMThreadLocalCollector.class);
            return vmThreadLocalCollector.getThreadLocal((VMThreadLocalInfo)obj);
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            SVMImageLayerSnapshotUtil.makeStaticFieldIds(encoder, objectPath, VMThreadLocalInfoBuiltIn.getThreadLocal(obj));
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            SVMImageLayerSnapshotUtil.writeStaticField(encoder, stream, VMThreadLocalInfoBuiltIn.getThreadLocal(obj));
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            FastThreadLocal fastThreadLocal = (FastThreadLocal)SVMImageLayerSnapshotUtil.readStaticFieldAndGetObject(decoder, stream);
            return ((VMThreadLocalCollector)ImageSingletons.lookup(VMThreadLocalCollector.class)).forFastThreadLocal(fastThreadLocal);
        }
    }

    public static class FastThreadLocalLocationIdentityBuiltIn
    extends ObjectCopier.Builtin {
        protected FastThreadLocalLocationIdentityBuiltIn() {
            super(FastThreadLocal.FastThreadLocalLocationIdentity.class, new Class[0]);
        }

        private static FastThreadLocal getFastThreadLocal(Object obj) {
            FastThreadLocal.FastThreadLocalLocationIdentity fastThreadLocalLocationIdentity = (FastThreadLocal.FastThreadLocalLocationIdentity)((Object)obj);
            return (FastThreadLocal)ReflectionUtil.readField(FastThreadLocal.FastThreadLocalLocationIdentity.class, (String)"this$0", (Object)((Object)fastThreadLocalLocationIdentity));
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            SVMImageLayerSnapshotUtil.makeStaticFieldIds(encoder, objectPath, FastThreadLocalLocationIdentityBuiltIn.getFastThreadLocal(obj));
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            SVMImageLayerSnapshotUtil.writeStaticField(encoder, stream, FastThreadLocalLocationIdentityBuiltIn.getFastThreadLocal(obj));
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            FastThreadLocal fastThreadLocal = (FastThreadLocal)SVMImageLayerSnapshotUtil.readStaticFieldAndGetObject(decoder, stream);
            return fastThreadLocal.getLocationIdentity();
        }
    }

    public static class CInterfaceLocationIdentityBuiltIn
    extends ObjectCopier.Builtin {
        protected CInterfaceLocationIdentityBuiltIn() {
            super(CInterfaceLocationIdentity.class, new Class[0]);
        }

        private static String asString(Object obj) {
            CInterfaceLocationIdentity cInterfaceLocationIdentity = (CInterfaceLocationIdentity)((Object)obj);
            return cInterfaceLocationIdentity.toString();
        }

        protected void makeChildIds(ObjectCopier.Encoder encoder, Object obj, ObjectCopier.ObjectPath objectPath) {
            encoder.makeStringId(CInterfaceLocationIdentityBuiltIn.asString(obj), objectPath);
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            String string = CInterfaceLocationIdentityBuiltIn.asString(obj);
            encoder.writeString(stream, string);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            String encoded = decoder.readString(stream);
            return new CInterfaceLocationIdentity(encoded);
        }
    }

    public static class HostedSnippetReflectionProviderBuiltIn
    extends ObjectCopier.Builtin {
        private final SnippetReflectionProvider snippetReflectionProvider;

        protected HostedSnippetReflectionProviderBuiltIn(SnippetReflectionProvider snippetReflectionProvider) {
            super(SnippetReflectionProvider.class, new Class[]{HostedSnippetReflectionProvider.class});
            this.snippetReflectionProvider = snippetReflectionProvider;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return this.snippetReflectionProvider;
        }
    }

    public static class HostedOptionValuesBuiltIn
    extends ObjectCopier.Builtin {
        protected HostedOptionValuesBuiltIn() {
            super(HostedOptionValues.class, new Class[0]);
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return HostedOptionValues.singleton();
        }
    }

    public static class HostedMethodBuiltIn
    extends AbstractHostedMethodBuiltIn {
        protected HostedMethodBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(svmImageLayerLoader);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            HostedUniverse hostedUniverse = this.svmImageLayerLoader.getHostedUniverse();
            return hostedUniverse.lookup((JavaMethod)SVMImageLayerSnapshotUtil.getAnalysisMethod(this.svmImageLayerLoader, stream));
        }
    }

    public static class HostedToAnalysisMethodDecoderBuiltIn
    extends AbstractHostedMethodBuiltIn {
        protected HostedToAnalysisMethodDecoderBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(svmImageLayerLoader);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return SVMImageLayerSnapshotUtil.getAnalysisMethod(this.svmImageLayerLoader, stream);
        }
    }

    public static abstract class AbstractHostedMethodBuiltIn
    extends ObjectCopier.Builtin {
        protected final SVMImageLayerLoader svmImageLayerLoader;

        protected AbstractHostedMethodBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(HostedMethod.class, new Class[0]);
            this.svmImageLayerLoader = svmImageLayerLoader;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            stream.writePackedUnsignedInt(((HostedMethod)obj).getWrapped().getId());
        }
    }

    public static class HostedTypeBuiltIn
    extends AbstractHostedTypeBuiltIn {
        protected HostedTypeBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(svmImageLayerLoader);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            HostedUniverse hostedUniverse = this.svmImageLayerLoader.getHostedUniverse();
            return hostedUniverse.lookup((JavaType)SVMImageLayerSnapshotUtil.getAnalysisType(this.svmImageLayerLoader, stream));
        }
    }

    public static class HostedToAnalysisTypeDecoderBuiltIn
    extends AbstractHostedTypeBuiltIn {
        protected HostedToAnalysisTypeDecoderBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(svmImageLayerLoader);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return SVMImageLayerSnapshotUtil.getAnalysisType(this.svmImageLayerLoader, stream);
        }
    }

    public static abstract class AbstractHostedTypeBuiltIn
    extends ObjectCopier.Builtin {
        protected final SVMImageLayerLoader svmImageLayerLoader;

        protected AbstractHostedTypeBuiltIn(SVMImageLayerLoader svmImageLayerLoader) {
            super(HostedType.class, new Class[]{HostedInstanceClass.class, HostedArrayClass.class});
            this.svmImageLayerLoader = svmImageLayerLoader;
        }

        protected void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            int id = ((HostedType)obj).getWrapped().getId();
            stream.writePackedUnsignedInt(id);
        }
    }

    public static class FieldLocationIdentityBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader imageLayerLoader;

        protected FieldLocationIdentityBuiltIn(SVMImageLayerLoader imageLayerLoader) {
            super(FieldLocationIdentity.class, new Class[0]);
            this.imageLayerLoader = imageLayerLoader;
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            FieldLocationIdentity fieldLocationIdentity = (FieldLocationIdentity)obj;
            int id = SVMImageLayerSnapshotUtil.encodeField((AnalysisField)fieldLocationIdentity.getField());
            stream.writePackedUnsignedInt(id);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            return new FieldLocationIdentity((ResolvedJavaField)SVMImageLayerSnapshotUtil.decodeField(this.imageLayerLoader, id));
        }
    }

    public static class AnalysisFieldBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader imageLayerLoader;

        protected AnalysisFieldBuiltIn(SVMImageLayerLoader imageLayerLoader) {
            super(AnalysisField.class, new Class[]{PointsToAnalysisField.class});
            this.imageLayerLoader = imageLayerLoader;
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            AnalysisField field = (AnalysisField)obj;
            int id = SVMImageLayerSnapshotUtil.encodeField(field);
            stream.writePackedUnsignedInt(id);
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            return SVMImageLayerSnapshotUtil.decodeField(this.imageLayerLoader, id);
        }
    }

    public static class AnalysisMethodBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader imageLayerLoader;
        private final AnalysisMethod analysisMethod;

        protected AnalysisMethodBuiltIn(SVMImageLayerLoader imageLayerLoader, AnalysisMethod analysisMethod) {
            super(AnalysisMethod.class, new Class[]{PointsToAnalysisMethod.class});
            this.imageLayerLoader = imageLayerLoader;
            this.analysisMethod = analysisMethod;
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            AnalysisMethod method = (AnalysisMethod)obj;
            method.registerAsTrackedAcrossLayers((Object)SVMImageLayerSnapshotUtil.TRACKED_REASON);
            stream.writePackedUnsignedInt(method.getId());
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            if (id == this.analysisMethod.getId()) {
                return this.analysisMethod;
            }
            return this.imageLayerLoader.getAnalysisMethodForBaseLayerId(id);
        }
    }

    public static class AnalysisTypeBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader imageLayerLoader;

        protected AnalysisTypeBuiltIn(SVMImageLayerLoader imageLayerLoader) {
            super(AnalysisType.class, new Class[]{PointsToAnalysisType.class});
            this.imageLayerLoader = imageLayerLoader;
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            AnalysisType type = (AnalysisType)obj;
            type.registerAsTrackedAcrossLayers((Object)SVMImageLayerSnapshotUtil.TRACKED_REASON);
            stream.writePackedUnsignedInt(type.getId());
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            return this.imageLayerLoader.getAnalysisTypeForBaseLayerId(id);
        }
    }

    public static class ImageHeapConstantBuiltIn
    extends ObjectCopier.Builtin {
        private final SVMImageLayerLoader imageLayerLoader;

        protected ImageHeapConstantBuiltIn(SVMImageLayerLoader imageLayerLoader) {
            super(ImageHeapConstant.class, new Class[]{ImageHeapInstance.class, ImageHeapObjectArray.class, ImageHeapPrimitiveArray.class});
            this.imageLayerLoader = imageLayerLoader;
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)obj;
            SVMImageLayerSnapshotUtil.forcePersistConstant(imageHeapConstant);
            stream.writePackedUnsignedInt(ImageHeapConstant.getConstantID((ImageHeapConstant)imageHeapConstant));
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            int id = stream.readPackedUnsignedInt();
            return this.imageLayerLoader.getOrCreateConstant(id);
        }
    }

    public static class NodeClassMapBuiltin
    extends ObjectCopier.Builtin {
        private final NodeClassMap nodeClassMap;

        protected NodeClassMapBuiltin(NodeClassMap nodeClassMap) {
            super(NodeClassMap.class, new Class[0]);
            this.nodeClassMap = Objects.requireNonNull(nodeClassMap);
        }

        public void encode(ObjectCopier.Encoder encoder, ObjectCopierOutputStream stream, Object obj) throws IOException {
            if (this.nodeClassMap != obj) {
                throw AnalysisError.shouldNotReachHere((String)"Unexpected NodeClassMap instance encountered");
            }
        }

        protected Object decode(ObjectCopier.Decoder decoder, Class<?> concreteType, ObjectCopierInputStream stream) throws IOException {
            return this.nodeClassMap;
        }
    }

    public static abstract class AbstractSVMGraphDecoder
    extends ObjectCopier.Decoder {
        private final HostedImageLayerBuildingSupport imageLayerBuildingSupport;

        public AbstractSVMGraphDecoder(ClassLoader classLoader, SVMImageLayerLoader imageLayerLoader, AnalysisMethod analysisMethod, SnippetReflectionProvider snippetReflectionProvider, NodeClassMap nodeClassMap) {
            super(classLoader);
            this.imageLayerBuildingSupport = imageLayerLoader.getImageLayerBuildingSupport();
            this.addBuiltin(new ImageHeapConstantBuiltIn(imageLayerLoader));
            this.addBuiltin(new AnalysisTypeBuiltIn(imageLayerLoader));
            this.addBuiltin(new AnalysisMethodBuiltIn(imageLayerLoader, analysisMethod));
            this.addBuiltin(new AnalysisFieldBuiltIn(imageLayerLoader));
            this.addBuiltin(new FieldLocationIdentityBuiltIn(imageLayerLoader));
            this.addBuiltin(new HostedOptionValuesBuiltIn());
            this.addBuiltin(new HostedSnippetReflectionProviderBuiltIn(snippetReflectionProvider));
            this.addBuiltin(new CInterfaceLocationIdentityBuiltIn());
            this.addBuiltin(new FastThreadLocalLocationIdentityBuiltIn());
            this.addBuiltin(new VMThreadLocalInfoBuiltIn());
            if (nodeClassMap != null) {
                this.addBuiltin(new NodeClassMapBuiltin(nodeClassMap));
            }
        }

        public Class<?> loadClass(String className) {
            return this.imageLayerBuildingSupport.lookupClass(false, className);
        }
    }
}

