/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.BuildingImageLayerPredicate;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.ImageHeapRelocatableConstantSupport;
import com.oracle.svm.hosted.imagelayer.LayeredClassInitialization;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton(value={LayeredClassInitialization.class}, onlyWith={BuildingImageLayerPredicate.class})
public class LayeredStaticFieldSupport
extends LayeredClassInitialization
implements LayeredImageSingleton {
    final Set<Object> appLayerFields;
    final Map<AnalysisField, LayerAssignmentStatus> assignmentStatusMap;
    final Map<AnalysisField, Integer> priorInstalledLayerMap;
    final Map<AnalysisField, Integer> priorInstalledLocationMap;
    public static final String appLayerPrimitiveStaticFieldsBaseName = "APPLAYER_PRIMITIVE_STATICFIELDSBASE";
    public static final String appLayerObjectStaticFieldsBaseName = "APPLAYER_OBJECT_STATICFIELDSBASE";
    private volatile ImageHeapRelocatableConstant appLayerPrimitiveStaticFieldsBase;
    private volatile ImageHeapRelocatableConstant appLayerObjectStaticFieldsBase;
    final UniverseBuilder.StaticFieldOffsets appLayerStaticFieldOffsets;
    private final boolean inAppLayer;

    LayeredStaticFieldSupport() {
        this(ConcurrentHashMap.newKeySet(), new UniverseBuilder.StaticFieldOffsets());
    }

    private LayeredStaticFieldSupport(Set<Object> appLayerFields, UniverseBuilder.StaticFieldOffsets appLayerStaticFieldOffsets) {
        this.appLayerFields = appLayerFields;
        this.assignmentStatusMap = new ConcurrentHashMap<AnalysisField, LayerAssignmentStatus>();
        this.inAppLayer = ImageLayerBuildingSupport.buildingApplicationLayer();
        this.priorInstalledLayerMap = this.inAppLayer ? new ConcurrentHashMap() : null;
        this.priorInstalledLocationMap = this.inAppLayer ? new ConcurrentHashMap() : null;
        this.appLayerStaticFieldOffsets = appLayerStaticFieldOffsets;
    }

    public static LayeredStaticFieldSupport singleton() {
        return (LayeredStaticFieldSupport)ImageSingletons.lookup(LayeredClassInitialization.class);
    }

    private static AnalysisField getAnalysisField(Object obj) {
        if (obj instanceof AnalysisField) {
            AnalysisField aField = (AnalysisField)obj;
            return aField;
        }
        Supplier supplier = (Supplier)obj;
        return (AnalysisField)supplier.get();
    }

    public void ensureInitializedFromFieldData(AnalysisField aField, SharedLayerSnapshotCapnProtoSchemaHolder.PersistedAnalysisField.Reader fieldData) {
        Integer priorInstalledLayerNum = fieldData.getPriorInstalledLayerNum();
        Object result = this.priorInstalledLayerMap.computeIfAbsent(aField, f -> priorInstalledLayerNum);
        assert (priorInstalledLayerNum.equals(result)) : result;
        LayerAssignmentStatus assignmentStatus = LayerAssignmentStatus.values()[fieldData.getAssignmentStatus()];
        result = this.assignmentStatusMap.computeIfAbsent(aField, f -> assignmentStatus);
        assert (assignmentStatus.equals(result));
        Integer priorInstalledLocation = fieldData.getLocation();
        result = this.priorInstalledLocationMap.computeIfAbsent(aField, f -> priorInstalledLocation);
        assert (priorInstalledLocation.equals(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installFieldInAppLayer(Field field, MetaAccessProvider meta) {
        assert (!this.inAppLayer && !BuildPhaseProvider.isAnalysisFinished());
        AnalysisField aField = (AnalysisField)meta.lookupJavaField(field);
        boolean added = this.appLayerFields.add(aField);
        assert (added);
        boolean initialized = aField.getDeclaringClass().isInitialized();
        AnalysisError.guarantee((boolean)initialized, (String)"Only fields for classes which are build-time initialized can be declared as deferred to application layer: %s", (Object[])new Object[]{aField});
        LayerAssignmentStatus previous = this.assignmentStatusMap.put(aField, LayerAssignmentStatus.APP_LAYER_REQUESTED);
        if (previous != null) {
            throw AnalysisError.userError((String)String.format("Field has a prior assignment. This is due to registering an app layer deferred field too late. Field: %s. Previous: %s", new Object[]{field, previous}));
        }
        CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
        if (field.getType().isPrimitive()) {
            if (this.appLayerPrimitiveStaticFieldsBase == null) {
                AnalysisType futureType = (AnalysisType)meta.lookupJavaType(byte[].class);
                LayeredStaticFieldSupport layeredStaticFieldSupport = this;
                synchronized (layeredStaticFieldSupport) {
                    if (this.appLayerPrimitiveStaticFieldsBase == null) {
                        this.appLayerPrimitiveStaticFieldsBase = (ImageHeapRelocatableConstant)registry.registerFutureHeapConstant(appLayerPrimitiveStaticFieldsBaseName, futureType);
                        ImageHeapRelocatableConstantSupport.singleton().registerLoadableConstant(this.appLayerPrimitiveStaticFieldsBase);
                    }
                }
            }
        } else if (this.appLayerObjectStaticFieldsBase == null) {
            AnalysisType futureType = (AnalysisType)meta.lookupJavaType(Object[].class);
            LayeredStaticFieldSupport layeredStaticFieldSupport = this;
            synchronized (layeredStaticFieldSupport) {
                if (this.appLayerObjectStaticFieldsBase == null) {
                    this.appLayerObjectStaticFieldsBase = (ImageHeapRelocatableConstant)registry.registerFutureHeapConstant(appLayerObjectStaticFieldsBaseName, futureType);
                    ImageHeapRelocatableConstantSupport.singleton().registerLoadableConstant(this.appLayerObjectStaticFieldsBase);
                }
            }
        }
    }

    @Override
    void initializeClassInAppLayer(Class<?> c, MetaAccessProvider meta) {
        for (Field field : c.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.installFieldInAppLayer(field, meta);
        }
    }

    public LayerAssignmentStatus getAssignmentStatus(AnalysisField analysisField) {
        return this.assignmentStatusMap.computeIfAbsent(analysisField, f -> {
            if (!this.inAppLayer || !analysisField.isInBaseLayer()) {
                return LayerAssignmentStatus.UNDECIDED;
            }
            throw VMError.shouldNotReachHere(String.format("Base analysis field assignment status queried before it is initialized: %s", analysisField));
        });
    }

    public int getPriorInstalledLayerNum(AnalysisField analysisField) {
        if (!this.inAppLayer || !analysisField.isInBaseLayer()) {
            return -3;
        }
        assert (this.priorInstalledLayerMap.containsKey(analysisField));
        return this.priorInstalledLayerMap.get(analysisField);
    }

    public boolean preventConstantFolding(AnalysisField aField) {
        LayerAssignmentStatus state = this.getAssignmentStatus(aField);
        return switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> false;
            case 2, 3 -> !this.inAppLayer;
        };
    }

    public boolean installableInLayer(AnalysisField aField) {
        LayerAssignmentStatus state = this.getAssignmentStatus(aField);
        return switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (!$assertionsDisabled && this.getPriorInstalledLayerNum(aField) != -3) {
                    throw new AssertionError();
                }
                yield true;
            }
            case 1 -> {
                if (!$assertionsDisabled && !aField.isInBaseLayer()) {
                    throw new AssertionError();
                }
                yield false;
            }
            case 2, 3 -> this.inAppLayer;
        };
    }

    public UniverseBuilder.StaticFieldOffsets getAppLayerStaticFieldOffsets() {
        assert (this.inAppLayer);
        return this.appLayerStaticFieldOffsets;
    }

    public void reinitializeKnownFields(List<HostedField> staticFields) {
        assert (ImageLayerBuildingSupport.buildingExtensionLayer());
        int currentLayerNum = DynamicImageLayerInfo.getCurrentLayerNumber();
        for (HostedField hField : staticFields) {
            AnalysisField aField = hField.getWrapped();
            LayerAssignmentStatus state = this.getAssignmentStatus(aField);
            if (state == LayerAssignmentStatus.PRIOR_LAYER) {
                int layerNum = this.getPriorInstalledLayerNum(aField);
                assert (this.priorInstalledLocationMap.containsKey(aField));
                int location = this.priorInstalledLocationMap.get(aField);
                hField.setLocation(location, layerNum);
                continue;
            }
            if (state != LayerAssignmentStatus.APP_LAYER_DEFERRED) continue;
            assert (this.inAppLayer);
            assert (this.priorInstalledLocationMap.containsKey(aField));
            int location = this.priorInstalledLocationMap.get(aField);
            hField.setLocation(location, currentLayerNum);
        }
    }

    public boolean skipStaticField(HostedField field, Function<HostedField, Boolean> traditionalSkipFieldLogic) {
        AnalysisField aField = field.getWrapped();
        LayerAssignmentStatus state = this.getAssignmentStatus(aField);
        return switch (state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> traditionalSkipFieldLogic.apply(field);
            case 1 -> false;
            case 2 -> {
                if (this.inAppLayer) {
                    yield traditionalSkipFieldLogic.apply(field);
                }
                boolean isAccessed = aField.isAccessed();
                if (isAccessed) {
                    LayerAssignmentStatus previous = this.assignmentStatusMap.put(aField, LayerAssignmentStatus.APP_LAYER_DEFERRED);
                    if (!$assertionsDisabled && previous != LayerAssignmentStatus.APP_LAYER_REQUESTED) {
                        throw new AssertionError();
                    }
                }
                if (!isAccessed) {
                    yield true;
                }
                yield false;
            }
            case 3 -> false;
        };
    }

    public boolean wasReinitialized(HostedField field) {
        LayerAssignmentStatus state = this.getAssignmentStatus(field.getWrapped());
        assert (state == LayerAssignmentStatus.PRIOR_LAYER || state == LayerAssignmentStatus.APP_LAYER_DEFERRED);
        return true;
    }

    public static int getAppLayerNumber() {
        return 1;
    }

    public UniverseBuilder.StaticFieldOffsets getFutureLayerOffsets(HostedField field, int layerNum) {
        assert (ImageLayerBuildingSupport.buildingSharedLayer());
        AnalysisField aField = field.getWrapped();
        VMError.guarantee(this.getAssignmentStatus(aField) == LayerAssignmentStatus.APP_LAYER_DEFERRED);
        assert (layerNum == LayeredStaticFieldSupport.getAppLayerNumber()) : layerNum;
        return this.appLayerStaticFieldOffsets;
    }

    public FloatingNode getAppLayerStaticFieldsBaseReplacement(boolean primitive, LoweringTool tool, StructuredGraph graph) {
        ImageHeapRelocatableConstant constant;
        ImageHeapRelocatableConstant imageHeapRelocatableConstant = constant = primitive ? this.appLayerPrimitiveStaticFieldsBase : this.appLayerObjectStaticFieldsBase;
        assert (constant != null);
        return ImageHeapRelocatableConstantSupport.singleton().emitLoadConstant(graph, tool.getMetaAccess(), constant);
    }

    public JavaConstant getAppLayerStaticFieldBaseConstant(boolean primitive) {
        ImageHeapRelocatableConstant result;
        ImageHeapRelocatableConstant imageHeapRelocatableConstant = result = primitive ? this.appLayerPrimitiveStaticFieldsBase : this.appLayerObjectStaticFieldsBase;
        assert (result != null);
        return result;
    }

    void loadAllAppLayerFields() {
        this.appLayerFields.forEach(LayeredStaticFieldSupport::getAnalysisField);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        writer.writeInt("appLayerPrimitiveFieldStartingOffset", this.appLayerStaticFieldOffsets.nextPrimitiveField);
        writer.writeInt("appLayerObjectFieldStartingOffset", this.appLayerStaticFieldOffsets.nextObjectField);
        HostedUniverse hUniverse = ((SVMImageLayerWriter.ImageSingletonWriterImpl)writer).getHostedUniverse();
        ArrayList<Integer> knownLocations = new ArrayList<Integer>();
        this.appLayerFields.forEach(obj -> {
            AnalysisField aField = LayeredStaticFieldSupport.getAnalysisField(obj);
            HostedField hField = hUniverse.lookup((JavaField)aField);
            if (hField.hasLocation()) {
                assert (this.getAssignmentStatus(aField) == LayerAssignmentStatus.APP_LAYER_DEFERRED);
                knownLocations.add(aField.getId());
            }
        });
        writer.writeIntList("appLayerFieldsWithKnownLocations", knownLocations);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        HashSet<Supplier<AnalysisField>> appLayerFieldsWithKnownLocations = new HashSet<Supplier<AnalysisField>>();
        for (int id : loader.readIntList("appLayerFieldsWithKnownLocations")) {
            Supplier<AnalysisField> aFieldSupplier = () -> HostedImageLayerBuildingSupport.singleton().getLoader().getAnalysisFieldForBaseLayerId(id);
            appLayerFieldsWithKnownLocations.add(aFieldSupplier);
        }
        UniverseBuilder.StaticFieldOffsets appLayerStaticFieldsOffsets = new UniverseBuilder.StaticFieldOffsets();
        appLayerStaticFieldsOffsets.nextPrimitiveField = loader.readInt("appLayerPrimitiveFieldStartingOffset");
        appLayerStaticFieldsOffsets.nextObjectField = loader.readInt("appLayerObjectFieldStartingOffset");
        return new LayeredStaticFieldSupport(Collections.unmodifiableSet(appLayerFieldsWithKnownLocations), appLayerStaticFieldsOffsets);
    }

    public static enum LayerAssignmentStatus {
        UNDECIDED,
        PRIOR_LAYER,
        APP_LAYER_REQUESTED,
        APP_LAYER_DEFERRED;

    }
}

