/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.sources.SourceCacheFeature;
import com.oracle.svm.hosted.image.sources.SourceRoot;
import com.oracle.svm.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SourceCache {
    private final Path basePath = SubstrateOptions.getDebugInfoSourceCacheRoot();

    public Path resolve(Path filePath, Class<?> clazz) {
        File cachedFile = this.findCandidate(filePath);
        if (cachedFile == null) {
            return this.tryCacheFile(filePath, clazz);
        }
        return this.checkCacheFile(filePath, clazz);
    }

    public File findCandidate(Path filePath) {
        File file = this.cachedFile(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected Path tryCacheFile(Path filePath, Class<?> clazz) {
        Path targetPath = this.cachedPath(filePath);
        String moduleName = null;
        if (clazz != null) {
            moduleName = clazz.getModule().getName();
        }
        if (moduleName != null) {
            for (String specialRootModule : SourceRoots.specialRootModules) {
                if (!moduleName.equals(specialRootModule)) continue;
                List<Path> specialModulePathList = SourceRoots.specialSrcRoots.get(specialRootModule);
                if (specialModulePathList == null) break;
                for (Path srcRoot : specialModulePathList) {
                    Path sourcePath;
                    String srcRootGroup = srcRoot.subpath(1, 2).toString().replace(".", filePath.getFileSystem().getSeparator());
                    if (!filePath.toString().startsWith(srcRootGroup) || !this.tryCacheFileFromRoot(sourcePath = this.extendPath(srcRoot, filePath), targetPath)) continue;
                    return filePath;
                }
                break;
            }
        }
        for (SourceRoot root : SourceRoots.srcRoots) {
            Path scopedFilePath = moduleName != null && root.isJDK ? Paths.get(moduleName, filePath.toString()) : filePath;
            Path sourcePath = this.extendPath(root.path, scopedFilePath);
            if (!this.tryCacheFileFromRoot(sourcePath, targetPath)) continue;
            return filePath;
        }
        return null;
    }

    protected boolean tryCacheFileFromRoot(Path sourcePath, Path targetPath) {
        try {
            if (SourceCache.checkSourcePath(sourcePath)) {
                SourceCache.ensureTargetDirs(targetPath.getParent());
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected Path checkCacheFile(Path filePath, Class<?> clazz) {
        Path targetPath = this.cachedPath(filePath);
        String moduleName = null;
        if (clazz != null) {
            moduleName = clazz.getModule().getName();
        }
        if (moduleName != null) {
            for (String specialRootModule : SourceRoots.specialRootModules) {
                if (!moduleName.equals(specialRootModule)) continue;
                List<Path> specialModulePathList = SourceRoots.specialSrcRoots.get(specialRootModule);
                if (specialModulePathList == null) break;
                for (Path srcRoot : specialModulePathList) {
                    String srcRootGroup = srcRoot.subpath(1, 2).toString().replace(".", filePath.getFileSystem().getSeparator());
                    if (!filePath.toString().startsWith(srcRootGroup)) continue;
                    Path sourcePath = this.extendPath(srcRoot, filePath);
                    try {
                        if (!this.tryCheckCacheFile(sourcePath, targetPath)) continue;
                        return filePath;
                    }
                    catch (IOException e) {
                        targetPath.toFile().delete();
                        return this.tryCacheFile(filePath, clazz);
                    }
                }
                break;
            }
        }
        for (SourceRoot root : SourceRoots.srcRoots) {
            Path scopedFilePath = moduleName != null && root.isJDK ? Paths.get(moduleName, filePath.toString()) : filePath;
            Path sourcePath = this.extendPath(root.path, scopedFilePath);
            try {
                if (!this.tryCheckCacheFile(sourcePath, targetPath)) continue;
                return filePath;
            }
            catch (IOException e) {
                targetPath.toFile().delete();
                return this.tryCacheFile(filePath, clazz);
            }
        }
        targetPath.toFile().delete();
        return null;
    }

    protected boolean tryCheckCacheFile(Path sourcePath, Path targetPath) throws IOException {
        if (SourceCache.checkSourcePath(sourcePath)) {
            FileTime sourceTime = Files.getLastModifiedTime(sourcePath, new LinkOption[0]);
            FileTime destTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
            if (destTime.compareTo(sourceTime) < 0) {
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            return true;
        }
        return false;
    }

    protected Path extendPath(Path root, Path filePath) {
        String newSeparator;
        String filePathString = filePath.toString();
        String fileSeparator = filePath.getFileSystem().getSeparator();
        if (!fileSeparator.equals(newSeparator = root.getFileSystem().getSeparator())) {
            filePathString = filePathString.replace(fileSeparator, newSeparator);
        }
        return root.resolve(filePathString);
    }

    protected Path cachedPath(Path candidate) {
        return this.basePath.resolve(candidate);
    }

    protected File cachedFile(Path candidate) {
        return this.cachedPath(candidate).toFile();
    }

    protected static boolean checkSourcePath(Path sourcePath) {
        return Files.isRegularFile(sourcePath, new LinkOption[0]);
    }

    protected static void ensureTargetDirs(Path targetDir) {
        File targetFile;
        if (targetDir != null && !(targetFile = targetDir.toFile()).exists()) {
            targetDir.toFile().mkdirs();
        }
    }

    private static final class SourceRoots {
        private static final List<SourceRoot> srcRoots = new ArrayList<SourceRoot>();
        private static final String[] specialRootModules = new String[]{"jdk.internal.vm.ci", "jdk.graal.compiler"};
        private static final HashMap<String, List<Path>> specialSrcRoots = new HashMap();

        private SourceRoots() {
        }

        private static void addJDKSources() {
            String javaHome = System.getProperty("java.home");
            assert (javaHome != null);
            Path javaHomePath = Paths.get("", javaHome);
            Path srcZipPath = javaHomePath.resolve("lib").resolve("src.zip");
            if (!srcZipPath.toFile().exists()) {
                LogUtils.warning((String)"Unable to locate JDK sources file '%s'. Source line debug will not be available for JDK classes.", (Object[])new Object[]{srcZipPath});
                return;
            }
            try {
                FileSystem srcFileSystem = FileSystems.newFileSystem(srcZipPath, (ClassLoader)null);
                for (Path root : srcFileSystem.getRootDirectories()) {
                    srcRoots.add(new SourceRoot(root, true));
                    for (String specialRootModule : specialRootModules) {
                        ArrayList rootsList = new ArrayList();
                        specialSrcRoots.put(specialRootModule, rootsList);
                        Path specialModuleRoot = root.resolve(specialRootModule);
                        Files.find(specialModuleRoot, 2, (path, attributes) -> path.endsWith("src"), new FileVisitOption[0]).forEach(rootsList::add);
                    }
                }
            }
            catch (IOException | FileSystemNotFoundException exception) {
                // empty catch block
            }
        }

        private static void addGraalSources() {
            SourceCacheFeature.getClassPath().forEach(classPathEntry -> SourceRoots.addGraalSourceRoot(classPathEntry, true));
            SourceCacheFeature.getModulePath().forEach(modulePathEntry -> SourceRoots.addGraalSourceRoot(modulePathEntry, true));
            SourceCacheFeature.getSourceSearchPath().forEach(sourcePathEntry -> SourceRoots.addGraalSourceRoot(sourcePathEntry, false));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void addGraalSourceRoot(Path sourcePath, boolean fromClassPath) {
            try {
                Object fileNameString = sourcePath.getFileName().toString();
                if (((String)fileNameString).endsWith(".jar") || ((String)fileNameString).endsWith(".src.zip")) {
                    Path srcPath;
                    File srcFile;
                    if (fromClassPath && ((String)fileNameString).endsWith(".jar")) {
                        int length = ((String)fileNameString).length();
                        fileNameString = ((String)fileNameString).substring(0, length - 3) + "src.zip";
                    }
                    if (!(srcFile = (srcPath = sourcePath.getParent().resolve((String)fileNameString)).toFile()).exists()) return;
                    if (srcFile.isFile()) {
                        try {
                            FileSystem fileSystem = FileSystems.newFileSystem(srcPath, (ClassLoader)null);
                            for (Path root : fileSystem.getRootDirectories()) {
                                srcRoots.add(new SourceRoot(root));
                            }
                            return;
                        }
                        catch (IOException | FileSystemNotFoundException exception) {
                            return;
                        }
                    }
                    if (!srcFile.isDirectory()) throw VMError.shouldNotReachHereUnexpectedInput(srcFile);
                    srcRoots.add(new SourceRoot(srcPath));
                    return;
                }
                if (fromClassPath) {
                    Path srcPath = sourcePath.resolve("src");
                    srcRoots.add(new SourceRoot(srcPath));
                    srcPath = sourcePath.resolve("src_gen");
                    srcRoots.add(new SourceRoot(srcPath));
                    return;
                } else {
                    srcRoots.add(new SourceRoot(sourcePath));
                }
                return;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private static void addApplicationSources() {
            SourceCacheFeature.getClassPath().forEach(classPathEntry -> SourceRoots.addApplicationSourceRoot(classPathEntry, true));
            SourceCacheFeature.getModulePath().forEach(modulePathEntry -> SourceRoots.addApplicationSourceRoot(modulePathEntry, true));
            SourceCacheFeature.getSourceSearchPath().forEach(sourcePathEntry -> SourceRoots.addApplicationSourceRoot(sourcePathEntry, false));
        }

        private static void addApplicationSourceRoot(Path sourceRoot, boolean fromClassPath) {
            block13: {
                try {
                    File file;
                    Path sourcePath = sourceRoot;
                    Object fileNameString = sourcePath.getFileName().toString();
                    if (((String)fileNameString).endsWith(".jar") || ((String)fileNameString).endsWith(".zip")) {
                        if (fromClassPath && ((String)fileNameString).endsWith(".jar")) {
                            int length = ((String)fileNameString).length();
                            fileNameString = ((String)fileNameString).substring(0, length - 4) + "-sources.jar";
                        }
                        if (!(sourcePath = sourcePath.getParent().resolve((String)fileNameString)).toFile().exists()) break block13;
                        try {
                            FileSystem fileSystem = FileSystems.newFileSystem(sourcePath, (ClassLoader)null);
                            for (Path root : fileSystem.getRootDirectories()) {
                                srcRoots.add(new SourceRoot(root));
                            }
                            break block13;
                        }
                        catch (IOException | FileSystemNotFoundException fileSystem) {
                            break block13;
                        }
                    }
                    if (fromClassPath && sourcePath.endsWith("classes")) {
                        Path parent = sourcePath.getParent();
                        if (parent.endsWith("target")) {
                            parent = parent.getParent();
                        }
                        sourcePath = parent.resolve("src");
                    }
                    if ((file = sourcePath.toFile()).exists() && file.isDirectory()) {
                        Path subPath = sourcePath.resolve("main").resolve("java");
                        file = subPath.toFile();
                        if (file.exists() && file.isDirectory()) {
                            sourcePath = subPath;
                        } else {
                            subPath = sourcePath.resolve("java");
                            file = subPath.toFile();
                            if (file.exists() && file.isDirectory()) {
                                sourcePath = subPath;
                            }
                        }
                        srcRoots.add(new SourceRoot(sourcePath));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }

        static {
            SourceRoots.addJDKSources();
            SourceRoots.addGraalSources();
            SourceRoots.addApplicationSources();
        }
    }
}

