/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.shaded.org.capnproto.PrimitiveList;
import com.oracle.svm.shaded.org.capnproto.StructList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;

class StaticFinalFieldFoldingSingleton
implements LayeredImageSingleton {
    final Map<AnalysisField, JavaConstant> bytecodeParsedFoldedFieldValues = new ConcurrentHashMap<AnalysisField, JavaConstant>();
    final Map<AnalysisField, JavaConstant> afterParsingHooksDoneFoldedFieldValues = new ConcurrentHashMap<AnalysisField, JavaConstant>();
    final Map<Integer, PriorLayerFinalFieldFoldingInfo> baseLayerFieldFoldingInfos;
    final Map<AnalysisField, Integer> fieldCheckIndexMap = new HashMap<AnalysisField, Integer>();
    boolean[] fieldInitializationStatus;

    StaticFinalFieldFoldingSingleton(Map<Integer, PriorLayerFinalFieldFoldingInfo> baseLayerFieldFoldingInfos) {
        this.baseLayerFieldFoldingInfos = baseLayerFieldFoldingInfos;
    }

    StaticFinalFieldFoldingSingleton() {
        this(new HashMap<Integer, PriorLayerFinalFieldFoldingInfo>());
    }

    public static StaticFinalFieldFoldingSingleton singleton() {
        return (StaticFinalFieldFoldingSingleton)ImageSingletons.lookup(StaticFinalFieldFoldingSingleton.class);
    }

    static AnalysisField toAnalysisField(ResolvedJavaField field) {
        if (field instanceof HostedField) {
            return ((HostedField)field).wrapped;
        }
        return (AnalysisField)field;
    }

    public JavaConstant getFoldedFieldValue(AnalysisParsedGraph.Stage stage, AnalysisField field) {
        return this.getFoldedFieldValues(stage).get(field);
    }

    Map<AnalysisField, JavaConstant> getFoldedFieldValues(AnalysisParsedGraph.Stage stage) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case AnalysisParsedGraph.Stage.BYTECODE_PARSED -> this.bytecodeParsedFoldedFieldValues;
            case AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED -> this.afterParsingHooksDoneFoldedFieldValues;
        };
    }

    public Integer getFieldCheckIndex(ResolvedJavaField field) {
        return this.getFieldCheckIndex(StaticFinalFieldFoldingSingleton.toAnalysisField(field));
    }

    public Integer getFieldCheckIndex(AnalysisField field) {
        return this.fieldCheckIndexMap.get(field);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Builder snapshotWriter = ((SVMImageLayerWriter.ImageSingletonWriterImpl)writer).getSnapshotBuilder();
        SVMImageLayerWriter imageLayerWriter = HostedImageLayerBuildingSupport.singleton().getWriter();
        ArrayList<Integer> fields = new ArrayList<Integer>();
        ArrayList<Integer> fieldCheckIndexes = new ArrayList<Integer>();
        ArrayList<Boolean> fieldInitializationStatusList = new ArrayList<Boolean>();
        ArrayList<JavaConstant> bytecodeParsedFoldedFieldValuesList = new ArrayList<JavaConstant>();
        ArrayList<JavaConstant> afterParsingHooksDoneFoldedFieldValuesList = new ArrayList<JavaConstant>();
        for (Map.Entry<AnalysisField, Integer> entry : this.fieldCheckIndexMap.entrySet()) {
            fields.add(entry.getKey().getId());
            fieldCheckIndexes.add(entry.getValue());
            fieldInitializationStatusList.add(this.fieldInitializationStatus[entry.getValue()]);
            bytecodeParsedFoldedFieldValuesList.add(this.bytecodeParsedFoldedFieldValues.get(entry.getKey()));
            afterParsingHooksDoneFoldedFieldValuesList.add(this.afterParsingHooksDoneFoldedFieldValues.get(entry.getKey()));
        }
        SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Builder staticFinalFieldFoldingSingleton = snapshotWriter.initStaticFinalFieldFoldingSingleton();
        PrimitiveList.Int.Builder fieldsBuilder = staticFinalFieldFoldingSingleton.initFields(fields.size());
        PrimitiveList.Int.Builder fieldCheckIndexesBuilder = staticFinalFieldFoldingSingleton.initFieldCheckIndexes(fieldCheckIndexes.size());
        PrimitiveList.Boolean.Builder fieldInitializationStatusListBuilder = staticFinalFieldFoldingSingleton.initFieldInitializationStatusList(fieldInitializationStatusList.size());
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> bytecodeParsedFoldedFieldValuesListBuilder = staticFinalFieldFoldingSingleton.initBytecodeParsedFoldedFieldValues(bytecodeParsedFoldedFieldValuesList.size());
        StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder> afterParsingHooksDoneFoldedFieldValuesListBuilder = staticFinalFieldFoldingSingleton.initAfterParsingHooksDoneFoldedFieldValues(afterParsingHooksDoneFoldedFieldValuesList.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldsBuilder.set(i, ((Integer)fields.get(i)).intValue());
            fieldCheckIndexesBuilder.set(i, ((Integer)fieldCheckIndexes.get(i)).intValue());
            fieldInitializationStatusListBuilder.set(i, ((Boolean)fieldInitializationStatusList.get(i)).booleanValue());
            imageLayerWriter.writeConstant((JavaConstant)bytecodeParsedFoldedFieldValuesList.get(i), (SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder)bytecodeParsedFoldedFieldValuesListBuilder.get(i));
            imageLayerWriter.writeConstant((JavaConstant)afterParsingHooksDoneFoldedFieldValuesList.get(i), (SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Builder)afterParsingHooksDoneFoldedFieldValuesListBuilder.get(i));
        }
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SharedLayerSnapshotCapnProtoSchemaHolder.SharedLayerSnapshot.Reader snapshotReader = ((SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl)loader).getSnapshotReader();
        SharedLayerSnapshotCapnProtoSchemaHolder.StaticFinalFieldFoldingSingleton.Reader staticFinalFieldFoldingSingleton = snapshotReader.getStaticFinalFieldFoldingSingleton();
        PrimitiveList.Int.Reader fields = staticFinalFieldFoldingSingleton.getFields();
        PrimitiveList.Int.Reader fieldCheckIndexes = staticFinalFieldFoldingSingleton.getFieldCheckIndexes();
        PrimitiveList.Boolean.Reader fieldInitializationStatusList = staticFinalFieldFoldingSingleton.getFieldInitializationStatusList();
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> bytecodeParsedFoldedFieldValuesList = staticFinalFieldFoldingSingleton.getBytecodeParsedFoldedFieldValues();
        StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader> afterParsingHooksDoneFoldedFieldValuesList = staticFinalFieldFoldingSingleton.getAfterParsingHooksDoneFoldedFieldValues();
        HashMap<Integer, PriorLayerFinalFieldFoldingInfo> baseLayerFieldFoldingInfos = new HashMap<Integer, PriorLayerFinalFieldFoldingInfo>();
        for (int i = 0; i < fields.size(); ++i) {
            baseLayerFieldFoldingInfos.put(fields.get(i), new PriorLayerFinalFieldFoldingInfo(SVMImageLayerLoader.getConstant((SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader)((Object)bytecodeParsedFoldedFieldValuesList.get(i))), SVMImageLayerLoader.getConstant((SharedLayerSnapshotCapnProtoSchemaHolder.ConstantReference.Reader)((Object)afterParsingHooksDoneFoldedFieldValuesList.get(i))), fieldCheckIndexes.get(i), fieldInitializationStatusList.get(i)));
        }
        return new StaticFinalFieldFoldingSingleton(baseLayerFieldFoldingInfos);
    }

    record PriorLayerFinalFieldFoldingInfo(SVMImageLayerLoader.JavaConstantSupplier bytecodeParsedFoldedFieldValue, SVMImageLayerLoader.JavaConstantSupplier afterParsingHooksDoneFoldedFieldValue, int fieldCheckIndex, boolean initializationStatus) {
    }
}

