/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataStorage;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.ConcurrentIdentityHashMap;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredFeature
public class CIsolateDataFeature
implements InternalFeature {
    private final Map<String, CIsolateData<?>> usedEntries = new ConcurrentIdentityHashMap();

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(this::replaceObject);
    }

    private Object replaceObject(Object obj) {
        if (obj instanceof CIsolateData) {
            CIsolateData entry = (CIsolateData)obj;
            this.usedEntries.compute(entry.getName(), (key, old) -> {
                VMError.guarantee(old == null || old == entry, "The isolate data section already contains an entry for %s", key);
                return entry;
            });
        }
        return obj;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        UnsignedWord offset = (UnsignedWord)Word.zero();
        CIsolateData[] entries = this.usedEntries.values().toArray(new CIsolateData[0]);
        Arrays.sort(entries, Comparator.comparing(CIsolateData::getSize).thenComparing(CIsolateData::getName));
        for (CIsolateData entry : entries) {
            offset = UnsignedUtils.roundUp(offset, Word.unsigned((int)8));
            entry.setOffset(offset);
            offset = offset.add(Word.unsigned((long)entry.getSize()));
        }
        CIsolateDataStorage.singleton().setSize(offset);
    }
}

