/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.BuildingInitialLayerPredicate;
import com.oracle.svm.core.jdk.LayeredModuleSingleton;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.imagelayer.CapnProtoAdapters;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.shaded.org.capnproto.StructList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AutomaticallyRegisteredImageSingleton(value={LayeredModuleSingleton.class}, onlyWith={BuildingInitialLayerPredicate.class})
public class HostedLayeredModuleSingleton
extends LayeredModuleSingleton {
    public HostedLayeredModuleSingleton() {
    }

    public HostedLayeredModuleSingleton(Map<String, Map<String, Set<String>>> moduleOpenPackages, Map<String, Map<String, Set<String>>> moduleExportedPackages) {
        super(moduleOpenPackages, moduleExportedPackages);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        SVMImageLayerWriter.ImageSingletonWriterImpl writerImpl = (SVMImageLayerWriter.ImageSingletonWriterImpl)writer;
        SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Builder builder = writerImpl.getSnapshotBuilder().initLayeredModule();
        HostedLayeredModuleSingleton.persistModulePackages(builder.initOpenModulePackages(this.moduleOpenPackages.size()), this.moduleOpenPackages);
        HostedLayeredModuleSingleton.persistModulePackages(builder.initExportedModulePackages(this.moduleExportedPackages.size()), this.moduleExportedPackages);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    private static void persistModulePackages(StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder> modulePackagesBuilder, Map<String, Map<String, Set<String>>> modulePackages) {
        int i = 0;
        for (Map.Entry<String, Map<String, Set<String>>> entry : modulePackages.entrySet()) {
            SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder entryBuilder = (SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Builder)modulePackagesBuilder.get(i);
            entryBuilder.setModuleKey(entry.getKey());
            Map<String, Set<String>> value = entry.getValue();
            StructList.Builder<SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Builder> packagesBuilder = entryBuilder.initPackages(value.size());
            int j = 0;
            for (Map.Entry<String, Set<String>> packageEntry : value.entrySet()) {
                SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Builder packageEntryBuilder = (SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Builder)packagesBuilder.get(j);
                packageEntryBuilder.setPackageKey(packageEntry.getKey());
                SVMImageLayerWriter.initStringList(packageEntryBuilder::initModules, packageEntry.getValue().stream());
                ++j;
            }
            ++i;
        }
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl loaderImpl = (SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl)loader;
        SharedLayerSnapshotCapnProtoSchemaHolder.LayeredModule.Reader reader = loaderImpl.getSnapshotReader().getLayeredModule();
        Map<String, Map<String, Set<String>>> moduleOpenPackages = HostedLayeredModuleSingleton.getModulePackages(reader.getOpenModulePackages());
        Map<String, Map<String, Set<String>>> moduleExportedPackages = HostedLayeredModuleSingleton.getModulePackages(reader.getExportedModulePackages());
        return new HostedLayeredModuleSingleton(moduleOpenPackages, moduleExportedPackages);
    }

    private static Map<String, Map<String, Set<String>>> getModulePackages(StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader> modulePackagesReader) {
        HashMap<String, Map<String, Set<String>>> modulePackages = new HashMap<String, Map<String, Set<String>>>();
        for (int i = 0; i < modulePackagesReader.size(); ++i) {
            SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader entryReader = (SharedLayerSnapshotCapnProtoSchemaHolder.ModulePackages.Reader)((Object)modulePackagesReader.get(i));
            StructList.Reader<SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Reader> packagesReader = entryReader.getPackages();
            HashMap<String, Set> packages = new HashMap<String, Set>();
            for (int j = 0; j < packagesReader.size(); ++j) {
                SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Reader packageEntryReader = (SharedLayerSnapshotCapnProtoSchemaHolder.Packages.Reader)((Object)packagesReader.get(j));
                Set modules = CapnProtoAdapters.toCollection(packageEntryReader.getModules(), HashSet::new);
                packages.put(packageEntryReader.getPackageKey().toString(), modules);
            }
            modulePackages.put(entryReader.getModuleKey().toString(), packages);
        }
        return modulePackages;
    }
}

