/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;

public final class IsolatedCodeInstallBridge
extends InstalledCode
implements OptimizedAssumptionDependency {
    private final ClientHandle<? extends SubstrateInstalledCode.Factory> factoryHandle;
    private ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle;
    private static final String DO_NOT_CALL_REASON = IsolatedCodeInstallBridge.class.getSimpleName() + " only acts as an accessor for cross-isolate data. None of the implemented methods may be called.";

    public IsolatedCodeInstallBridge(ClientHandle<? extends SubstrateInstalledCode.Factory> factoryHandle) {
        super(IsolatedCodeInstallBridge.class.getSimpleName());
        this.factoryHandle = factoryHandle;
    }

    public ClientHandle<? extends SubstrateInstalledCode.Factory> getSubstrateInstalledCodeFactoryHandle() {
        return this.factoryHandle;
    }

    public void setSubstrateInstalledCodeHandle(ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle) {
        this.installedCodeHandle = installedCodeHandle;
    }

    public ClientHandle<? extends SubstrateInstalledCode> getSubstrateInstalledCodeHandle() {
        assert (this.installedCodeHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) : "must have been initialized";
        return this.installedCodeHandle;
    }

    public String getName() {
        throw VMError.shouldNotReachHere(DO_NOT_CALL_REASON);
    }

    public long getStart() {
        ClientHandle<? extends SubstrateInstalledCode> handle = this.installedCodeHandle;
        if (handle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            return IsolatedCodeInstallBridge.getStart0(IsolatedCompileContext.get().getClient(), handle);
        }
        return 0L;
    }

    public boolean isValid() {
        ClientHandle<? extends SubstrateInstalledCode> handle = this.installedCodeHandle;
        if (handle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            return IsolatedCodeInstallBridge.isValid0(IsolatedCompileContext.get().getClient(), handle);
        }
        return false;
    }

    public boolean isAlive() {
        throw VMError.shouldNotReachHere(DO_NOT_CALL_REASON);
    }

    public byte[] getCode() {
        ClientHandle<? extends SubstrateInstalledCode> handle = this.installedCodeHandle;
        if (handle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            CompilerHandle<byte[]> codeHandle = IsolatedCodeInstallBridge.getCode0(IsolatedCompileContext.get().getClient(), handle);
            return codeHandle == IsolatedHandles.nullHandle() ? null : IsolatedCompileContext.get().unhand(codeHandle);
        }
        return null;
    }

    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        throw VMError.shouldNotReachHere(DO_NOT_CALL_REASON);
    }

    public Object executeVarargs(Object ... args) {
        throw VMError.shouldNotReachHere(DO_NOT_CALL_REASON);
    }

    public TruffleCompilable getCompilable() {
        throw VMError.shouldNotReachHere(DO_NOT_CALL_REASON);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static long getStart0(ClientIsolateThread client, ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle) {
        return IsolatedCompileClient.get().unhand(installedCodeHandle).getAddress();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isValid0(ClientIsolateThread client, ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle) {
        return IsolatedCompileClient.get().unhand(installedCodeHandle).isValid();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<byte[]> getCode0(ClientIsolateThread client, ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle) {
        SubstrateInstalledCode installedCode = IsolatedCompileClient.get().unhand(installedCodeHandle);
        return IsolatedCodeInstallBridge.getCodeUninterruptible((CodePointer)Word.pointer((long)installedCode.getEntryPoint()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Accesses code info.")
    private static CompilerHandle<byte[]> getCodeUninterruptible(CodePointer entryPointAddress) {
        UntetheredCodeInfo untetheredCodeInfo = CodeInfoTable.lookupCodeInfo(entryPointAddress);
        if (untetheredCodeInfo.isNull()) {
            return (CompilerHandle)IsolatedHandles.nullHandle();
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert(untetheredCodeInfo, tether);
            CompilerHandle<byte[]> compilerHandle = IsolatedCodeInstallBridge.copyCode0(codeInfo);
            return compilerHandle;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
        }
    }

    @Uninterruptible(reason="Wrap the now safe call to code info.", calleeMustBe=false)
    private static CompilerHandle<byte[]> copyCode0(CodeInfo codeInfo) {
        return IsolatedCodeInstallBridge.copyCodeInCompilerIsolate0(IsolatedCompileClient.get().getCompiler(), CodeInfoAccess.getCodeStart(codeInfo), (int)CodeInfoAccess.getCodeSize(codeInfo).rawValue());
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<byte[]> copyCodeInCompilerIsolate0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context, CodePointer codeStart, int codeSize) {
        byte[] code = new byte[codeSize];
        CTypeConversion.asByteBuffer((PointerBase)codeStart, (int)codeSize).get(code);
        return IsolatedCompileContext.get().hand(code);
    }
}

