/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted.runtimecompilation;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.RuntimeCompilationCanaryFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.nodes.InlinedInvokeArgumentsNode;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.TruffleRuntimeCompilationSupport;
import com.oracle.svm.graal.hosted.DeoptimizationFeature;
import com.oracle.svm.graal.hosted.GraalCompilerFeature;
import com.oracle.svm.graal.hosted.runtimecompilation.CallTreeInfo;
import com.oracle.svm.graal.hosted.runtimecompilation.GraalGraphObjectReplacer;
import com.oracle.svm.graal.hosted.runtimecompilation.GraphPrepareMetaAccessExtensionProvider;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompilationAlwaysInlineScope;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompilationCandidate;
import com.oracle.svm.graal.hosted.runtimecompilation.RuntimeCompiledMethodSupport;
import com.oracle.svm.graal.hosted.runtimecompilation.SubstrateGraalCompilerSetup;
import com.oracle.svm.graal.hosted.runtimecompilation.SubstrateProviders;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.RuntimeCompilationCallbacks;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.SVMParsingSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyUtils;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.graal.compiler.api.runtime.GraalRuntime;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.BytecodeParserOptions;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.NodeClassMap;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.truffle.phases.DeoptimizeOnExceptionPhase;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public final class RuntimeCompilationFeature
implements Feature,
RuntimeCompilationCallbacks {
    private GraalGraphObjectReplacer objectReplacer;
    private HostedProviders hostedProviders;
    private GraphEncoder graphEncoder;
    private boolean initialized;
    private GraphBuilderConfiguration graphBuilderConfig;
    private OptimisticOptimizations optimisticOpts;
    private RuntimeCompilationCandidatePredicate runtimeCompilationCandidatePredicate;
    private boolean runtimeCompilationCandidatePredicateUpdated = false;
    private Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;
    private SubstrateUniverseFactory universeFactory = new SubstrateUniverseFactory();
    private final Set<AnalysisMethod> registeredRuntimeCompilations = ConcurrentHashMap.newKeySet();
    private final Set<SubstrateMethod> substrateAnalysisMethods = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisMethod, String> invalidForRuntimeCompilation = new ConcurrentHashMap<AnalysisMethod, String>();
    private final Set<RuntimeCompilationCandidate> runtimeCompilationCandidates = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> runtimeCompilationsFailedDuringParsing = ConcurrentHashMap.newKeySet();
    private CallTreeInfo callTreeMetadata = null;
    private HostedProviders analysisProviders = null;
    private AllowInliningPredicate allowInliningPredicate = (builder, target) -> AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
    private boolean allowInliningPredicateUpdated = false;
    private Function<ConstantFieldProvider, ConstantFieldProvider> constantFieldProviderWrapper = Function.identity();
    private Consumer<CallTreeInfo> blocklistChecker = ignore -> {};
    boolean newRuntimeMethodsSeen = false;

    public static RuntimeCompilationFeature singleton() {
        return (RuntimeCompilationFeature)ImageSingletons.lookup(RuntimeCompilationFeature.class);
    }

    public HostedProviders getHostedProviders() {
        return this.hostedProviders;
    }

    public GraalGraphObjectReplacer getObjectReplacer() {
        return this.objectReplacer;
    }

    public void setUniverseFactory(SubstrateUniverseFactory universeFactory) {
        this.universeFactory = universeFactory;
    }

    private static boolean defaultAllowRuntimeCompilation(ResolvedJavaMethod method) {
        return false;
    }

    public void initializeRuntimeCompilationForTesting(FeatureImpl.BeforeAnalysisAccessImpl config, RuntimeCompilationCandidatePredicate newRuntimeCompilationCandidatePredicate) {
        this.initializeRuntimeCompilationConfiguration(this.hostedProviders, this.graphBuilderConfig, newRuntimeCompilationCandidatePredicate, this.deoptimizeOnExceptionPredicate, this.blocklistChecker);
        this.initializeRuntimeCompilationForTesting(config);
    }

    public void initializeRuntimeCompilationForTesting(FeatureImpl.BeforeAnalysisAccessImpl config) {
        this.initializeAnalysisProviders(config.getBigBang(), provider -> provider);
    }

    public void initializeRuntimeCompilationConfiguration(HostedProviders newHostedProviders, GraphBuilderConfiguration newGraphBuilderConfig, RuntimeCompilationCandidatePredicate newRuntimeCompilationCandidatePredicate, Predicate<ResolvedJavaMethod> newDeoptimizeOnExceptionPredicate, Consumer<CallTreeInfo> newBlocklistChecker) {
        VMError.guarantee(!this.initialized, "runtime compilation configuration already initialized");
        this.initialized = true;
        this.hostedProviders = newHostedProviders;
        this.graphBuilderConfig = newGraphBuilderConfig.withNodeSourcePosition(true).withOOMEExceptionEdges(GraphBuilderConfiguration.ExplicitOOMEExceptionEdges.DisableOOMEExceptionEdges);
        assert (!this.runtimeCompilationCandidatePredicateUpdated) : "Updated compilation predicate multiple times";
        this.runtimeCompilationCandidatePredicate = newRuntimeCompilationCandidatePredicate;
        this.runtimeCompilationCandidatePredicateUpdated = true;
        this.deoptimizeOnExceptionPredicate = newDeoptimizeOnExceptionPredicate;
        this.blocklistChecker = newBlocklistChecker;
    }

    public SubstrateMethod requireFrameInformationForMethod(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config, boolean registerAsRoot) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        assert (aMethod.isOriginalMethod());
        AnalysisMethod deoptTarget = aMethod.getOrCreateMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
        SubstrateCompilationDirectives.singleton().registerFrameInformationRequired(aMethod, deoptTarget);
        if (registerAsRoot) {
            config.registerAsRoot(aMethod, true, "Frame information required, registered in " + String.valueOf(RuntimeCompilationFeature.class), SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
        }
        return sMethod;
    }

    public SubstrateMethod prepareMethodForRuntimeCompilation(Executable method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        return this.prepareMethodForRuntimeCompilation((ResolvedJavaMethod)config.getMetaAccess().lookupJavaMethod(method), config);
    }

    public void registerAllowInliningPredicate(AllowInliningPredicate predicate) {
        assert (!this.allowInliningPredicateUpdated);
        this.allowInliningPredicate = predicate;
        this.allowInliningPredicateUpdated = true;
    }

    public void initializeAnalysisProviders(BigBang bb, Function<ConstantFieldProvider, ConstantFieldProvider> generator) {
        HostedProviders defaultProviders = bb.getProviders(MultiMethod.ORIGINAL_METHOD);
        HostedProviders customHostedProviders = defaultProviders.copyWith(generator.apply(defaultProviders.getConstantFieldProvider()));
        this.constantFieldProviderWrapper = generator;
        customHostedProviders.setGraphBuilderPlugins(this.hostedProviders.getGraphBuilderPlugins());
        this.analysisProviders = customHostedProviders;
    }

    public String[] getCallTrace(CallTreeInfo callTreeInfo, AnalysisMethod method) {
        return CallTreeInfo.getCallTrace(callTreeInfo, method, this.registeredRuntimeCompilations);
    }

    public String[] getCallTrace(CallTreeInfo callTreeInfo, RuntimeCompilationCandidate candidate) {
        return CallTreeInfo.getCallTrace(callTreeInfo, candidate, this.registeredRuntimeCompilations);
    }

    public CallTreeInfo getCallTreeInfo() {
        VMError.guarantee(this.callTreeMetadata != null);
        return this.callTreeMetadata;
    }

    public Collection<RuntimeCompilationCandidate> getAllRuntimeCompilationCandidates() {
        return this.runtimeCompilationCandidates;
    }

    public SubstrateMethod prepareMethodForRuntimeCompilation(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        assert (aMethod.isOriginalMethod());
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        this.substrateAnalysisMethods.add(sMethod);
        if (this.registeredRuntimeCompilations.add(aMethod)) {
            aMethod.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
            RuntimeCompilationFeature.getStubDeoptVersion(aMethod);
            config.registerAsRoot(aMethod, true, "Runtime compilation, registered in " + String.valueOf(RuntimeCompilationFeature.class), SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD, SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
        }
        return sMethod;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(RuntimeCompilationCanaryFeature.class, DeoptimizationFeature.class, GraalCompilerFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SVMParsingSupport.class, (Object)new RuntimeCompilationParsingSupport());
        ImageSingletons.add(HostVM.MultiMethodAnalysisPolicy.class, (Object)new RuntimeCompilationAnalysisPolicy());
        ImageSingletons.add(RuntimeCompilationCallbacks.class, (Object)this);
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        if (SubstrateOptions.useLLVMBackend()) {
            throw UserError.abort("Runtime compilation is currently unimplemented on the LLVM backend (GR-43073).", new Object[0]);
        }
        ImageSingletons.add(TruffleRuntimeCompilationSupport.class, (Object)new TruffleRuntimeCompilationSupport());
        if (!ImageSingletons.contains(SubstrateGraalCompilerSetup.class)) {
            ImageSingletons.add(SubstrateGraalCompilerSetup.class, (Object)new SubstrateGraalCompilerSetup());
        }
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        AnalysisMetaAccess aMetaAccess = config.getMetaAccess();
        SubstrateWordTypes wordTypes = new SubstrateWordTypes((MetaAccessProvider)aMetaAccess, ConfigurationValues.getWordKind());
        SubstrateProviders substrateProviders = ((SubstrateGraalCompilerSetup)ImageSingletons.lookup(SubstrateGraalCompilerSetup.class)).getSubstrateProviders(aMetaAccess, wordTypes);
        this.objectReplacer = new GraalGraphObjectReplacer(config.getUniverse(), substrateProviders, this.universeFactory);
        config.registerObjectReplacer(this.objectReplacer);
    }

    private void installRuntimeConfig(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Function<Providers, SubstrateBackend> backendProvider = TruffleRuntimeCompilationSupport.getRuntimeBackendProvider();
        ClassInitializationSupport classInitializationSupport = config.getHostVM().getClassInitializationSupport();
        SubstratePlatformConfigurationProvider platformConfig = new SubstratePlatformConfigurationProvider(((BarrierSetProvider)ImageSingletons.lookup(BarrierSetProvider.class)).createBarrierSet((MetaAccessProvider)config.getMetaAccess()));
        RuntimeConfiguration runtimeConfig = ((SubstrateGraalCompilerSetup)ImageSingletons.lookup(SubstrateGraalCompilerSetup.class)).createRuntimeConfigurationBuilder((OptionValues)RuntimeOptionValues.singleton(), config.getHostVM(), config.getUniverse(), (UniverseMetaAccess)config.getMetaAccess(), backendProvider, classInitializationSupport, platformConfig, config.getBigBang().getSnippetReflectionProvider()).build();
        Providers runtimeProviders = runtimeConfig.getProviders();
        this.hostedProviders = new HostedProviders(runtimeProviders.getMetaAccess(), runtimeProviders.getCodeCache(), runtimeProviders.getConstantReflection(), runtimeProviders.getConstantFieldProvider(), runtimeProviders.getForeignCalls(), runtimeProviders.getLowerer(), runtimeProviders.getReplacements(), runtimeProviders.getStampProvider(), runtimeConfig.getProviders().getSnippetReflection(), runtimeProviders.getWordTypes(), runtimeProviders.getPlatformConfigurationProvider(), (MetaAccessExtensionProvider)new GraphPrepareMetaAccessExtensionProvider(), runtimeProviders.getLoopsDataProvider(), runtimeProviders.getIdentityHashCodeProvider());
        FeatureHandler featureHandler = config.getFeatureHandler();
        boolean supportsStubBasedPlugins = !SubstrateOptions.useLLVMBackend();
        NativeImageGenerator.registerGraphBuilderPlugins(featureHandler, runtimeConfig, this.hostedProviders, config.getMetaAccess(), config.getUniverse(), config.getNativeLibraries(), config.getImageClassLoader(), ParsingReason.JITCompilation, ((Inflation)config.getBigBang()).getAnnotationSubstitutionProcessor(), new SubstrateClassInitializationPlugin(config.getHostVM()), ConfigurationValues.getTarget(), supportsStubBasedPlugins);
        NativeImageGenerator.registerReplacements(DebugContext.forCurrentThread(), featureHandler, runtimeConfig, runtimeConfig.getProviders(), false, true, new RuntimeCompiledMethodSupport.RuntimeCompilationGraphEncoder(ConfigurationValues.getTarget().arch, config.getUniverse().getHeapScanner()));
        featureHandler.forEachGraalFeature(feature -> feature.registerCodeObserver(runtimeConfig));
        Suites suites = NativeImageGenerator.createSuites(featureHandler, runtimeConfig, false);
        LIRSuites lirSuites = NativeImageGenerator.createLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        Suites firstTierSuites = NativeImageGenerator.createFirstTierSuites(featureHandler, runtimeConfig, false);
        LIRSuites firstTierLirSuites = NativeImageGenerator.createFirstTierLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        TruffleRuntimeCompilationSupport.setRuntimeConfig(runtimeConfig, suites, lirSuites, firstTierSuites, firstTierLirSuites);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess c) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)c;
        this.installRuntimeConfig(config);
        SubstrateGraalRuntime graalRuntime = new SubstrateGraalRuntime();
        this.objectReplacer.setGraalRuntime(graalRuntime);
        this.objectReplacer.setAnalysisAccess(config);
        ImageSingletons.add(GraalRuntime.class, (Object)graalRuntime);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(new GraalSupport.GraalShutdownHook());
        this.graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.hostedProviders.getGraphBuilderPlugins()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly);
        this.runtimeCompilationCandidatePredicate = RuntimeCompilationFeature::defaultAllowRuntimeCompilation;
        this.optimisticOpts = OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
        this.graphEncoder = new RuntimeCompiledMethodSupport.RuntimeCompilationGraphEncoder(ConfigurationValues.getTarget().arch, config.getUniverse().getHeapScanner());
        SubstrateReplacements replacements = (SubstrateReplacements)TruffleRuntimeCompilationSupport.getRuntimeConfig().getProviders().getReplacements();
        for (NodeClass nodeClass : replacements.getSnippetNodeClasses()) {
            config.getMetaAccess().lookupJavaType(nodeClass.getClazz()).registerAsInstantiated((Object)("All " + NodeClass.class.getName() + " classes are marked as instantiated eagerly."));
        }
        Function<Object, Object> objectTransformer = object -> {
            if (object instanceof JavaConstant) {
                JavaConstant constant = (JavaConstant)object;
                return SubstrateGraalUtils.runtimeToHosted(constant, config.getUniverse().getHeapScanner());
            }
            return object;
        };
        NativeImageGenerator.performSnippetGraphAnalysis(config.getBigBang(), replacements, config.getBigBang().getOptions(), objectTransformer);
        for (ResolvedJavaMethod method : replacements.getSnippetMethods()) {
            this.objectReplacer.apply(method);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess c) {
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)c;
        if (this.newRuntimeMethodsSeen) {
            SubstrateMethod[] methodsToCompileArr = (SubstrateMethod[])this.substrateAnalysisMethods.stream().toArray(SubstrateMethod[]::new);
            TruffleRuntimeCompilationSupport.setMethodsToCompile(config, methodsToCompileArr);
            config.requireAnalysisIteration();
            this.newRuntimeMethodsSeen = false;
        }
        this.graphEncoder.finishPrepare();
        AnalysisMetaAccess metaAccess = config.getMetaAccess();
        NodeClassMap nodeClasses = this.graphEncoder.getNodeClasses();
        for (NodeClass nodeClass : nodeClasses) {
            metaAccess.lookupJavaType(nodeClass.getClazz()).registerAsInstantiated((Object)("All " + NodeClass.class.getName() + " classes are marked as instantiated eagerly."));
        }
        if (TruffleRuntimeCompilationSupport.setGraphEncoding(config, this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), nodeClasses)) {
            config.requireAnalysisIteration();
        }
    }

    private void checkMaxRuntimeCompiledMethods(CallTreeInfo callTreeInfo) {
        int maxMethods = 0;
        for (String value : Options.MaxRuntimeCompileMethods.getValue().values()) {
            String numberStr = null;
            try {
                numberStr = value.split("#")[0];
                maxMethods += Integer.parseInt(numberStr);
            }
            catch (NumberFormatException ex) {
                throw UserError.abort("Invalid value for option 'MaxRuntimeCompileMethods': '%s' is not a valid number", numberStr);
            }
        }
        if (Options.EnforceMaxRuntimeCompileMethods.getValue().booleanValue() && maxMethods != 0 && callTreeInfo.runtimeCompilations().size() > maxMethods) {
            CallTreeInfo.printDeepestPath(callTreeInfo, this.registeredRuntimeCompilations);
            throw VMError.shouldNotReachHere("Number of methods for runtime compilation exceeds the allowed limit: " + callTreeInfo.runtimeCompilations().size() + " > " + maxMethods);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        VMError.guarantee(this.callTreeMetadata == null);
        this.callTreeMetadata = CallTreeInfo.create(((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse(), this.invalidForRuntimeCompilation);
        if (!this.runtimeCompilationsFailedDuringParsing.isEmpty()) {
            System.out.println("PermanentBailouts seen while parsing runtime compiled methods. One reason for this can be encountering invalid frame states.");
            for (AnalysisMethod failedMethod : this.runtimeCompilationsFailedDuringParsing) {
                this.printFailingRuntimeMethodTrace(this.callTreeMetadata, failedMethod, failedMethod);
            }
        }
        ProgressReporter.singleton().setNumRuntimeCompiledMethods(this.callTreeMetadata.runtimeCompilations().size());
        this.objectReplacer.forbidNewTypes();
        VMError.guarantee(this.callTreeMetadata != null);
        if (Options.PrintRuntimeCompileMethods.getValue().booleanValue()) {
            System.out.println("****Start Print Runtime Compile Methods***");
            this.callTreeMetadata.runtimeCompilations().stream().map(m -> m.getRuntimeMethod().format("%H.%n(%p)")).sorted().toList().forEach(System.out::println);
            System.out.println("****End Print Runtime Compile Methods***");
        }
        if (Options.PrintRuntimeCompilationCallTree.getValue().booleanValue()) {
            System.out.println("****Start Print Runtime Compile Call Tree***");
            CallTreeInfo.printCallTree(this.callTreeMetadata, this.registeredRuntimeCompilations);
            System.out.println("****End Print Runtime Compile Call Tree***");
        }
        this.checkMaxRuntimeCompiledMethods(this.callTreeMetadata);
    }

    @Override
    public void onCompileQueueCreation(BigBang bb, HostedUniverse hUniverse, CompileQueue compileQueue) {
        this.graphEncoder = null;
        Stream<HostedMethod> methodsToCompile = hUniverse.getMethods().stream().map(method -> method.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD)).filter(method -> {
            if (method != null) {
                AnalysisMethod aMethod = method.getWrapped();
                return aMethod.isImplementationInvoked() && !this.invalidForRuntimeCompilation.containsKey(aMethod);
            }
            return false;
        });
        RuntimeCompiledMethodSupport.onCompileQueueCreation(bb, hUniverse, compileQueue, this.hostedProviders, this.constantFieldProviderWrapper, this.objectReplacer, this.registeredRuntimeCompilations, methodsToCompile);
    }

    public void afterCompilation(Feature.AfterCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterCompilation(hUniverse, config.getProviders());
    }

    public void beforeHeapLayout(Feature.BeforeHeapLayoutAccess a) {
        this.objectReplacer.registerImmutableObjects(a);
        TruffleRuntimeCompilationSupport.registerImmutableObjects(a);
        ((SubstrateReplacements)TruffleRuntimeCompilationSupport.getRuntimeConfig().getProviders().getReplacements()).registerImmutableObjects(a);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess a) {
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterHeapLayout(hUniverse);
    }

    @Override
    public void reportAnalysisError(AnalysisUniverse aUniverse, Throwable t) {
        CallTreeInfo treeInfo = CallTreeInfo.create(aUniverse, this.invalidForRuntimeCompilation);
        this.blocklistChecker.accept(treeInfo);
        this.checkMaxRuntimeCompiledMethods(treeInfo);
        if (t instanceof ParallelExecutionException) {
            ParallelExecutionException exception = (ParallelExecutionException)t;
            for (Throwable e : exception.getExceptions()) {
                AnalysisError.ParsingError parsingError;
                AnalysisMethod errorMethod;
                if (!(e instanceof AnalysisError.ParsingError) || !SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)(errorMethod = (parsingError = (AnalysisError.ParsingError)e).getMethod())) && !SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)errorMethod)) continue;
                AnalysisMethod failingRuntimeMethod = null;
                if (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)errorMethod)) {
                    failingRuntimeMethod = errorMethod;
                } else if (SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)errorMethod)) {
                    failingRuntimeMethod = errorMethod.getMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
                }
                this.printFailingRuntimeMethodTrace(treeInfo, failingRuntimeMethod, errorMethod);
                System.out.println("error: " + e.getMessage());
            }
        }
    }

    private void printFailingRuntimeMethodTrace(CallTreeInfo treeInfo, AnalysisMethod failingRuntimeMethod, AnalysisMethod errorMethod) {
        System.out.println("Parsing failed on a special method version: " + errorMethod.format("%H.%n"));
        System.out.println("Method reachability trace");
        if (failingRuntimeMethod != null) {
            Arrays.stream(CallTreeInfo.getCallTrace(treeInfo, failingRuntimeMethod, this.registeredRuntimeCompilations)).forEach(System.out::println);
        } else {
            System.out.println("trace unavailable");
        }
    }

    private static <T extends AnalysisMethod> T getStubDeoptVersion(T implementation) {
        return (T)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
    }

    private static <T extends AnalysisMethod> T getFullDeoptVersion(BigBang bb, T implementation, InvokeTypeFlow parsingReason) {
        PointsToAnalysisMethod runtimeMethod = (PointsToAnalysisMethod)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
        PointsToAnalysis analysis = (PointsToAnalysis)bb;
        runtimeMethod.getTypeFlow().updateFlowsGraph(analysis, MethodFlowsGraph.GraphKind.FULL, parsingReason, true);
        return (T)runtimeMethod;
    }

    private static <T extends AnalysisMethod> T getStubRuntimeVersion(T implementation) {
        return (T)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD, newMethod -> ((PointsToAnalysisMethod)newMethod).getTypeFlow().setAsStubFlow());
    }

    private static <T extends AnalysisMethod> T getFullRuntimeVersion(BigBang bb, T implementation, InvokeTypeFlow parsingReason) {
        PointsToAnalysisMethod runtimeMethod = (PointsToAnalysisMethod)implementation.getOrCreateMultiMethod(SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
        PointsToAnalysis analysis = (PointsToAnalysis)bb;
        runtimeMethod.getTypeFlow().updateFlowsGraph(analysis, MethodFlowsGraph.GraphKind.FULL, parsingReason, false);
        return (T)runtimeMethod;
    }

    public static interface AllowInliningPredicate {
        public InlineDecision allowInlining(GraphBuilderContext var1, ResolvedJavaMethod var2);

        public static enum InlineDecision {
            INLINE,
            INLINING_DISALLOWED,
            NO_DECISION;

        }
    }

    public static interface RuntimeCompilationCandidatePredicate {
        public boolean allowRuntimeCompilation(ResolvedJavaMethod var1);
    }

    private final class RuntimeCompilationParsingSupport
    implements SVMParsingSupport {
        RuntimeCompilationInlineBeforeAnalysisPolicy runtimeInlineBeforeAnalysisPolicy = null;

        private RuntimeCompilationParsingSupport() {
        }

        @Override
        public HostedProviders getHostedProviders(MultiMethod.MultiMethodKey key) {
            if (key == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                assert (RuntimeCompilationFeature.this.analysisProviders != null);
                return RuntimeCompilationFeature.this.analysisProviders;
            }
            return null;
        }

        @Override
        public boolean allowAssumptions(AnalysisMethod method) {
            return method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }

        @Override
        public boolean recordInlinedMethods(AnalysisMethod method) {
            return method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }

        @Override
        public Object parseGraph(BigBang bb, DebugContext debug, AnalysisMethod method) {
            if (method.getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return this.parseRuntimeCompiledMethod(bb, debug, method);
            }
            return HostVM.PARSING_UNHANDLED;
        }

        @Override
        public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
            if (SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)method)) {
                return config.withOmitAssertions(RuntimeCompilationFeature.this.graphBuilderConfig.omitAssertions()).withRetainLocalVariables(false);
            }
            return config;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object parseRuntimeCompiledMethod(BigBang bb, DebugContext debug, AnalysisMethod method) {
            boolean parsed = false;
            StructuredGraph graph = method.buildGraph(debug, method, RuntimeCompilationFeature.this.analysisProviders, GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION);
            if (graph == null) {
                if (!method.hasBytecodes()) {
                    this.recordFailed(method);
                    RuntimeCompilationFeature.this.runtimeCompilationsFailedDuringParsing.add(method);
                    return HostVM.PARSING_FAILED;
                }
                parsed = true;
                graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.YES).method((ResolvedJavaMethod)method).recordInlinedMethods(true).build();
            }
            try {
                DebugContext.Scope scope = debug.scope((Object)"RuntimeCompile", (Object)graph, (Object)method);
                try {
                    if (parsed) {
                        try (Indent indent2 = debug.logAndIndent("parse graph phases");){
                            RuntimeCompiledMethodSupport.RuntimeGraphBuilderPhase.createRuntimeGraphBuilderPhase(bb, (Providers)RuntimeCompilationFeature.this.analysisProviders, RuntimeCompilationFeature.this.graphBuilderConfig, RuntimeCompilationFeature.this.optimisticOpts).apply(graph);
                        }
                        catch (PermanentBailoutException ex) {
                            bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getLocalizedMessage(), null, (Throwable)ex);
                            this.recordFailed(method);
                            RuntimeCompilationFeature.this.runtimeCompilationsFailedDuringParsing.add(method);
                            Object object = HostVM.PARSING_FAILED;
                            if (scope == null) return object;
                            scope.close();
                            return object;
                        }
                    }
                    CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
                    canonicalizer.apply(graph, (Object)RuntimeCompilationFeature.this.analysisProviders);
                    if (RuntimeCompilationFeature.this.deoptimizeOnExceptionPredicate != null) {
                        new DeoptimizeOnExceptionPhase(RuntimeCompilationFeature.this.deoptimizeOnExceptionPredicate).apply(graph);
                    }
                    new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graph, (Object)RuntimeCompilationFeature.this.analysisProviders);
                    return graph;
                }
                finally {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
            return graph;
        }

        private void recordFailed(AnalysisMethod method) {
            RuntimeCompilationFeature.this.invalidForRuntimeCompilation.computeIfAbsent(method, m -> "generic failure");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateGraph(PointsToAnalysis bb, StructuredGraph graph) {
            PointsToAnalysisMethod aMethod = (PointsToAnalysisMethod)graph.method();
            MultiMethod.MultiMethodKey multiMethodKey = aMethod.getMultiMethodKey();
            Supplier<Boolean> graphChecker = DeoptimizationUtils.createGraphChecker(graph, multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD ? DeoptimizationUtils.RUNTIME_COMPILATION_INVALID_NODES : DeoptimizationUtils.AOT_COMPILATION_INVALID_NODES);
            if (multiMethodKey != MultiMethod.ORIGINAL_METHOD) {
                if (!graphChecker.get().booleanValue()) {
                    this.recordFailed((AnalysisMethod)aMethod);
                    return false;
                }
            } else if (DeoptimizationUtils.canDeoptForTesting((AnalysisMethod)aMethod, false, graphChecker)) {
                DeoptimizationUtils.registerDeoptEntriesForDeoptTesting(bb, graph, aMethod);
                return true;
            }
            if (multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                AnalysisMethod origMethod = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                Collection<ResolvedJavaMethod> recomputeMethods = DeoptimizationUtils.registerDeoptEntries(graph, RuntimeCompilationFeature.this.registeredRuntimeCompilations.contains(origMethod), deoptEntryMethod -> ((PointsToAnalysisMethod)deoptEntryMethod).getOrCreateMultiMethod(SubstrateCompilationDirectives.DEOPT_TARGET_METHOD));
                for (ResolvedJavaMethod method : recomputeMethods) {
                    assert (SubstrateCompilationDirectives.isDeoptTarget(method));
                    ((PointsToAnalysisMethod)method).getTypeFlow().updateFlowsGraph(bb, MethodFlowsGraph.GraphKind.FULL, null, true);
                }
                RuntimeCompilationParsingSupport runtimeCompilationParsingSupport = this;
                synchronized (runtimeCompilationParsingSupport) {
                    RuntimeCompilationFeature.this.newRuntimeMethodsSeen = true;
                    AnalysisMethod origAMethod = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                    assert (origAMethod != null);
                    SubstrateMethod sMethod = RuntimeCompilationFeature.this.objectReplacer.createMethod((ResolvedJavaMethod)origAMethod);
                    RuntimeCompilationFeature.this.substrateAnalysisMethods.add(sMethod);
                    RuntimeCompilationFeature.this.graphEncoder.prepare(graph);
                }
                assert (RuntimeCompiledMethodSupport.verifyNodes(graph));
            }
            return true;
        }

        @Override
        public void afterParsingHook(AnalysisMethod method, StructuredGraph graph) {
            if (SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)method)) {
                new RuntimeCompiledMethodSupport.ConvertMacroNodes().apply(graph);
            }
        }

        @Override
        public void initializeInlineBeforeAnalysisPolicy(SVMHost svmHost, InlineBeforeAnalysisPolicyUtils inliningUtils) {
            assert (this.runtimeInlineBeforeAnalysisPolicy == null) : this.runtimeInlineBeforeAnalysisPolicy;
            this.runtimeInlineBeforeAnalysisPolicy = new RuntimeCompilationInlineBeforeAnalysisPolicy(svmHost, inliningUtils);
        }

        @Override
        public InlineBeforeAnalysisPolicy inlineBeforeAnalysisPolicy(MultiMethod.MultiMethodKey multiMethodKey, InlineBeforeAnalysisPolicy defaultPolicy) {
            if (multiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                return defaultPolicy;
            }
            if (multiMethodKey == SubstrateCompilationDirectives.DEOPT_TARGET_METHOD) {
                return InlineBeforeAnalysisPolicy.NO_INLINING;
            }
            if (multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                assert (this.runtimeInlineBeforeAnalysisPolicy != null);
                return this.runtimeInlineBeforeAnalysisPolicy;
            }
            throw VMError.shouldNotReachHere("Unexpected method key: %s", multiMethodKey);
        }

        @Override
        public Function<AnalysisType, ResolvedJavaType> getStrengthenGraphsToTargetFunction(MultiMethod.MultiMethodKey key) {
            if (key == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return t -> RuntimeCompilationFeature.this.objectReplacer.typeCreated((JavaType)t) ? t : null;
            }
            return null;
        }
    }

    private final class RuntimeCompilationAnalysisPolicy
    implements HostVM.MultiMethodAnalysisPolicy {
        private RuntimeCompilationAnalysisPolicy() {
        }

        public <T extends AnalysisMethod> Collection<T> determineCallees(BigBang bb, T implementation, T target, MultiMethod.MultiMethodKey callerMultiMethodKey, InvokeTypeFlow invokeFlow) {
            boolean runtimeCompilationCandidate;
            if (invokeFlow.isDeoptInvokeTypeFlow()) {
                assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod(implementation));
                AnalysisMethod originalTarget = implementation.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                assert (originalTarget != null);
                RuntimeCompilationFeature.this.runtimeCompilationCandidates.add(new RuntimeCompilationCandidate(originalTarget, originalTarget));
                return List.of(RuntimeCompilationFeature.getStubDeoptVersion(implementation));
            }
            assert (implementation.isOriginalMethod() && target.isOriginalMethod());
            boolean registeredRuntimeCompilation = RuntimeCompilationFeature.this.registeredRuntimeCompilations.contains(implementation);
            if (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD) {
                if (registeredRuntimeCompilation) {
                    return List.of(implementation, RuntimeCompilationFeature.getStubDeoptVersion(implementation), RuntimeCompilationFeature.getFullRuntimeVersion(bb, implementation, invokeFlow));
                }
                if (SubstrateCompilationDirectives.singleton().isFrameInformationRequired((ResolvedJavaMethod)implementation)) {
                    return List.of(implementation, RuntimeCompilationFeature.getFullDeoptVersion(bb, implementation, invokeFlow));
                }
                if (DeoptimizationUtils.canDeoptForTesting(implementation, false, () -> false)) {
                    return List.of(implementation, RuntimeCompilationFeature.getStubDeoptVersion(implementation));
                }
                return List.of(implementation);
            }
            boolean bl = runtimeCompilationCandidate = registeredRuntimeCompilation || RuntimeCompilationFeature.this.runtimeCompilationCandidatePredicate.allowRuntimeCompilation((ResolvedJavaMethod)implementation);
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                RuntimeCompilationFeature.this.runtimeCompilationCandidates.add(new RuntimeCompilationCandidate(implementation, target));
                if (runtimeCompilationCandidate) {
                    return List.of(implementation, RuntimeCompilationFeature.getStubDeoptVersion(implementation), RuntimeCompilationFeature.getFullRuntimeVersion(bb, implementation, invokeFlow));
                }
                return List.of(implementation);
            }
            assert (callerMultiMethodKey == SubstrateCompilationDirectives.DEOPT_TARGET_METHOD);
            if (runtimeCompilationCandidate) {
                return List.of(implementation, RuntimeCompilationFeature.getStubDeoptVersion(implementation), RuntimeCompilationFeature.getStubRuntimeVersion(implementation));
            }
            return List.of(implementation);
        }

        public boolean performParameterLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return true;
            }
            if (callerMultiMethodKey == SubstrateCompilationDirectives.DEOPT_TARGET_METHOD) {
                return calleeMultiMethodKey == MultiMethod.ORIGINAL_METHOD;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean performReturnLinking(MultiMethod.MultiMethodKey callerMultiMethodKey, MultiMethod.MultiMethodKey calleeMultiMethodKey) {
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) {
                return calleeMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD || calleeMultiMethodKey == MultiMethod.ORIGINAL_METHOD;
            }
            if (callerMultiMethodKey == SubstrateCompilationDirectives.DEOPT_TARGET_METHOD) {
                return true;
            }
            assert (callerMultiMethodKey == MultiMethod.ORIGINAL_METHOD);
            return true;
        }

        public boolean canComputeReturnedParameterIndex(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey != SubstrateCompilationDirectives.DEOPT_TARGET_METHOD;
        }

        public boolean insertPlaceholderParamAndReturnFlows(MultiMethod.MultiMethodKey multiMethodKey) {
            return multiMethodKey == SubstrateCompilationDirectives.DEOPT_TARGET_METHOD || multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
        }

        public boolean unknownReturnValue(BigBang bb, MultiMethod.MultiMethodKey callerMultiMethodKey, AnalysisMethod implementation) {
            if (callerMultiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD || SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)implementation)) {
                AnalysisMethod origImpl = implementation.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
                OptionValues options = bb.getOptions();
                return RuntimeCompilationFeature.this.hostedProviders.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)origImpl, options) != null || RuntimeCompilationFeature.this.hostedProviders.getReplacements().hasSubstitution((ResolvedJavaMethod)origImpl, options);
            }
            return false;
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> PrintRuntimeCompilationCallTree = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> MaxRuntimeCompileMethods = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<Boolean> EnforceMaxRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> RuntimeCompilationInlineBeforeAnalysis = new HostedOptionKey<Boolean>(true);
    }

    private class RuntimeCompilationInlineBeforeAnalysisPolicy
    extends InlineBeforeAnalysisPolicy {
        private final int trivialAllowingInliningDepth;
        final SVMHost hostVM;
        final InlineBeforeAnalysisPolicyUtils inliningUtils;

        protected RuntimeCompilationInlineBeforeAnalysisPolicy(SVMHost hostVM, InlineBeforeAnalysisPolicyUtils inliningUtils) {
            super(new NodePlugin[]{new ConstantFoldLoadFieldPlugin(ParsingReason.PointsToAnalysis)});
            this.trivialAllowingInliningDepth = (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton());
            this.hostVM = hostVM;
            this.inliningUtils = inliningUtils;
        }

        protected boolean tryInvocationPlugins() {
            return true;
        }

        protected boolean needsExplicitExceptions() {
            return false;
        }

        protected boolean shouldOmitIntermediateMethodInState(AnalysisMethod method) {
            return false;
        }

        protected FixedWithNextNode processInvokeArgs(AnalysisMethod targetMethod, FixedWithNextNode insertionPoint, ValueNode[] arguments, NodeSourcePosition sourcePosition) {
            StructuredGraph graph = insertionPoint.graph();
            assert (SubstrateCompilationDirectives.isRuntimeCompiledMethod((ResolvedJavaMethod)targetMethod)) : targetMethod;
            InlinedInvokeArgumentsNode newNode = (InlinedInvokeArgumentsNode)graph.add((Node)new InlinedInvokeArgumentsNode((ResolvedJavaMethod)targetMethod, arguments));
            newNode.setNodeSourcePosition(sourcePosition);
            graph.addAfterFixed(insertionPoint, (FixedNode)newNode);
            return newNode;
        }

        protected boolean shouldInlineInvoke(GraphBuilderContext b, InlineBeforeAnalysisPolicy.AbstractPolicyScope policyScope, AnalysisMethod method, ValueNode[] args) {
            if (RuntimeCompilationFeature.this.allowInliningPredicate.allowInlining(b, (ResolvedJavaMethod)method) != AllowInliningPredicate.InlineDecision.INLINE) {
                return false;
            }
            InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope accScope = policyScope instanceof RuntimeCompilationAlwaysInlineScope ? null : (InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)policyScope;
            return this.inliningUtils.shouldInlineInvoke(b, this.hostVM, accScope, method);
        }

        protected InlineInvokePlugin.InlineInfo createInvokeInfo(AnalysisMethod method) {
            AnalysisMethod runtimeMethod = RuntimeCompilationFeature.getStubRuntimeVersion(method);
            return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)runtimeMethod);
        }

        protected InlineBeforeAnalysisPolicy.AbstractPolicyScope createRootScope() {
            return null;
        }

        protected InlineBeforeAnalysisPolicy.AbstractPolicyScope openCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope outer, AnalysisMethod caller, AnalysisMethod method) {
            int inliningDepth;
            if (outer instanceof InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope) {
                InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope accOuter = (InlineBeforeAnalysisPolicyUtils.AccumulativeInlineScope)outer;
                return this.inliningUtils.createAccumulativeInlineScope(accOuter, caller, method, DeoptimizationUtils.RUNTIME_COMPILATION_INVALID_NODES);
            }
            assert (outer == null || outer instanceof RuntimeCompilationAlwaysInlineScope) : "unexpected outer scope: " + String.valueOf(outer);
            boolean trivialInlineAllowed = this.hostVM.isAnalysisTrivialMethod(method) && !InlineBeforeAnalysisPolicyUtils.isMethodHandleIntrinsificationRoot((ResolvedJavaMethod)method);
            int n = inliningDepth = outer == null ? 1 : outer.inliningDepth + 1;
            if (trivialInlineAllowed && inliningDepth <= this.trivialAllowingInliningDepth) {
                return new RuntimeCompilationAlwaysInlineScope(inliningDepth);
            }
            return this.inliningUtils.createAccumulativeInlineScope(null, caller, method, DeoptimizationUtils.RUNTIME_COMPILATION_INVALID_NODES);
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(RuntimeCompilationFeature.class);
        }
    }
}

