/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows.headers;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class WindowsDirectives
implements CContext.Directives {
    private static final String[] windowsLibs = new String[]{"<windows.h>", "<winsock.h>", "<process.h>", "<stdio.h>", "<stdlib.h>", "<string.h>", "<io.h>", "<math.h>"};

    public boolean isInConfiguration() {
        return Platform.includedIn(InternalPlatform.WINDOWS_BASE.class);
    }

    public List<String> getHeaderFiles() {
        if (Platform.includedIn(InternalPlatform.WINDOWS_BASE.class)) {
            return new ArrayList<String>(Arrays.asList(windowsLibs));
        }
        throw VMError.shouldNotReachHere("Unsupported OS");
    }

    public List<String> getMacroDefinitions() {
        return Arrays.asList("_WIN64");
    }
}

