/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.Uninterruptible;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.UnsignedWord;

public final class UnsignedUtils {
    public static final UnsignedWord MAX_VALUE = Word.unsigned((long)-1L);

    private UnsignedUtils() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord roundDown(UnsignedWord that, UnsignedWord multiple) {
        return that.unsignedDivide(multiple).multiply(multiple);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord roundUp(UnsignedWord that, UnsignedWord multiple) {
        return UnsignedUtils.roundDown(that.add(multiple.subtract(1)), multiple);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isAMultiple(UnsignedWord that, UnsignedWord multiple) {
        return that.unsignedRemainder(multiple).equal(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord min(UnsignedWord x, UnsignedWord y) {
        return x.belowOrEqual(y) ? x : y;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord max(UnsignedWord x, UnsignedWord y) {
        return x.aboveOrEqual(y) ? x : y;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int safeToInt(UnsignedWord w) {
        long l = w.rawValue();
        assert (l >= 0L && l == (long)((int)l));
        return (int)l;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord clamp(UnsignedWord value, UnsignedWord min, UnsignedWord max) {
        assert (min.belowOrEqual(max));
        return UnsignedUtils.min(UnsignedUtils.max(value, min), max);
    }

    public static double toDouble(UnsignedWord u) {
        long l = u.rawValue();
        if (l >= 0L) {
            return l;
        }
        return (double)(l >>> 1 | l & 1L) * 2.0;
    }

    public static UnsignedWord fromDouble(double d) {
        long l = (long)d;
        if (Double.isNaN(d) || l <= 0L) {
            return (UnsignedWord)Word.zero();
        }
        if (l < Long.MAX_VALUE) {
            return Word.unsigned((long)l);
        }
        l = (long)(d / 2.0);
        if (l == Long.MAX_VALUE) {
            return MAX_VALUE;
        }
        return Word.unsigned((long)l).shiftLeft(1);
    }
}

