/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.BasedOnJDKFile;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class PlatformTimeUtils {
    private long last = 0L;

    @Fold
    public static PlatformTimeUtils singleton() {
        return (PlatformTimeUtils)ImageSingletons.lookup(PlatformTimeUtils.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PlatformTimeUtils() {
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly allocate a SecondsNanos object.", calleeMustBe=false)
    protected static SecondsNanos allocateSecondsNanosInterruptibly(long seconds, long nanos) {
        return PlatformTimeUtils.allocateSecondsNanos0(seconds, nanos);
    }

    private static SecondsNanos allocateSecondsNanos0(long seconds, long nanos) {
        return new SecondsNanos(seconds, nanos);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+5/src/hotspot/share/jfr/recorder/repository/jfrChunk.cpp#L38-L52")
    public long nanosNow() {
        SecondsNanos t = this.javaTimeSystemUTC();
        long seconds = t.seconds;
        long nanos = t.nanos;
        long now = seconds * 1000000000L + nanos;
        if (now > this.last) {
            this.last = now;
        }
        return this.last;
    }

    public abstract SecondsNanos javaTimeSystemUTC();

    public record SecondsNanos(long seconds, long nanos) {
    }
}

