/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.SafepointCheckCounter;
import com.oracle.svm.core.thread.ThreadSuspendSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.word.LocationIdentity;

public class SafepointSlowpath {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_SAFEPOINT_CHECK = SnippetRuntime.findForeignCall(SafepointSlowpath.class, "enterSlowPathSafepointCheck", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS = SnippetRuntime.findForeignCall(SafepointSlowpath.class, "enterSlowPathTransitionFromNativeToNewStatus", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_PATH_RUN_PENDING_ACTIONS = SnippetRuntime.findForeignCall(SafepointSlowpath.class, "enterSlowPathRunPendingActions", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ENTER_SLOW_PATH_SAFEPOINT_CHECK, ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS, SLOW_PATH_RUN_PENDING_ACTIONS};

    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void enterSlowPathRunPendingActions() {
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "must be already back in Java mode");
        assert (VMThreads.ActionOnTransitionToJavaSupport.isActionPending()) : "must not be called otherwise";
        VMThreads.ActionOnTransitionToJavaSupport.runPendingActions();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathSafepointCheck() throws Throwable {
        SafepointSlowpath.slowPathSafepointCheck();
    }

    @AlwaysInline(value="Always inline into foreign call stub")
    @Uninterruptible(reason="Must not contain safepoint checks", mayBeInlined=true)
    public static void slowPathSafepointCheck() throws Throwable {
        if (VMThreads.SafepointBehavior.ignoresSafepoints()) {
            SafepointCheckCounter.setVolatile(Integer.MAX_VALUE);
            return;
        }
        VMError.guarantee(VMThreads.StatusSupport.isStatusJava(), "Attempting to do a safepoint check when not in Java mode");
        SafepointSlowpath.slowPathSafepointCheck(1, false, false);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Must not contain safepoint checks")
    private static void enterSlowPathTransitionFromNativeToNewStatus(int newStatus, boolean popFrameAnchor) throws Throwable {
        VMError.guarantee(VMThreads.StatusSupport.isStatusNativeOrSafepoint(), "Must either be at a safepoint or in native mode");
        VMError.guarantee(!VMThreads.SafepointBehavior.ignoresSafepoints(), "The safepoint handling doesn't change the status of threads that ignore safepoints. So, the fast path transition must succeed and this slow path must not be called");
        SafepointSlowpath.slowPathSafepointCheck(newStatus, true, popFrameAnchor);
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void slowPathSafepointCheck(int newStatus, boolean callerHasJavaFrameAnchor, boolean popFrameAnchor) throws Throwable {
        try {
            SafepointSlowpath.slowPathSafepointCheck0(newStatus, callerHasJavaFrameAnchor, popFrameAnchor);
        }
        catch (RecurringCallbackSupport.SafepointException e) {
            throw RecurringCallbackSupport.RecurringCallbackTimer.getAndClearPendingException();
        }
        catch (Throwable ex) {
            VMError.shouldNotReachHere(ex);
        }
    }

    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void slowPathSafepointCheck0(int newStatus, boolean callerHasJavaFrameAnchor, boolean popFrameAnchor) {
        if (Safepoint.singleton().isMasterThread()) {
            assert (RecurringCallbackSupport.isCallbackUnsupportedOrTimerSuspended());
        } else {
            do {
                if (!Safepoint.singleton().isPendingOrInProgress() && !ThreadSuspendSupport.isCurrentThreadSuspended()) continue;
                SafepointSlowpath.freezeAtSafepoint(newStatus, callerHasJavaFrameAnchor);
                assert (VMThreads.StatusSupport.getStatusVolatile() == newStatus) : "Transition to the new thread status must have been successful.";
            } while (VMThreads.StatusSupport.getStatusVolatile() != newStatus && !VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus));
        }
        assert (VMThreads.StatusSupport.getStatusVolatile() == newStatus) : "Transition to the new thread status must have been successful.";
        if (popFrameAnchor) {
            assert (newStatus == 1);
            JavaFrameAnchors.popFrameAnchor();
        }
        if (newStatus == 1) {
            VMThreads.ActionOnTransitionToJavaSupport.runPendingActions();
            RecurringCallbackSupport.maybeExecuteCallback();
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void freezeAtSafepoint(int newStatus, boolean callerHasJavaFrameAnchor) {
        if (VMThreads.StatusSupport.isStatusJava()) {
            assert (newStatus == 1);
            CFunctionPrologueNode.cFunctionPrologue(3);
            SafepointSlowpath.notInlinedLockNoTransition();
            CFunctionEpilogueNode.cFunctionEpilogue(3);
        } else {
            VMError.guarantee(callerHasJavaFrameAnchor);
            SafepointSlowpath.notInlinedLockNoTransition();
            boolean result = VMThreads.StatusSupport.compareAndSetNativeToNewStatus(newStatus);
            if (!result) {
                throw VMError.shouldNotReachHere("Transition to the new thread status failed.");
            }
        }
        VMThreads.THREAD_MUTEX.unlock();
    }

    @NeverInline(value="CFunctionPrologue and CFunctionEpilogue are placed around call to this function")
    @Uninterruptible(reason="Must not contain safepoint checks.")
    private static void notInlinedLockNoTransition() {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        ThreadSuspendSupport.blockCurrentThreadIfSuspended();
    }
}

