/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.nodes.WriteStackPointerNode;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.ContinuationsFeature;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public class ContinuationSupport {
    public static final int FREEZE_OK = 0;
    public static final int FREEZE_PINNED_CS = 2;
    public static final int FREEZE_PINNED_NATIVE = 3;
    public static final int FREEZE_YIELDING = -2;
    private long ipOffset;

    @Fold
    public static boolean isSupported() {
        return ContinuationsFeature.isSupported();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ContinuationSupport() {
    }

    @Fold
    public static ContinuationSupport singleton() {
        return (ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setIPOffset(long value) {
        assert (this.ipOffset == 0L);
        this.ipOffset = value;
    }

    public long getIPOffset() {
        assert (this.ipOffset != 0L);
        return this.ipOffset;
    }

    public Object prepareCopy(StoredContinuation storedCont) {
        return null;
    }

    @NeverInline(value="Modifies the stack pointer manually, which breaks stack accesses.")
    @Uninterruptible(reason="Manipulates the stack pointer.")
    public static void enter(StoredContinuation storedCont, Pointer topSP, Object preparedData) {
        WriteStackPointerNode.write((WordBase)topSP);
        ContinuationSupport.enter0(storedCont, topSP, preparedData);
    }

    @NeverInline(value="The caller modified the stack pointer manually, so we need a new stack frame.")
    @Uninterruptible(reason="Copies stack frames containing references.")
    private static void enter0(StoredContinuation storedCont, Pointer topSP, Object preparedData) {
        CodePointer enterIP = ContinuationSupport.singleton().copyFrames(storedCont, topSP, preparedData);
        KnownIntrinsics.farReturn(0, topSP, enterIP, false);
    }

    @Uninterruptible(reason="Copies stack frames containing references.")
    protected CodePointer copyFrames(StoredContinuation storedCont, Pointer topSP, Object preparedData) {
        int totalSize = StoredContinuationAccess.getFramesSizeInBytes(storedCont);
        assert (totalSize % ConfigurationValues.getTarget().wordSize == 0);
        Pointer frameData = StoredContinuationAccess.getFramesStart(storedCont);
        UnmanagedMemoryUtil.copyWordsForward(frameData, topSP, Word.unsigned((int)totalSize));
        return StoredContinuationAccess.getIP(storedCont);
    }

    @Uninterruptible(reason="Copies stack frames containing references.")
    public CodePointer copyFrames(StoredContinuation fromCont, StoredContinuation toCont, Object preparedData) {
        return this.copyFrames(fromCont, StoredContinuationAccess.getFramesStart(toCont), preparedData);
    }

    static final class Options {
        public static final HostedOptionKey<Boolean> VMContinuations = new HostedOptionKey<Boolean>(true);

        Options() {
        }
    }
}

