/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSlotPacking;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalkImpl;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class JavaStackWalker {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JavaStackWalker() {
    }

    @Fold
    static int getJavaFrameOffset() {
        return NumUtil.roundUp((int)SizeOf.get(JavaStackWalkImpl.class), (int)ConfigurationValues.getTarget().wordSize);
    }

    @Fold
    public static int sizeOfJavaStackWalk() {
        return JavaStackWalker.getJavaFrameOffset() + SizeOf.get(JavaFrame.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrame getCurrentFrame(JavaStackWalk walk) {
        return (JavaFrame)((Pointer)walk).add(JavaStackWalker.getJavaFrameOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getStartSP(JavaStackWalk walk) {
        return JavaStackWalker.cast(walk).getStartSP();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getEndSP(JavaStackWalk walk) {
        return JavaStackWalker.cast(walk).getEndSP();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JavaFrameAnchor getFrameAnchor(JavaStackWalk walk) {
        return JavaStackWalker.cast(walk).getFrameAnchor();
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initialize(JavaStackWalk walk, IsolateThread thread) {
        JavaStackWalker.initializeFromFrameAnchor(walk, thread, (Pointer)Word.nullPointer());
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initialize(JavaStackWalk walk, IsolateThread thread, Pointer startSP) {
        JavaStackWalker.initWalk(walk, thread, startSP, (Pointer)Word.nullPointer(), (CodePointer)Word.nullPointer(), JavaFrameAnchors.getFrameAnchor(thread));
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initialize(JavaStackWalk walk, IsolateThread thread, Pointer startSP, Pointer endSP) {
        JavaStackWalker.initWalk(walk, thread, startSP, endSP, (CodePointer)Word.nullPointer(), JavaFrameAnchors.getFrameAnchor(thread));
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initialize(JavaStackWalk walk, IsolateThread thread, Pointer startSP, CodePointer startIP) {
        JavaStackWalker.initWalk(walk, thread, startSP, (Pointer)Word.nullPointer(), startIP, JavaFrameAnchors.getFrameAnchor(thread));
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initialize(JavaStackWalk walk, IsolateThread thread, Pointer startSP, CodePointer startIP, JavaFrameAnchor anchor) {
        JavaStackWalker.initWalk(walk, thread, startSP, (Pointer)Word.nullPointer(), startIP, anchor);
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public static void initializeForContinuation(JavaStackWalk walk, StoredContinuation continuation) {
        assert (continuation != null);
        CodePointer startIP = StoredContinuationAccess.getIP(continuation);
        if (startIP.isNull()) {
            JavaStackWalker.markAsNotWalkable(walk);
        } else {
            Pointer startSP = StoredContinuationAccess.getFramesStart(continuation);
            Pointer endSP = StoredContinuationAccess.getFramesEnd(continuation);
            JavaStackWalker.initWalk0(walk, startSP, endSP, startIP, (JavaFrameAnchor)Word.nullPointer());
        }
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public static void initializeForContinuation(JavaStackWalk walk, StoredContinuation continuation, CodePointer startIP) {
        assert (continuation != null);
        assert (startIP.isNonNull());
        Pointer startSP = StoredContinuationAccess.getFramesStart(continuation);
        Pointer endSP = StoredContinuationAccess.getFramesEnd(continuation);
        JavaStackWalker.initWalk0(walk, startSP, endSP, startIP, (JavaFrameAnchor)Word.nullPointer());
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static void initializeFromFrameAnchor(JavaStackWalk walk, IsolateThread thread, Pointer endSP) {
        assert (thread != CurrentIsolate.getCurrentThread()) : "Walking the stack without specifying a start SP is only allowed when walking other threads";
        JavaFrameAnchor frameAnchor = JavaFrameAnchors.getFrameAnchor(thread);
        if (frameAnchor.isNull()) {
            JavaStackWalker.markAsNotWalkable(walk);
        } else {
            JavaStackWalker.initWalk(walk, thread, frameAnchor.getLastJavaSP(), endSP, frameAnchor.getLastJavaIP(), frameAnchor.getPreviousAnchor());
        }
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static void initWalk(JavaStackWalk walk, IsolateThread thread, Pointer startSP, Pointer endSP, CodePointer startIP, JavaFrameAnchor anchor) {
        assert (thread.isNonNull());
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint()) : "Walking the stack of another thread is only safe when that thread is stopped at a safepoint";
        assert (startSP.isNonNull());
        if (VMThreads.SafepointBehavior.isCrashedThread(thread)) {
            JavaStackWalker.markAsNotWalkable(walk);
        } else {
            JavaStackWalker.initWalk0(walk, startSP, endSP, startIP, anchor);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void markAsNotWalkable(JavaStackWalk walk) {
        JavaStackWalker.initWalk0(walk, (Pointer)Word.nullPointer(), (Pointer)Word.nullPointer(), (CodePointer)Word.nullPointer(), (JavaFrameAnchor)Word.nullPointer());
    }

    @Uninterruptible(reason="JavaStackWalk must not contain stale values when this method returns.", callerMustBe=true)
    private static void initWalk0(JavaStackWalk walk, Pointer startSP, Pointer endSP, CodePointer startIP, JavaFrameAnchor anchor) {
        JavaStackWalkImpl w = JavaStackWalker.cast(walk);
        w.setStarted(false);
        w.setStartSP(startSP);
        w.setEndSP(endSP);
        w.setStartIP(startIP);
        w.setFrameAnchor(anchor);
        JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
        JavaFrames.clearData(frame);
    }

    @Uninterruptible(reason="JavaStackWalk must not contain stale values when this method returns.", callerMustBe=true)
    public static void updateStackPointerForContinuation(JavaStackWalk walk, StoredContinuation continuation) {
        JavaStackWalkImpl w = JavaStackWalker.cast(walk);
        Pointer newStartSP = StoredContinuationAccess.getFramesStart(continuation);
        long delta = newStartSP.rawValue() - w.getStartSP().rawValue();
        long newEndSP = w.getEndSP().rawValue() + delta;
        w.setStartSP(newStartSP);
        w.setEndSP((Pointer)Word.pointer((long)newEndSP));
        JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
        if (frame.getSP().isNonNull()) {
            long newSP = frame.getSP().rawValue() + delta;
            frame.setSP((Pointer)Word.pointer((long)newSP));
        }
    }

    @Uninterruptible(reason="Prevent deoptimization and GC while in this method.", callerMustBe=true)
    public static boolean advance(JavaStackWalk walk, IsolateThread thread) {
        return JavaStackWalker.advance0(walk, thread, null);
    }

    @Uninterruptible(reason="Prevent deoptimization and GC while in this method.", callerMustBe=true)
    public static boolean advanceForContinuation(JavaStackWalk walk, StoredContinuation continuation) {
        return JavaStackWalker.advance0(walk, (IsolateThread)Word.nullPointer(), continuation);
    }

    @Uninterruptible(reason="Prevent deoptimization and GC while in this method.", callerMustBe=true)
    private static boolean advance0(JavaStackWalk walk, IsolateThread thread, StoredContinuation continuation) {
        JavaStackWalkImpl w = JavaStackWalker.cast(walk);
        if (!w.getStarted()) {
            return JavaStackWalker.startStackWalk(w, thread, continuation);
        }
        return JavaStackWalker.continueStackWalk(w, thread, continuation);
    }

    @Uninterruptible(reason="Prevent deoptimization and GC while in this method.", callerMustBe=true)
    private static boolean startStackWalk(JavaStackWalkImpl walk, IsolateThread thread, StoredContinuation continuation) {
        walk.setStarted(true);
        JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
        Pointer startSP = walk.getStartSP();
        Pointer endSP = walk.getEndSP();
        if (startSP.isNull() || endSP.isNonNull() && endSP.belowOrEqual((UnsignedWord)startSP)) {
            JavaFrames.clearData(frame);
            return false;
        }
        CodePointer startIP = walk.getStartIP();
        if (startIP.isNull()) {
            JavaFrameAnchor anchor = JavaStackWalker.skipUnnecessaryFrameAnchors(walk, startSP);
            startIP = anchor.isNonNull() && startSP == anchor.getLastJavaSP() ? anchor.getLastJavaIP() : JavaStackWalker.readReturnAddress(thread, continuation, startSP);
            walk.setStartIP(startIP);
        } else assert (CodeInfoTable.lookupCodeInfo(startIP).isNonNull());
        JavaFrames.setData(frame, startSP, startIP);
        return true;
    }

    @Uninterruptible(reason="Prevent deoptimization and GC while in this method.", callerMustBe=true)
    private static boolean continueStackWalk(JavaStackWalkImpl walk, IsolateThread thread, StoredContinuation continuation) {
        assert (thread.isNull() != (continuation == null));
        JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
        Pointer sp = frame.getSP();
        if (sp.isNull()) {
            JavaFrames.clearData(frame);
            return false;
        }
        Pointer endSP = walk.getEndSP();
        sp = sp.add(JavaFrames.getTotalFrameSize(frame));
        if (JavaFrames.isEntryPoint(frame)) {
            JavaFrameAnchor anchor = JavaStackWalker.skipUnnecessaryFrameAnchors(walk, sp);
            if (anchor.isNonNull()) {
                walk.setFrameAnchor(anchor.getPreviousAnchor());
                if (endSP.isNull() || endSP.aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
                    JavaFrames.setData(frame, anchor.getLastJavaSP(), anchor.getLastJavaIP());
                    return true;
                }
            }
        } else {
            if (JavaFrames.isInterpreterLeaveStub(frame)) {
                long totalFrameSize = JavaFrames.getTotalFrameSize(frame).rawValue();
                long deoptSlot = sp.readLong((int)(-totalFrameSize));
                long varStackSize = DeoptimizationSlotPacking.decodeVariableFrameSizeFromDeoptSlot(deoptSlot);
                Pointer actualSp = sp.add(Word.unsigned((long)varStackSize));
                CodePointer ip = JavaStackWalker.readReturnAddress(thread, continuation, actualSp);
                JavaFrames.setData(frame, actualSp, ip);
                return true;
            }
            if (endSP.isNull() || endSP.aboveThan((UnsignedWord)sp)) {
                CodePointer ip = JavaStackWalker.readReturnAddress(thread, continuation, sp);
                JavaFrames.setData(frame, sp, ip);
                return true;
            }
        }
        JavaFrames.clearData(frame);
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JavaFrameAnchor skipUnnecessaryFrameAnchors(JavaStackWalkImpl walk, Pointer sp) {
        JavaFrameAnchor anchor = walk.getFrameAnchor();
        while (anchor.isNonNull() && anchor.getLastJavaSP().belowThan((UnsignedWord)sp)) {
            anchor = anchor.getPreviousAnchor();
        }
        walk.setFrameAnchor(anchor);
        return anchor;
    }

    @Uninterruptible(reason="Stored continuation must not move.")
    private static CodePointer readReturnAddress(IsolateThread thread, StoredContinuation continuation, Pointer startSP) {
        if (ContinuationSupport.isSupported() && continuation != null) {
            assert (thread.isNull());
            return FrameAccess.singleton().readReturnAddress(continuation, startSP);
        }
        assert (thread.isNonNull() && continuation == null);
        return FrameAccess.singleton().readReturnAddress(thread, startSP);
    }

    @Uninterruptible(reason="Not really uninterruptible, but we are about to fatally fail.", calleeMustBe=false)
    public static RuntimeException fatalErrorUnknownFrameEncountered(Pointer sp, CodePointer ip) {
        Log log = Log.log().string("Stack walk must walk only frames of known code:");
        log.string("  sp=").zhex((WordBase)sp).string("  ip=").zhex((WordBase)ip);
        log.newline();
        throw VMError.shouldNotReachHere("Stack walk must walk only frames of known code");
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, Pointer endSP, StackFrameVisitor visitor) {
        assert (startSP.isNonNull());
        return JavaStackWalker.walkCurrentThread(startSP, endSP, (CodePointer)Word.nullPointer(), visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, ParameterizedStackFrameVisitor visitor, Object data) {
        return JavaStackWalker.walkCurrentThread(startSP, (Pointer)Word.nullPointer(), (CodePointer)Word.nullPointer(), visitor, data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkCurrentThread(Pointer startSP, CodePointer startIP, ParameterizedStackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, (Pointer)Word.nullPointer(), startIP, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, Pointer endSP, CodePointer startIP, ParameterizedStackFrameVisitor visitor, Object data) {
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initWalk(walk, thread, startSP, endSP, startIP, JavaFrameAnchors.getFrameAnchor());
        return JavaStackWalker.doWalk(walk, thread, visitor, data);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        return JavaStackWalker.walkThread(thread, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, ParameterizedStackFrameVisitor visitor, Object data) {
        return JavaStackWalker.walkThread(thread, (Pointer)Word.nullPointer(), visitor, data);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkThread(IsolateThread thread, Pointer endSP, ParameterizedStackFrameVisitor visitor, Object data) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initializeFromFrameAnchor(walk, thread, endSP);
        return JavaStackWalker.doWalk(walk, thread, visitor, data);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static void walkThread(IsolateThread thread, Pointer startSP, Pointer endSP, CodePointer startIP, StackFrameVisitor visitor) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initWalk(walk, thread, startSP, endSP, startIP, JavaFrameAnchors.getFrameAnchor(thread));
        JavaStackWalker.doWalk(walk, thread, visitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    static boolean doWalk(JavaStackWalk walk, IsolateThread thread, ParameterizedStackFrameVisitor visitor, Object data) {
        while (JavaStackWalker.advance(walk, thread)) {
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            Pointer sp = frame.getSP();
            CodePointer ip = frame.getIP();
            if (JavaFrames.isUnknownFrame(frame)) {
                return JavaStackWalker.visitUnknownFrame(sp, ip, visitor, data);
            }
            DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkEagerDeoptimized(frame);
            if (deoptimizedFrame != null) {
                if (JavaStackWalker.visitDeoptimizedFrame(sp, ip, deoptimizedFrame, visitor, data)) continue;
                return false;
            }
            UntetheredCodeInfo untetheredInfo = frame.getIPCodeInfo();
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                if (JavaStackWalker.visitRegularFrame(sp, ip, info, visitor, data)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
        }
        return true;
    }

    @Uninterruptible(reason="CodeInfo in JavaStackWalk is currently null, and we are going to abort the stack walking.", calleeMustBe=false)
    private static boolean visitUnknownFrame(Pointer sp, CodePointer ip, ParameterizedStackFrameVisitor visitor, Object data) {
        return visitor.unknownFrame(sp, ip, data);
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    @RestrictHeapAccess(reason="Whitelisted because some StackFrameVisitor implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo info, ParameterizedStackFrameVisitor visitor, Object data) {
        return visitor.visitRegularFrame(sp, ip, info, data);
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    @RestrictHeapAccess(reason="Whitelisted because some StackFrameVisitor implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static boolean visitDeoptimizedFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, ParameterizedStackFrameVisitor visitor, Object data) {
        return visitor.visitDeoptimizedFrame(sp, ip, deoptimizedFrame, data);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JavaStackWalkImpl cast(JavaStackWalk walk) {
        return (JavaStackWalkImpl)walk;
    }
}

