/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrFrameType;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.ExecutionSampleEvent;
import com.oracle.svm.core.sampler.SamplerStackTraceSerializer;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SamplerJfrStackTraceSerializer
implements SamplerStackTraceSerializer {
    private static final CodeInfoDecoder.FrameInfoCursor FRAME_INFO_CURSOR = new CodeInfoDecoder.FrameInfoCursor();
    private static final StackTraceVisitorData VISITOR_DATA = new StackTraceVisitorData();

    @Override
    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    public Pointer serializeStackTrace(Pointer rawStackTrace, Pointer bufferEnd, int sampleSize, int sampleHash, boolean isTruncated, long sampleTick, long threadId, long threadState, int skipCount) {
        Pointer current = rawStackTrace;
        CIntPointer statusPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        JfrStackTraceRepository.JfrStackTraceTableEntry entry = SubstrateJVM.getStackTraceRepo().getOrPutStackTrace(current, Word.unsigned((int)sampleSize), sampleHash, statusPtr);
        long stackTraceId = entry.isNull() ? 0L : entry.getId();
        int status = statusPtr.read();
        if (status == 1 || status == 2) {
            assert (current.add(sampleSize).belowThan((UnsignedWord)bufferEnd));
            boolean serialized = SamplerJfrStackTraceSerializer.serializeStackTrace(current, sampleSize, isTruncated, stackTraceId, skipCount);
            if (serialized) {
                SubstrateJVM.getStackTraceRepo().commitSerializedStackTrace(entry);
            }
        } else assert (status == 4 || status == 8);
        current = current.add(sampleSize);
        long endMarker = current.readLong(0);
        if (endMarker == -2L) {
            if (stackTraceId != 0L) {
                ExecutionSampleEvent.writeExecutionSample(sampleTick, threadId, stackTraceId, threadState);
            } else {
                JfrThreadLocal.increaseMissedSamples();
            }
        } else assert (endMarker == -1L);
        current = current.add(8);
        return current;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static boolean serializeStackTrace(Pointer rawStackTrace, int sampleSize, boolean isTruncated, long stackTraceId, int skipCount) {
        assert (sampleSize % 8 == 0);
        JfrBuffer targetBuffer = SubstrateJVM.getStackTraceRepo().getCurrentBuffer();
        if (targetBuffer.isNull()) {
            return false;
        }
        SamplerJfrStackTraceSerializer.visitRawStackTrace(rawStackTrace, sampleSize, (JfrNativeEventWriterData)Word.nullPointer(), skipCount);
        if (VISITOR_DATA.getUsedFrames() == 0) {
            return false;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, targetBuffer);
        JfrNativeEventWriter.putLong(data, stackTraceId);
        JfrNativeEventWriter.putBoolean(data, isTruncated || VISITOR_DATA.isTruncated());
        JfrNativeEventWriter.putInt(data, VISITOR_DATA.getUsedFrames());
        SamplerJfrStackTraceSerializer.visitRawStackTrace(rawStackTrace, sampleSize, data, skipCount);
        boolean success = JfrNativeEventWriter.commit(data);
        SubstrateJVM.getStackTraceRepo().setCurrentBuffer(data.getJfrBuffer());
        return success;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void visitRawStackTrace(Pointer rawStackTrace, int sampleSize, JfrNativeEventWriterData data, int skipCount) {
        VISITOR_DATA.reset(skipCount);
        Pointer ipPtr = rawStackTrace;
        Pointer rawStackTraceEnd = rawStackTrace.add(sampleSize);
        while (ipPtr.belowThan((UnsignedWord)rawStackTraceEnd)) {
            long ip = ipPtr.readLong(0);
            SamplerJfrStackTraceSerializer.visitFrame(data, ip);
            ipPtr = ipPtr.add(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent JFR recording, epoch change, and that the GC frees the CodeInfo.")
    private static void visitFrame(JfrNativeEventWriterData data, long address) {
        CodePointer ip = (CodePointer)Word.pointer((long)address);
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull()) {
            VMError.shouldNotReachHere("Stack walk must walk only frames of known code.");
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo tetheredCodeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            SamplerJfrStackTraceSerializer.visitFrame(data, tetheredCodeInfo, ip);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void visitFrame(JfrNativeEventWriterData data, CodeInfo codeInfo, CodePointer ip) {
        FRAME_INFO_CURSOR.initialize(codeInfo, ip, false);
        while (FRAME_INFO_CURSOR.advance()) {
            if (VISITOR_DATA.shouldSkipFrame()) {
                VISITOR_DATA.incrementSkippedFrames();
                continue;
            }
            if (VISITOR_DATA.shouldTruncate()) {
                VISITOR_DATA.setTruncated();
                break;
            }
            VISITOR_DATA.incrementUsedFrames();
            if (!data.isNonNull()) continue;
            FrameInfoQueryResult frame = FRAME_INFO_CURSOR.get();
            SamplerJfrStackTraceSerializer.serializeStackTraceElement(data, frame);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void serializeStackTraceElement(JfrNativeEventWriterData data, FrameInfoQueryResult stackTraceElement) {
        long methodId = SubstrateJVM.getMethodRepo().getMethodId(stackTraceElement.getSourceClass(), stackTraceElement.getSourceMethodName(), stackTraceElement.getSourceMethodSignature(), stackTraceElement.getSourceMethodId(), stackTraceElement.getSourceMethodModifiers());
        JfrNativeEventWriter.putLong(data, methodId);
        JfrNativeEventWriter.putInt(data, stackTraceElement.getSourceLineNumber());
        JfrNativeEventWriter.putInt(data, stackTraceElement.getBci());
        JfrNativeEventWriter.putLong(data, JfrFrameType.FRAME_AOT_COMPILED.getId());
    }

    private static final class StackTraceVisitorData {
        private int framesToSkip;
        private int skippedFrames;
        private int usedFrames;
        private boolean truncated;

        private StackTraceVisitorData() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void reset(int skipCount) {
            this.framesToSkip = skipCount;
            this.skippedFrames = 0;
            this.usedFrames = 0;
            this.truncated = false;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean shouldSkipFrame() {
            return this.skippedFrames < this.framesToSkip;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void incrementSkippedFrames() {
            ++this.skippedFrames;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean shouldTruncate() {
            return this.usedFrames >= SubstrateJVM.getStackTraceRepo().getStackTraceDepth();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void setTruncated() {
            this.truncated = true;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isTruncated() {
            return this.truncated;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void incrementUsedFrames() {
            ++this.usedFrames;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int getUsedFrames() {
            return this.usedFrames;
        }
    }
}

