/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.serialize;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationUtils;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Objects;
import jdk.graal.compiler.java.LambdaUtils;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class SerializationSupport
implements MultiLayeredImageSingleton,
SerializationRegistry,
UnsavedSingleton {
    private Constructor<?> stubConstructor;
    private final EconomicMap<SerializationLookupKey, Object> constructorAccessors;
    private final EconomicMap<Object, RuntimeConditionSet> classes = EconomicMap.create();
    private final EconomicMap<String, RuntimeConditionSet> lambdaCapturingClasses = EconomicMap.create();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static SerializationSupport currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(SerializationSupport.class, false, true);
    }

    public static SerializationSupport[] layeredSingletons() {
        return (SerializationSupport[])MultiLayeredImageSingleton.getAllLayers(SerializationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationSupport() {
        this.constructorAccessors = ImageHeapMap.create("constructorAccessors");
    }

    public void setStubConstructor(Constructor<?> stubConstructor) {
        VMError.guarantee(this.stubConstructor == null, "Cannot reset stubConstructor");
        this.stubConstructor = stubConstructor;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object addConstructorAccessor(Class<?> declaringClass, Class<?> targetConstructorClass, Object constructorAccessor) {
        VMError.guarantee(constructorAccessor instanceof SubstrateConstructorAccessor, "Not a SubstrateConstructorAccessor: %s", constructorAccessor);
        SerializationLookupKey key = new SerializationLookupKey(declaringClass, targetConstructorClass);
        return this.constructorAccessors.putIfAbsent((Object)key, constructorAccessor);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationLookupKey getKeyFromConstructorAccessorClass(Class<?> constructorAccessorClass) {
        MapCursor cursor = this.constructorAccessors.getEntries();
        while (cursor.advance()) {
            if (!cursor.getValue().getClass().equals(constructorAccessorClass)) continue;
            return (SerializationLookupKey)cursor.getKey();
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isGeneratedSerializationClassLoader(ClassLoader classLoader) {
        MapCursor constructorAccessorsCursor = this.constructorAccessors.getEntries();
        while (constructorAccessorsCursor.advance()) {
            if (constructorAccessorsCursor.getValue().getClass().getClassLoader() != classLoader) continue;
            return true;
        }
        return false;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getClassLoaderSerializationLookupKey(ClassLoader classLoader) {
        MapCursor constructorAccessorsCursor = this.constructorAccessors.getEntries();
        while (constructorAccessorsCursor.advance()) {
            if (constructorAccessorsCursor.getValue().getClass().getClassLoader() != classLoader) continue;
            SerializationLookupKey key = (SerializationLookupKey)constructorAccessorsCursor.getKey();
            return key.declaringClass.getName() + key.targetConstructorClass.getName();
        }
        throw VMError.shouldNotReachHere("No constructor accessor uses the class loader %s", classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSerializationTargetClass(ConfigurationCondition cnd, DynamicHub hub) {
        EconomicMap<Object, RuntimeConditionSet> economicMap = this.classes;
        synchronized (economicMap) {
            RuntimeConditionSet previous = (RuntimeConditionSet)this.classes.putIfAbsent(BuildPhaseProvider.isHostedUniverseBuilt() ? Integer.valueOf(hub.getTypeID()) : new DynamicHubKey(hub), (Object)RuntimeConditionSet.createHosted(cnd));
            if (previous != null) {
                previous.addCondition(cnd);
            }
        }
    }

    public void replaceHubKeyWithTypeID() {
        EconomicMap newEntries = EconomicMap.create();
        MapCursor cursor = this.classes.getEntries();
        while (cursor.advance()) {
            Object key = cursor.getKey();
            if (!(key instanceof DynamicHubKey)) continue;
            DynamicHubKey hubKey = (DynamicHubKey)key;
            newEntries.put((Object)hubKey.getTypeID(), (Object)((RuntimeConditionSet)cursor.getValue()));
            cursor.remove();
        }
        this.classes.putAll((UnmodifiableEconomicMap)newEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerLambdaCapturingClass(ConfigurationCondition cnd, String lambdaCapturingClass) {
        EconomicMap<String, RuntimeConditionSet> economicMap = this.lambdaCapturingClasses;
        synchronized (economicMap) {
            RuntimeConditionSet previousConditions = (RuntimeConditionSet)this.lambdaCapturingClasses.putIfAbsent((Object)lambdaCapturingClass, (Object)RuntimeConditionSet.createHosted(cnd));
            if (previousConditions != null) {
                previousConditions.addCondition(cnd);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isLambdaCapturingClassRegistered(String lambdaCapturingClass) {
        return this.lambdaCapturingClasses.containsKey((Object)lambdaCapturingClass);
    }

    public static Object getSerializationConstructorAccessor(Class<?> serializationTargetClass, Class<?> targetConstructorClass) {
        Class<Object> declaringClass = serializationTargetClass;
        if (LambdaUtils.isLambdaClass(declaringClass)) {
            declaringClass = SerializedLambda.class;
        }
        if (SubstrateUtil.HOSTED) {
            Object object = SerializationSupport.currentLayer().getSerializationConstructorAccessor0(declaringClass, targetConstructorClass);
            if (object != null) {
                return object;
            }
        } else {
            if (MetadataTracer.enabled()) {
                MetadataTracer.singleton().traceSerializationType(declaringClass);
            }
            for (SerializationSupport singleton : SerializationSupport.layeredSingletons()) {
                Object constructorAccessor = singleton.getSerializationConstructorAccessor0(declaringClass, targetConstructorClass);
                if (constructorAccessor == null) continue;
                return constructorAccessor;
            }
        }
        String string = targetConstructorClass.getName();
        if (!SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet()) {
            throw VMError.unsupportedFeature("SerializationConstructorAccessor class not found for declaringClass: " + declaringClass.getName() + " (targetConstructorClass: " + string + "). Usually adding " + declaringClass.getName() + " to serialization-config.json fixes the problem.");
        }
        MissingSerializationRegistrationUtils.reportSerialization(declaringClass, "type '" + declaringClass.getTypeName() + "' with target constructor class '" + string + "'");
        return null;
    }

    @Override
    public Object getSerializationConstructorAccessor0(Class<?> declaringClass, Class<?> rawTargetConstructorClass) {
        VMError.guarantee(this.stubConstructor != null, "Called too early, no stub constructor yet.");
        Class<?> targetConstructorClass = Modifier.isAbstract(declaringClass.getModifiers()) ? this.stubConstructor.getDeclaringClass() : rawTargetConstructorClass;
        return this.constructorAccessors.get((Object)new SerializationLookupKey(declaringClass, targetConstructorClass));
    }

    public static boolean isRegisteredForSerialization(DynamicHub hub) {
        for (SerializationSupport singleton : SerializationSupport.layeredSingletons()) {
            if (!singleton.isRegisteredForSerialization0(hub)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRegisteredForSerialization0(DynamicHub dynamicHub) {
        RuntimeConditionSet conditionSet = (RuntimeConditionSet)this.classes.get((Object)dynamicHub.getTypeID());
        return conditionSet != null && conditionSet.satisfied();
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }

    public static final class SerializationLookupKey {
        private final Class<?> declaringClass;
        private final Class<?> targetConstructorClass;

        private SerializationLookupKey(Class<?> declaringClass, Class<?> targetConstructorClass) {
            assert (declaringClass != null && targetConstructorClass != null);
            this.declaringClass = declaringClass;
            this.targetConstructorClass = targetConstructorClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public Class<?> getTargetConstructorClass() {
            return this.targetConstructorClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializationLookupKey that = (SerializationLookupKey)o;
            return this.declaringClass.equals(that.declaringClass) && this.targetConstructorClass.equals(that.targetConstructorClass);
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.targetConstructorClass);
        }
    }

    public record DynamicHubKey(DynamicHub hub) {
        public int getTypeID() {
            return this.hub.getTypeID();
        }
    }

    public static final class StubForAbstractClass
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private StubForAbstractClass() {
        }
    }
}

