/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.proxy;

import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.layeredimagesingleton.DuplicableImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class DynamicProxySupport
implements DynamicProxyRegistry,
DuplicableImageSingleton {
    public static final Pattern PROXY_CLASS_NAME_PATTERN = Pattern.compile(".*\\$Proxy[0-9]+");
    private final EconomicMap<ProxyCacheKey, ConditionalRuntimeValue<Object>> proxyCache = ImageHeapMap.create("proxyCache");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicProxySupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void addProxyClass(ConfigurationCondition condition, Class<?> ... interfaces) {
        VMError.guarantee(condition.isRuntimeChecked(), "The condition used must be a runtime condition.");
        Class[] intfs = (Class[])interfaces.clone();
        ProxyCacheKey key = new ProxyCacheKey(intfs);
        if (!this.proxyCache.containsKey((Object)key)) {
            this.proxyCache.put((Object)key, new ConditionalRuntimeValue<Object>(RuntimeConditionSet.emptySet(), DynamicProxySupport.createProxyClass(intfs)));
        }
        ((ConditionalRuntimeValue)this.proxyCache.get((Object)key)).getConditions().addCondition(condition);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Object createProxyClass(Class<?>[] interfaces) {
        try {
            Class<?> clazz = DynamicProxySupport.createProxyClassFromImplementedInterfaces(interfaces);
            boolean isPredefinedProxy = Arrays.stream(interfaces).anyMatch(PredefinedClassesSupport::isPredefined);
            if (isPredefinedProxy) {
                PredefinedClassesSupport.registerClass(clazz);
                RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{clazz});
            }
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(clazz, (Class[])new Class[]{InvocationHandler.class})});
            for (Class<?> intf : interfaces) {
                RuntimeReflection.register((Executable[])intf.getMethods());
            }
            return clazz;
        }
        catch (Throwable t) {
            LogUtils.warning((String)"Could not create a proxy class from list of interfaces: %s. Reason: %s", (Object[])new Object[]{Arrays.toString(interfaces), t.getMessage()});
            return t;
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Class<?> getProxyClassHosted(Class<?> ... interfaces) {
        Class[] intfs = (Class[])interfaces.clone();
        return DynamicProxySupport.createProxyClassFromImplementedInterfaces(intfs);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Class<?> createProxyClassFromImplementedInterfaces(Class<?>[] interfaces) {
        return Proxy.getProxyClass(DynamicProxySupport.getCommonClassLoaderOrFail(null, interfaces), interfaces);
    }

    private static ClassLoader getCommonClassLoaderOrFail(ClassLoader loader, Class<?> ... intfs) {
        ClassLoader commonLoader = null;
        for (Class<?> intf : intfs) {
            ClassLoader intfLoader = intf.getClassLoader();
            if (ClassUtil.isSameOrParentLoader(commonLoader, (ClassLoader)intfLoader)) {
                commonLoader = intfLoader;
                continue;
            }
            if (ClassUtil.isSameOrParentLoader((ClassLoader)intfLoader, (ClassLoader)commonLoader)) continue;
            throw DynamicProxySupport.incompatibleClassLoaders(loader, intfs);
        }
        return commonLoader;
    }

    @Override
    public Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        ProxyCacheKey key;
        ConditionalRuntimeValue clazzOrError;
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceProxyType(interfaces);
        }
        if ((clazzOrError = (ConditionalRuntimeValue)this.proxyCache.get((Object)(key = new ProxyCacheKey(interfaces)))) == null || !clazzOrError.getConditions().satisfied()) {
            throw MissingReflectionRegistrationUtils.reportProxyAccess(interfaces);
        }
        if (clazzOrError.getValue() instanceof Throwable) {
            throw new GraalError((Throwable)clazzOrError.getValue());
        }
        Class clazz = (Class)clazzOrError.getValue();
        if (!DynamicHub.fromClass(clazz).isLoaded()) {
            ClassLoader commonLoader = DynamicProxySupport.getCommonClassLoaderOrFail(loader, interfaces);
            if (!ClassUtil.isSameOrParentLoader((ClassLoader)commonLoader, (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
            boolean loaded = PredefinedClassesSupport.loadClassIfNotLoaded(commonLoader, null, clazz);
            if (!loaded && !ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
                throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
            }
        } else if (!ClassUtil.isSameOrParentLoader((ClassLoader)clazz.getClassLoader(), (ClassLoader)loader)) {
            throw DynamicProxySupport.incompatibleClassLoaders(loader, interfaces);
        }
        return clazz;
    }

    private static RuntimeException incompatibleClassLoaders(ClassLoader provided, Class<?>[] interfaces) {
        StringBuilder b = new StringBuilder("Interface(s) not visible to the provided class loader: ");
        DynamicProxySupport.describeLoaderChain(b, provided);
        for (Class<?> intf : interfaces) {
            b.append("; interface ").append(intf.getName()).append(" loaded by ");
            DynamicProxySupport.describeLoaderChain(b, intf.getClassLoader());
        }
        throw new IllegalArgumentException(b.toString());
    }

    private static void describeLoaderChain(StringBuilder b, ClassLoader loader) {
        ClassLoader l = loader;
        while (true) {
            if (l != loader) {
                b.append(", child of ");
            }
            b.append(l);
            if (l == null) break;
            l = l.getParent();
        }
    }

    public static String proxyTypeDescriptor(String ... interfaceNames) {
        return "Proxy[" + String.join((CharSequence)", ", interfaceNames) + "]";
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        return LayeredImageSingleton.PersistFlags.NOTHING;
    }

    static final class ProxyCacheKey {
        private final Class<?>[] interfaces;

        private ProxyCacheKey(Class<?> ... interfaces) {
            this.interfaces = interfaces;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyCacheKey) {
                ProxyCacheKey that = (ProxyCacheKey)obj;
                return Arrays.equals(this.interfaces, that.interfaces);
            }
            return false;
        }

        public int hashCode() {
            if (ImageLayerBuildingSupport.buildingImageLayer()) {
                return Arrays.hashCode(Arrays.stream(this.interfaces).map(Class::getName).toArray());
            }
            return Arrays.hashCode(this.interfaces);
        }

        public String toString() {
            return Arrays.toString(this.interfaces);
        }
    }
}

