/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.PosixSubstrateSigprofHandler;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.TimeUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.UnsignedWord;

public final class LinuxSubstrateSigprofHandler
extends PosixSubstrateSigprofHandler {
    private static final long MARKER = Long.MIN_VALUE;
    private static final FastThreadLocalWord<UnsignedWord> samplerTimerId = FastThreadLocalFactory.createWord("LinuxSubstrateSigprofHandler.samplerTimerId");

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public LinuxSubstrateSigprofHandler() {
    }

    @Override
    protected void updateInterval() {
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            this.updateInterval(thread);
            thread = VMThreads.nextThread(thread);
        }
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify thread-local execution sampler state.")
    protected void install0(IsolateThread thread) {
        assert (!LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread));
        assert (SizeOf.get(LinuxTime.timer_t.class) == 4 || SizeOf.get(LinuxTime.timer_t.class) == 8);
        Signal.sigevent sigevent2 = (Signal.sigevent)StackValue.get(Signal.sigevent.class);
        sigevent2.sigev_notify(Signal.SIGEV_SIGNAL());
        sigevent2.sigev_signo(Signal.SignalEnum.SIGPROF.getCValue());
        WordPointer timerPointer = (WordPointer)StackValue.get(WordPointer.class);
        timerPointer.write(Word.zero());
        int status = LinuxTime.NoTransitions.timer_create(LinuxTime.CLOCK_MONOTONIC(), sigevent2, timerPointer);
        PosixUtils.checkStatusIs0(status, "timer_create(clockid, sevp, timerid): wrong arguments.");
        LinuxSubstrateSigprofHandler.setSamplerTimerId(thread, (UnsignedWord)timerPointer.read());
        this.updateInterval(thread);
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify thread-local execution sampler state.")
    protected void uninstall0(IsolateThread thread) {
        assert (LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread));
        int status = LinuxTime.NoTransitions.timer_delete(LinuxSubstrateSigprofHandler.getSamplerTimerId(thread));
        PosixUtils.checkStatusIs0(status, "timer_delete(clockid): wrong arguments.");
        LinuxSubstrateSigprofHandler.clearSamplerTimerId(thread);
    }

    @Uninterruptible(reason="Prevent VM operations that modify thread-local execution sampler state.")
    private void updateInterval(IsolateThread thread) {
        assert (LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread));
        long ns = TimeUtils.millisToNanos(this.newIntervalMillis);
        LinuxTime.itimerspec newTimerSpec = UnsafeStackValue.get(LinuxTime.itimerspec.class);
        newTimerSpec.it_value().set_tv_sec(ns / 1000000000L);
        newTimerSpec.it_value().set_tv_nsec(ns % 1000000000L);
        newTimerSpec.it_interval().set_tv_sec(ns / 1000000000L);
        newTimerSpec.it_interval().set_tv_nsec(ns % 1000000000L);
        int status = LinuxTime.NoTransitions.timer_settime(LinuxSubstrateSigprofHandler.getSamplerTimerId(thread), 0, newTimerSpec, (LinuxTime.itimerspec)Word.nullPointer());
        PosixUtils.checkStatusIs0(status, "timer_settime(timerid, flags, newTimerSpec, oldValue): wrong arguments.");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean hasSamplerTimerId(IsolateThread thread) {
        assert (CurrentIsolate.getCurrentThread() == thread || VMOperation.isInProgressAtSafepoint());
        return samplerTimerId.get(thread).and(Word.unsigned((long)Long.MIN_VALUE)).notEqual(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getSamplerTimerId(IsolateThread thread) {
        assert (LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread));
        return samplerTimerId.get(thread).and(Word.unsigned((long)Long.MAX_VALUE));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setSamplerTimerId(IsolateThread thread, UnsignedWord timerId) {
        assert (!LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread) && timerId.and(Word.unsigned((long)Long.MIN_VALUE)).equal(0));
        samplerTimerId.set(thread, timerId.or(Word.unsigned((long)Long.MIN_VALUE)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void clearSamplerTimerId(IsolateThread thread) {
        assert (LinuxSubstrateSigprofHandler.hasSamplerTimerId(thread));
        samplerTimerId.set(thread, (UnsignedWord)Word.zero());
    }
}

