/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;

@CContext(value=PosixDirectives.class)
public class PosixFile {
    @CConstant
    public static native int LOCK_EX();

    @CConstant
    public static native int LOCK_NB();

    @CFunction
    public static native int flock(int var0, int var1);

    public static int restartableFlock(int fd, int operation) {
        int result;
        while ((result = PosixFile.flock(fd, operation)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }
}

