/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;

public class PosixDirectives
implements CContext.Directives {
    private static final String[] commonLibs = new String[]{"<dlfcn.h>", "<dirent.h>", "<fcntl.h>", "<limits.h>", "<locale.h>", "<pthread.h>", "<pwd.h>", "<semaphore.h>", "<signal.h>", "<errno.h>", "<sys/file.h>", "<sys/mman.h>", "<sys/resource.h>", "<sys/stat.h>", "<sys/time.h>", "<sys/times.h>", "<sys/types.h>", "<sys/utsname.h>", "<time.h>", "<unistd.h>"};
    private static final String[] darwinLibs = new String[]{"<Foundation/Foundation.h>", "<mach/mach.h>", "<mach/semaphore.h>", "<mach/mach_time.h>", "<mach-o/dyld.h>", "<sys/sysctl.h>", "<sys/syslimits.h>"};
    private static final String[] linuxLibs = new String[]{"<mntent.h>"};

    public boolean isInConfiguration() {
        return Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class);
    }

    public List<String> getHeaderFiles() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(commonLibs));
        if (Platform.includedIn(Platform.LINUX.class)) {
            result.addAll(Arrays.asList(linuxLibs));
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            result.addAll(Arrays.asList(darwinLibs));
        } else {
            throw VMError.shouldNotReachHere("Unsupported OS");
        }
        return result;
    }

    public List<String> getOptions() {
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return Collections.singletonList("-ObjC");
        }
        return Collections.emptyList();
    }

    public List<String> getMacroDefinitions() {
        return Arrays.asList("_GNU_SOURCE", "_LARGEFILE64_SOURCE", "_DARWIN_USE_64_BIT_INODE");
    }
}

