/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.attach;

import com.oracle.svm.core.attach.AttachApiSupport;
import com.oracle.svm.core.attach.AttachListenerThread;
import com.oracle.svm.core.jdk.management.Target_jdk_internal_vm_VMSupport;
import com.oracle.svm.core.posix.attach.AttachHelper;
import com.oracle.svm.core.posix.attach.PosixAttachListenerThread;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public class PosixAttachApiSupport
implements AttachApiSupport {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private State state = State.Uninitialized;
    private PosixAttachListenerThread attachListenerThread;
    private String cachedSocketFilePath;
    private int listener = -1;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixAttachApiSupport() {
    }

    @Fold
    public static PosixAttachApiSupport singleton() {
        return (PosixAttachApiSupport)ImageSingletons.lookup(PosixAttachApiSupport.class);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L344-L360")
    public void startup() {
        String path = this.getSocketFilePath();
        try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)path);){
            AttachHelper.startup(f.get());
        }
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L409-L440")
    public boolean isInitTrigger() {
        String filename = ".attach_pid" + ProcessHandle.current().pid();
        if (PosixAttachApiSupport.isInitTrigger0(filename)) {
            return true;
        }
        String fallbackPath = Target_jdk_internal_vm_VMSupport.getVMTemporaryDirectory() + "/" + filename;
        return PosixAttachApiSupport.isInitTrigger0(fallbackPath);
    }

    private static boolean isInitTrigger0(String path) {
        try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)path);){
            boolean bl = AttachHelper.isInitTrigger(f.get());
            return bl;
        }
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L373-L395")
    public void initialize() {
        this.lock.lock();
        try {
            if (this.state == State.Destroyed) {
                return;
            }
            if (this.state == State.Initialized) {
                if (this.isSocketFileValid()) {
                    return;
                }
                this.shutdown(false);
            }
            assert (this.state == State.Uninitialized);
            if (this.createListener()) {
                this.attachListenerThread = new PosixAttachListenerThread(this.listener);
                this.attachListenerThread.start();
                this.state = State.Initialized;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isSocketFileValid() {
        assert (this.lock.isHeldByCurrentThread());
        try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)this.getSocketFilePath());){
            boolean bl = AttachHelper.checkSocketFile(f.get());
            return bl;
        }
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L169-L180")
    public void shutdown(boolean inTeardownHook) {
        if (!this.shutdownRequested.compareAndSet(false, true) && Thread.currentThread() instanceof AttachListenerThread) {
            return;
        }
        this.shutdown0(inTeardownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown0(boolean inTeardownHook) {
        this.lock.lock();
        try {
            if (this.state != State.Initialized) {
                assert (this.attachListenerThread == null);
                this.shutdownRequested.set(false);
                return;
            }
            try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)this.getSocketFilePath());){
                AttachHelper.listenerCleanup(this.listener, f.get());
                this.listener = -1;
            }
            if (this.attachListenerThread != Thread.currentThread()) {
                try {
                    this.attachListenerThread.join();
                }
                catch (InterruptedException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            this.attachListenerThread = null;
            this.state = inTeardownHook ? State.Destroyed : State.Uninitialized;
            this.shutdownRequested.set(false);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getSocketFilePath() {
        if (this.cachedSocketFilePath == null) {
            long pid = ProcessHandle.current().pid();
            String tempDir = Target_jdk_internal_vm_VMSupport.getVMTemporaryDirectory();
            this.cachedSocketFilePath = Paths.get(tempDir, ".java_pid" + pid).toString();
        }
        return this.cachedSocketFilePath;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/os/posix/attachListener_posix.cpp#L185-L249")
    private boolean createListener() {
        assert (this.lock.isHeldByCurrentThread());
        String path = this.getSocketFilePath();
        try (CTypeConversion.CCharPointerHolder p = CTypeConversion.toCString((CharSequence)path);){
            this.listener = AttachHelper.createListener(p.get());
            boolean bl = this.listener != -1;
            return bl;
        }
    }

    private static enum State {
        Uninitialized,
        Initialized,
        Destroyed;

    }
}

