/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.pltgot;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.core.pltgot.MethodAddressResolver;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class IdentityMethodAddressResolver
implements MethodAddressResolver {
    private static final CGlobalData<Pointer> methodTable = CGlobalDataFactory.forSymbol("__svm_methodtable_begin");

    @Override
    @Uninterruptible(reason="Called from the PLT stub where stack walks are not safe.")
    public long resolveMethodWithGotEntry(long gotEntry) {
        UnsignedWord methodTableOffset = Word.unsigned((long)gotEntry).multiply(ConfigurationValues.getTarget().wordSize);
        UnsignedWord address = (UnsignedWord)methodTable.get().readWord((WordBase)methodTableOffset);
        GOTAccess.writeToGotEntry((int)gotEntry, address);
        return address.rawValue();
    }
}

