/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.os.AbstractRawFileOperationSupport;
import java.io.File;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public interface RawFileOperationSupport {
    @Fold
    public static boolean isPresent() {
        return ImageSingletons.contains(AbstractRawFileOperationSupport.RawFileOperationSupportHolder.class);
    }

    @Fold
    public static RawFileOperationSupport littleEndian() {
        return AbstractRawFileOperationSupport.RawFileOperationSupportHolder.getLittleEndian();
    }

    @Fold
    public static RawFileOperationSupport bigEndian() {
        return AbstractRawFileOperationSupport.RawFileOperationSupportHolder.getBigEndian();
    }

    @Fold
    public static RawFileOperationSupport nativeByteOrder() {
        return AbstractRawFileOperationSupport.RawFileOperationSupportHolder.getNativeByteOrder();
    }

    public CCharPointer allocateCPath(String var1);

    public RawFileDescriptor create(String var1, FileCreationMode var2, FileAccessMode var3);

    public RawFileDescriptor create(File var1, FileCreationMode var2, FileAccessMode var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public RawFileDescriptor create(CCharPointer var1, FileCreationMode var2, FileAccessMode var3);

    public String getTempDirectory();

    public RawFileDescriptor open(String var1, FileAccessMode var2);

    public RawFileDescriptor open(File var1, FileAccessMode var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public RawFileDescriptor open(CCharPointer var1, FileAccessMode var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isValid(RawFileDescriptor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean close(RawFileDescriptor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long size(RawFileDescriptor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long position(RawFileDescriptor var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean seek(RawFileDescriptor var1, long var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean write(RawFileDescriptor var1, Pointer var2, UnsignedWord var3);

    @Uninterruptible(reason="Array must not move.")
    public boolean write(RawFileDescriptor var1, byte[] var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeBoolean(RawFileDescriptor var1, boolean var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeByte(RawFileDescriptor var1, byte var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeShort(RawFileDescriptor var1, short var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeChar(RawFileDescriptor var1, char var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeInt(RawFileDescriptor var1, int var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeLong(RawFileDescriptor var1, long var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeFloat(RawFileDescriptor var1, float var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean writeDouble(RawFileDescriptor var1, double var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long read(RawFileDescriptor var1, Pointer var2, UnsignedWord var3);

    public static enum FileAccessMode {
        READ,
        READ_WRITE,
        WRITE;

    }

    public static enum FileCreationMode {
        CREATE,
        CREATE_OR_REPLACE;

    }

    public static interface RawFileDescriptor
    extends WordBase {
    }
}

