/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nmt;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.nmt.NmtMallocHeader;
import com.oracle.svm.core.nmt.NmtMallocMemoryInfo;
import com.oracle.svm.core.nmt.NmtVirtualMemoryInfo;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public class NativeMemoryTracking {
    private static final UnsignedWord ALIGNMENT = Word.unsigned((int)16);
    private static final int MAGIC = -252579085;
    private static final long KB = 1024L;
    private final NmtMallocMemoryInfo[] mallocCategories;
    private final NmtVirtualMemoryInfo[] virtualMemCategories;
    private final NmtMallocMemoryInfo mallocTotal = new NmtMallocMemoryInfo();
    private final NmtVirtualMemoryInfo virtualMemTotal = new NmtVirtualMemoryInfo();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public NativeMemoryTracking() {
        int i;
        this.mallocCategories = new NmtMallocMemoryInfo[NmtCategory.values().length];
        for (i = 0; i < this.mallocCategories.length; ++i) {
            this.mallocCategories[i] = new NmtMallocMemoryInfo();
        }
        this.virtualMemCategories = new NmtVirtualMemoryInfo[NmtCategory.values().length];
        for (i = 0; i < this.virtualMemCategories.length; ++i) {
            this.virtualMemCategories[i] = new NmtVirtualMemoryInfo();
        }
    }

    @Fold
    public static NativeMemoryTracking singleton() {
        return (NativeMemoryTracking)ImageSingletons.lookup(NativeMemoryTracking.class);
    }

    @Fold
    public static UnsignedWord sizeOfNmtHeader() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(NmtMallocHeader.class), ALIGNMENT);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer initializeHeader(PointerBase outerPtr, UnsignedWord size, NmtCategory category) {
        NmtMallocHeader mallocHeader = (NmtMallocHeader)outerPtr;
        mallocHeader.setAllocationSize(size);
        mallocHeader.setCategory(category.ordinal());
        assert (NativeMemoryTracking.setMagic(mallocHeader));
        return NativeMemoryTracking.getInnerPointer(mallocHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean setMagic(NmtMallocHeader mallocHeader) {
        mallocHeader.setMagic(-252579085);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void track(PointerBase innerPtr) {
        if (innerPtr.isNull()) {
            return;
        }
        NmtMallocHeader header = NativeMemoryTracking.getHeader(innerPtr);
        UnsignedWord nmtHeaderSize = NativeMemoryTracking.sizeOfNmtHeader();
        UnsignedWord allocationSize = header.getAllocationSize();
        UnsignedWord totalSize = allocationSize.add(nmtHeaderSize);
        this.getMallocInfo(header.getCategory()).track(allocationSize);
        this.getMallocInfo(NmtCategory.NMT).track(nmtHeaderSize);
        this.mallocTotal.track(totalSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase untrack(PointerBase innerPtr) {
        if (innerPtr.isNull()) {
            return Word.nullPointer();
        }
        NmtMallocHeader header = NativeMemoryTracking.getHeader(innerPtr);
        this.untrack(header.getAllocationSize(), header.getCategory());
        return header;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void untrack(UnsignedWord size, int category) {
        this.getMallocInfo(category).untrack(size);
        this.getMallocInfo(NmtCategory.NMT).untrack(NativeMemoryTracking.sizeOfNmtHeader());
        this.mallocTotal.untrack(size.add(NativeMemoryTracking.sizeOfNmtHeader()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NmtMallocHeader getHeader(PointerBase innerPtr) {
        NmtMallocHeader result = (NmtMallocHeader)((Pointer)innerPtr).subtract(NativeMemoryTracking.sizeOfNmtHeader());
        assert (result.getMagic() == -252579085) : "bad NMT malloc header";
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getInnerPointer(NmtMallocHeader mallocHeader) {
        return ((Pointer)mallocHeader).add(NativeMemoryTracking.sizeOfNmtHeader());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackReserve(UnsignedWord size, NmtCategory category) {
        this.trackReserve(size.rawValue(), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackReserve(long size, NmtCategory category) {
        this.getVirtualInfo(category).trackReserved(size);
        this.virtualMemTotal.trackReserved(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackCommit(UnsignedWord size, NmtCategory category) {
        this.trackCommit(size.rawValue(), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackCommit(long size, NmtCategory category) {
        this.getVirtualInfo(category).trackCommitted(size);
        this.virtualMemTotal.trackCommitted(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackUncommit(UnsignedWord size, NmtCategory category) {
        this.trackUncommit(size.rawValue(), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackUncommit(long size, NmtCategory category) {
        this.getVirtualInfo(category).trackUncommit(size);
        this.virtualMemTotal.trackUncommit(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackFree(UnsignedWord size, NmtCategory category) {
        this.trackFree(size.rawValue(), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void trackFree(long size, NmtCategory category) {
        this.getVirtualInfo(category).trackFree(size);
        this.virtualMemTotal.trackFree(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getMallocMemory(NmtCategory category) {
        return this.getMallocInfo(category).getUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getMallocCount(NmtCategory category) {
        return this.getMallocInfo(category).getCount();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakMallocMemory(NmtCategory category) {
        return this.getMallocInfo(category).getPeakUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCountAtPeakMallocMemory(NmtCategory category) {
        return this.getMallocInfo(category).getCountAtPeakUsage();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalMallocCount() {
        return this.mallocTotal.getCount();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalMallocMemory() {
        return this.mallocTotal.getUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakTotalMallocMemory() {
        return this.mallocTotal.getPeakUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCountAtPeakTotalMallocMemory() {
        return this.mallocTotal.getCountAtPeakUsage();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getReservedVirtualMemory(NmtCategory category) {
        return this.getVirtualInfo(category).getReservedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCommittedVirtualMemory(NmtCategory category) {
        return this.getVirtualInfo(category).getCommittedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakReservedVirtualMemory(NmtCategory category) {
        return this.getVirtualInfo(category).getPeakReservedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakCommittedVirtualMemory(NmtCategory category) {
        return this.getVirtualInfo(category).getPeakCommittedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalReservedVirtualMemory() {
        return this.virtualMemTotal.getReservedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalCommittedVirtualMemory() {
        return this.virtualMemTotal.getCommittedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakTotalReservedVirtualMemory() {
        return this.virtualMemTotal.getPeakReservedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakTotalCommittedVirtualMemory() {
        return this.virtualMemTotal.getPeakCommittedSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtMallocMemoryInfo getMallocInfo(int category) {
        return this.mallocCategories[category];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtMallocMemoryInfo getMallocInfo(NmtCategory category) {
        return this.getMallocInfo(category.ordinal());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtVirtualMemoryInfo getVirtualInfo(NmtCategory category) {
        return this.getVirtualInfo(category.ordinal());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtVirtualMemoryInfo getVirtualInfo(int category) {
        return this.virtualMemCategories[category];
    }

    public static RuntimeSupport.Hook initializationHook() {
        return isFirstIsolate -> {
            NativeMemoryTracking.singleton().trackReserve(Heap.getHeap().getImageHeapReservedBytes(), NmtCategory.ImageHeap);
            NativeMemoryTracking.singleton().trackCommit(Heap.getHeap().getImageHeapCommittedBytes(), NmtCategory.ImageHeap);
        };
    }

    public static RuntimeSupport.Hook shutdownHook() {
        return isFirstIsolate -> NativeMemoryTracking.singleton().printStatistics();
    }

    public void printStatistics() {
        if (VMInspectionOptions.PrintNMTStatistics.getValue().booleanValue()) {
            System.out.println();
            System.out.println(this.generateReportString());
        }
    }

    public String generateReportString() {
        String lineBreak = System.lineSeparator();
        StringBuilder result = new StringBuilder(3000);
        result.append("Native memory tracking").append(lineBreak).append(lineBreak);
        result.append("Total").append(lineBreak);
        long reservedTotal = (this.getTotalReservedVirtualMemory() + this.getTotalMallocMemory()) / 1024L;
        long committedTotal = (this.getTotalCommittedVirtualMemory() + this.getTotalMallocMemory()) / 1024L;
        result.append("    ").append("(reserved=").append(reservedTotal).append("KB, committed=").append(committedTotal).append("KB)").append(lineBreak);
        result.append("    ").append("(malloc=").append(this.getTotalMallocMemory() / 1024L).append("KB, count=").append(this.getTotalMallocCount()).append(")").append(lineBreak);
        result.append("    ").append("(peak malloc=").append(this.getPeakTotalMallocMemory() / 1024L).append("KB, count at peak=").append(this.getCountAtPeakTotalMallocMemory()).append(")").append(lineBreak);
        result.append("    ").append("(mmap: reserved=").append(this.getTotalReservedVirtualMemory() / 1024L).append("KB, committed=").append(this.getTotalCommittedVirtualMemory() / 1024L).append("KB)").append(lineBreak);
        result.append("    ").append("(mmap: peak reserved=").append(this.getPeakTotalReservedVirtualMemory() / 1024L).append("KB, peak committed=").append(this.getPeakTotalCommittedVirtualMemory() / 1024L).append("KB)").append(lineBreak);
        for (int i = 0; i < NmtCategory.values().length; ++i) {
            NmtCategory category = NmtCategory.values()[i];
            result.append(category.getName()).append(lineBreak);
            long reserved = (this.getReservedVirtualMemory(category) + this.getMallocMemory(category)) / 1024L;
            long committed = (this.getCommittedVirtualMemory(category) + this.getMallocMemory(category)) / 1024L;
            result.append("    ").append("(reserved=").append(reserved).append("KB, committed=").append(committed).append("KB)").append(lineBreak);
            result.append("    ").append("(malloc=").append(this.getMallocMemory(category) / 1024L).append("KB, count=").append(this.getMallocCount(category)).append(")").append(lineBreak);
            result.append("    ").append("(peak malloc=").append(this.getPeakMallocMemory(category) / 1024L).append("KB, count at peak=").append(this.getCountAtPeakMallocMemory(category)).append(")").append(lineBreak);
            result.append("    ").append("(mmap: reserved=").append(this.getReservedVirtualMemory(category) / 1024L).append("KB, committed=").append(this.getCommittedVirtualMemory(category) / 1024L).append("KB)").append(lineBreak);
            result.append("    ").append("(mmap: peak reserved=").append(this.getPeakReservedVirtualMemory(category) / 1024L).append("KB, peak committed=").append(this.getPeakCommittedVirtualMemory(category) / 1024L).append("KB)").append(lineBreak);
        }
        return result.toString();
    }
}

