/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.layeredimagesingleton;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InvocationPluginHelper;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class NonLayeredImageSingletonFeature
implements InternalFeature,
FeatureSingleton {
    ConcurrentHashMap<Class<?>, Object> multiLayeredArrays = new ConcurrentHashMap();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !ImageLayerBuildingSupport.buildingImageLayer();
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        final Function<Class, Object> lookupMultiLayeredImageSingleton = key -> {
            MultiLayeredImageSingleton multiLayerSingleton;
            Object singleton = LayeredImageSingletonSupport.singleton().lookup(key, true, true);
            boolean conditions = singleton.getClass().equals(key) && singleton instanceof MultiLayeredImageSingleton && (multiLayerSingleton = (MultiLayeredImageSingleton)singleton).getImageBuilderFlags().contains((Object)LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS);
            VMError.guarantee(conditions, "Illegal singleton %s", singleton);
            return singleton;
        };
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), MultiLayeredImageSingleton.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getAllLayers", new Type[]{Class.class}){
            final /* synthetic */ NonLayeredImageSingletonFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = (Class)b.getSnippetReflection().asObject(Class.class, classNode.asJavaConstant());
                Object singleton = lookupMultiLayeredImageSingleton.apply(key);
                Object multiLayeredArray = this.this$0.multiLayeredArrays.computeIfAbsent(key, k -> {
                    Object result = Array.newInstance(k, 1);
                    Array.set(result, 0, singleton);
                    return result;
                });
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject(multiLayeredArray), (int)1, (boolean)true, (MetaAccessProvider)b.getMetaAccess()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getForLayer", new Type[]{Class.class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode, ValueNode indexNode) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    Class key = (Class)b.getSnippetReflection().asObject(Class.class, classNode.asJavaConstant());
                    Object singleton = lookupMultiLayeredImageSingleton.apply(key);
                    if (SubstrateUtil.assertionsEnabled()) {
                        helper.intrinsicRangeCheck(indexNode, Condition.NE, (ValueNode)ConstantNode.forInt((int)0));
                    }
                    helper.emitFinalReturn(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject(singleton), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                    boolean bl = true;
                    return bl;
                }
            }
        });
    }
}

