/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti;

import com.oracle.svm.core.jvmti.JvmtiEnv;
import com.oracle.svm.core.jvmti.JvmtiEnvUtil;
import com.oracle.svm.core.jvmti.headers.JvmtiExternalEnv;
import com.oracle.svm.core.locks.VMMutex;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JvmtiEnvs {
    private final VMMutex mutex = new VMMutex("jvmtiEnvManager");
    private JvmtiEnv headEnv;
    private JvmtiEnv tailEnv;
    private int threadsIteratingEnvs;
    private boolean hasDisposedEnvs;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JvmtiEnvs() {
    }

    @Fold
    public static JvmtiEnvs singleton() {
        return (JvmtiEnvs)ImageSingletons.lookup(JvmtiEnvs.class);
    }

    public JvmtiEnv getHead() {
        return this.headEnv;
    }

    public JvmtiExternalEnv create() {
        JvmtiEnv env = JvmtiEnvUtil.allocate();
        if (env.isNull()) {
            return (JvmtiExternalEnv)Word.nullPointer();
        }
        this.mutex.lock();
        try {
            if (this.headEnv.isNull()) {
                this.headEnv = env;
            } else {
                this.tailEnv.setNext(env);
            }
            this.tailEnv = env;
            assert (env.getNext().isNull());
            JvmtiExternalEnv jvmtiExternalEnv = JvmtiEnvUtil.toExternal(env);
            return jvmtiExternalEnv;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void dispose(JvmtiEnv env) {
        this.mutex.lock();
        try {
            JvmtiEnvUtil.dispose(env);
            this.hasDisposedEnvs = true;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void enterEnvIteration() {
        this.mutex.lock();
        try {
            ++this.threadsIteratingEnvs;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void leaveEnvIteration() {
        this.mutex.lock();
        try {
            int remainingThreads = this.threadsIteratingEnvs--;
            assert (remainingThreads >= 0);
            if (remainingThreads == 0 && this.hasDisposedEnvs) {
                this.cleanup();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void cleanup() {
        assert (this.mutex.isOwner());
        assert (this.hasDisposedEnvs);
        JvmtiEnv cur = this.headEnv;
        JvmtiEnv prev = (JvmtiEnv)Word.nullPointer();
        while (cur.isNonNull()) {
            if (JvmtiEnvUtil.isDead(cur)) {
                this.remove(cur, prev);
                JvmtiEnvUtil.free(cur);
            }
            prev = cur;
            cur = cur.getNext();
        }
        this.hasDisposedEnvs = false;
    }

    private void remove(JvmtiEnv cur, JvmtiEnv prev) {
        assert (this.mutex.isOwner());
        if (prev.isNull()) {
            this.headEnv = cur.getNext();
        } else {
            prev.setNext(cur.getNext());
        }
        if (this.tailEnv == cur) {
            this.tailEnv = prev;
        }
        cur.setNext(null);
    }

    public void teardown() {
        JvmtiEnv cur = this.headEnv;
        while (cur.isNonNull()) {
            JvmtiEnv next = cur.getNext();
            JvmtiEnvUtil.free(cur);
            cur = next;
        }
        this.headEnv = (JvmtiEnv)Word.nullPointer();
        this.tailEnv = (JvmtiEnv)Word.nullPointer();
    }
}

