/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class OldObjectSampleEvent {
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static void emit(long startTicks, long objectId, UnsignedWord objectSize, long allocationTicks, long threadId, long stackTraceId, UnsignedWord heapUsedAfterLastGC, int arrayLength) {
        if (JfrEvent.OldObjectSample.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.OldObjectSample);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, 0L);
            JfrNativeEventWriter.putLong(data, threadId);
            JfrNativeEventWriter.putLong(data, stackTraceId);
            JfrNativeEventWriter.putLong(data, allocationTicks);
            JfrNativeEventWriter.putLong(data, objectSize.rawValue());
            JfrNativeEventWriter.putLong(data, startTicks - allocationTicks);
            JfrNativeEventWriter.putLong(data, heapUsedAfterLastGC.rawValue());
            JfrNativeEventWriter.putLong(data, objectId);
            JfrNativeEventWriter.putInt(data, arrayLength);
            JfrNativeEventWriter.putLong(data, 0L);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

