/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferList;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.VMOperation;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public class JfrGlobalMemory {
    private static final int PROMOTION_RETRY_COUNT = 100;
    private final JfrBufferList buffers = new JfrBufferList();
    private UnsignedWord bufferSize;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrGlobalMemory() {
    }

    public void initialize(UnsignedWord globalBufferSize, long globalBufferCount) {
        this.bufferSize = globalBufferSize;
        int i = 0;
        while ((long)i < globalBufferCount) {
            JfrBuffer buffer = JfrBufferAccess.allocate(this.bufferSize, JfrBufferType.GLOBAL_MEMORY);
            if (buffer.isNull()) {
                throw new OutOfMemoryError("Could not allocate JFR buffer.");
            }
            JfrBufferNode node = this.buffers.addNode(buffer);
            if (node.isNull()) {
                throw new OutOfMemoryError("Could not allocate JFR buffer node.");
            }
            ++i;
        }
    }

    public void clear() {
        assert (VMOperation.isInProgressAtSafepoint());
        JfrBufferNode node = this.buffers.getHead();
        while (node.isNonNull()) {
            JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
            JfrBufferAccess.reinitialize(buffer);
            node = node.getNext();
        }
    }

    public void teardown() {
        this.freeBuffers();
        this.buffers.teardown();
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private void freeBuffers() {
        JfrBufferNode node = this.buffers.getHead();
        while (node.isNonNull()) {
            JfrBufferNodeAccess.lockNoTransition(node);
            try {
                JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
                JfrBufferAccess.free(buffer);
                node.setBuffer((JfrBuffer)Word.nullPointer());
            }
            finally {
                JfrBufferNodeAccess.unlock(node);
            }
            node = node.getNext();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public JfrBufferList getBuffers() {
        return this.buffers;
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    public boolean write(JfrBuffer buffer, boolean flushpoint) {
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(buffer);
        return this.write(buffer, unflushedSize, flushpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public boolean write(JfrBuffer buffer, UnsignedWord unflushedSize, boolean flushpoint) {
        boolean shouldSignal;
        if (unflushedSize.equal(0)) {
            return true;
        }
        JfrBufferNode promotionNode = this.tryAcquirePromotionBuffer(unflushedSize);
        if (promotionNode.isNull()) {
            return false;
        }
        try {
            JfrBuffer promotionBuffer = JfrBufferNodeAccess.getBuffer(promotionNode);
            assert (JfrBufferAccess.getAvailableSize(promotionBuffer).aboveOrEqual(unflushedSize));
            UnmanagedMemoryUtil.copy(JfrBufferAccess.getFlushedPos(buffer), promotionBuffer.getCommittedPos(), unflushedSize);
            JfrBufferAccess.increaseCommittedPos(promotionBuffer, unflushedSize);
            shouldSignal = SubstrateJVM.getRecorderThread().shouldSignal(promotionBuffer);
        }
        finally {
            JfrBufferNodeAccess.unlock(promotionNode);
        }
        JfrBufferAccess.increaseFlushedPos(buffer, unflushedSize);
        if (shouldSignal && !flushpoint) {
            SubstrateJVM.getRecorderThread().signal();
        }
        return true;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private JfrBufferNode tryAcquirePromotionBuffer(UnsignedWord size) {
        assert (size.belowOrEqual(this.bufferSize));
        for (int retry = 0; retry < 100; ++retry) {
            JfrBufferNode node = this.buffers.getHead();
            while (node.isNonNull()) {
                if (JfrBufferNodeAccess.tryLock(node)) {
                    JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
                    if (JfrBufferAccess.getAvailableSize(buffer).aboveOrEqual(size) && JfrBufferAccess.getAvailableSize(buffer).aboveOrEqual(size)) {
                        return node;
                    }
                    JfrBufferNodeAccess.unlock(node);
                }
                node = node.getNext();
            }
        }
        return (JfrBufferNode)Word.nullPointer();
    }
}

