/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.configure.ConditionalElement;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.jdk.resources.MissingResourceRegistrationError;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.Loader;

public final class MissingResourceRegistrationUtils
extends MissingRegistrationUtils {
    private static final Map<String, Set<String>> resourceEntryPoints = Map.of(ClassLoader.class.getTypeName(), Set.of("getResource", "getResources", "getSystemResource", "getSystemResources"), BuiltinClassLoader.class.getTypeName(), Set.of("findResource", "findResourceAsStream"), Loader.class.getTypeName(), Set.of("findResource"), ResourceBundle.class.getTypeName(), Set.of("getBundleImpl"), Module.class.getTypeName(), Set.of("getResourceAsStream"), Class.class.getTypeName(), Set.of("getResource", "getResourceAsStream"), Files.class.getTypeName(), Set.of("walk", "getFileStore", "readAttributes", "setAttribute", "newByteChannel", "newOutputStream", "newInputStream", "createDirectory", "move", "copy", "newDirectoryStream", "delete"), FileSystemProvider.class.getTypeName(), Set.of("newFileChannel"));

    public static void reportResourceAccess(Module module, String resourcePath) {
        String moduleMessage = module == null ? "" : " from module " + MissingResourceRegistrationUtils.quote(module.getName());
        String moduleOrNull = module == null ? null : module.getName();
        ConditionalElement entry = new ConditionalElement(UnresolvedConfigurationCondition.alwaysTrue(), (Object)new ResourceConfiguration.ResourceEntry(resourcePath, moduleOrNull));
        StringWriter json = new StringWriter();
        try {
            ResourceConfiguration.conditionalGlobElementJson((ConditionalElement)entry, (JsonWriter)MissingResourceRegistrationUtils.getJSONWriter(json), (boolean)true);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("In memory JSON printing should not fail");
        }
        MissingResourceRegistrationError exception = new MissingResourceRegistrationError(MissingResourceRegistrationUtils.resourceError("resource" + moduleMessage + " at path " + MissingResourceRegistrationUtils.quote(resourcePath), json.toString(), "resources"), resourcePath);
        MissingResourceRegistrationUtils.report(exception);
    }

    public static void reportResourceBundleAccess(String baseName) {
        ResourceConfiguration.BundleConfiguration bundleConfig = new ResourceConfiguration.BundleConfiguration(UnresolvedConfigurationCondition.alwaysTrue(), baseName);
        StringWriter json = new StringWriter();
        try {
            ResourceConfiguration.printResourceBundle((ResourceConfiguration.BundleConfiguration)bundleConfig, (JsonWriter)MissingResourceRegistrationUtils.getJSONWriter(json), (boolean)true);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("In memory JSON printing should not fail");
        }
        MissingResourceRegistrationError exception = new MissingResourceRegistrationError(MissingResourceRegistrationUtils.resourceError("resource bundle with name " + MissingResourceRegistrationUtils.quote(baseName), json.toString(), "resource-bundles"), baseName);
        MissingResourceRegistrationUtils.report(exception);
    }

    private static String resourceError(String resourceDescriptor, String resourceJSON, String anchor) {
        return MissingResourceRegistrationUtils.registrationMessage("access", resourceDescriptor, resourceJSON, "", "resources", anchor);
    }

    private static void report(MissingResourceRegistrationError exception) {
        StackTraceElement responsibleClass = MissingResourceRegistrationUtils.getResponsibleClass(exception);
        MissingRegistrationUtils.report(exception, responsibleClass);
    }

    private static StackTraceElement getResponsibleClass(Throwable t) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = t.getStackTrace()) {
            if (!resourceEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) continue;
            return stackTraceElement;
        }
        return null;
    }
}

