/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.resources.Bundles;

public class LocalizationSupport {
    public final Map<String, Charset> charsets = new HashMap<String, Charset>();
    public final Locale[] allLocales;
    public final Set<String> supportedLanguageTags;
    public final ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private final Bundles.Strategy strategy = LocalizationSupport.getLocaleDataStrategy();
    public final Charset defaultCharset;
    private final EconomicMap<String, RuntimeConditionSet> registeredBundles = ImageHeapMap.create("registeredBundles");

    public LocalizationSupport(Set<Locale> locales, Charset defaultCharset) {
        this.allLocales = locales.toArray(new Locale[0]);
        this.defaultCharset = defaultCharset;
        this.supportedLanguageTags = locales.stream().map(Locale::toString).collect(Collectors.toSet());
    }

    public boolean optimizedMode() {
        return false;
    }

    public boolean jvmMode() {
        return !this.optimizedMode();
    }

    public boolean substituteLoadLookup() {
        return false;
    }

    public OptimizedLocalizationSupport asOptimizedSupport() {
        GraalError.guarantee((boolean)this.optimizedMode(), (String)"Optimized support only available in optimized localization mode.");
        return (OptimizedLocalizationSupport)this;
    }

    public Map<String, Object> getBundleContentOf(Object bundle) {
        throw VMError.unsupportedFeature("Resource bundle lookup must be loaded during native image generation: " + String.valueOf(bundle.getClass()));
    }

    private static Bundles.Strategy getLocaleDataStrategy() {
        try {
            Class localeDataStrategy = ReflectionUtil.lookupClass((boolean)false, (String)"sun.util.resources.LocaleData$LocaleDataStrategy");
            Field strategyInstance = ReflectionUtil.lookupField((Class)localeDataStrategy, (String)"INSTANCE");
            return (Bundles.Strategy)strategyInstance.get(null);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Function<String, Optional<Module>> findModule, Locale locale, boolean jdkBundle) {
        this.registerRequiredReflectionAndResourcesForBundle(bundleName, Set.of(locale), jdkBundle);
        if (!(bundle instanceof PropertyResourceBundle)) {
            LocalizationSupport.registerNullaryConstructor(bundle.getClass());
        }
        if (bundle instanceof PropertyResourceBundle) {
            String[] bundleNameWithModule = SubstrateUtil.split(bundleName, ":", 2);
            String origin = "Added for PropertyResourceBundle: " + bundleName;
            if (bundleNameWithModule.length < 2) {
                String resourceName = StringUtil.toSlashSeparated((String)this.control.toBundleName(bundleName, locale)).concat(".properties");
                Map<String, Set<Module>> packageToModules = ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).getPackageToModules();
                Set modules = packageToModules.getOrDefault(LocalizationSupport.packageName(bundleName), Collections.emptySet());
                for (Module m2 : modules) {
                    ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(m2, resourceName, (Object)origin);
                }
                if (modules.isEmpty()) {
                    ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(null, resourceName, (Object)origin);
                }
            } else if (findModule != null) {
                String resourceName = StringUtil.toSlashSeparated((String)this.control.toBundleName(bundleNameWithModule[1], locale)).concat(".properties");
                Optional<Module> module = findModule.apply(bundleNameWithModule[0]);
                String finalResourceName = resourceName;
                module.ifPresent(m -> ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(m, finalResourceName, (Object)origin));
            }
        }
        this.onBundlePrepared(bundle);
    }

    private static String packageName(String bundleName) {
        String uniformBundleName = StringUtil.toDotSeparated((String)bundleName);
        int classSep = uniformBundleName.lastIndexOf(46);
        if (classSep == -1) {
            return "";
        }
        return uniformBundleName.substring(0, classSep);
    }

    public void registerRequiredReflectionAndResourcesForBundle(String baseName, Collection<Locale> wantedLocales, boolean jdkBundle) {
        int i;
        if (!jdkBundle && (i = baseName.lastIndexOf(46)) > 0) {
            String name = baseName.substring(i + 1) + "Provider";
            String providerName = baseName.substring(0, i) + ".spi." + name;
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(ConfigurationCondition.alwaysTrue(), providerName);
        }
        for (Locale locale : wantedLocales) {
            this.registerRequiredReflectionAndResourcesForBundleAndLocale(baseName, locale, jdkBundle);
        }
    }

    public void registerRequiredReflectionAndResourcesForBundleAndLocale(String baseName, Locale baseLocale, boolean jdkBundle) {
        List<Locale> candidateLocales = jdkBundle ? LocalizationSupport.getJDKBundleCandidateLocales(baseName, baseLocale) : this.control.getCandidateLocales(baseName, baseLocale);
        for (Locale locale : candidateLocales) {
            String otherBundleName;
            String bundleWithLocale = jdkBundle ? this.strategy.toBundleName(baseName, locale) : this.control.toBundleName(baseName, locale);
            RuntimeReflection.registerClassLookup((String)bundleWithLocale);
            Class bundleClass = ReflectionUtil.lookupClass((boolean)true, (String)bundleWithLocale);
            if (bundleClass != null) {
                LocalizationSupport.registerNullaryConstructor(bundleClass);
            }
            Resources.currentLayer().registerNegativeQuery(bundleWithLocale.replace('.', '/') + ".properties");
            if (!jdkBundle || (otherBundleName = Bundles.toOtherBundleName(baseName, bundleWithLocale, locale)).equals(bundleWithLocale)) continue;
            RuntimeReflection.registerClassLookup((String)otherBundleName);
        }
    }

    private static List<Locale> getJDKBundleCandidateLocales(String baseName, Locale baseLocale) {
        LocaleProviderAdapter.Type adapterType = baseName.contains(".cldr") ? LocaleProviderAdapter.Type.CLDR : LocaleProviderAdapter.Type.JRE;
        ResourceBundleBasedAdapter adapter = (ResourceBundleBasedAdapter)((Object)LocaleProviderAdapter.forType(adapterType));
        return adapter.getCandidateLocales(baseName, baseLocale);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onBundlePrepared(ResourceBundle bundle) {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onClassBundlePrepared(Class<?> bundleClass) {
    }

    public boolean shouldSubstituteLoadLookup(String className) {
        return false;
    }

    public void prepareNonCompliant(Class<?> clazz) throws ReflectiveOperationException {
    }

    public boolean isNotIncluded(String bundleName) {
        return false;
    }

    public void prepareClassResourceBundle(String basename, Class<?> bundleClass) {
        LocalizationSupport.registerNullaryConstructor(bundleClass);
        this.onClassBundlePrepared(bundleClass);
    }

    private static void registerNullaryConstructor(Class<?> bundleClass) {
        Constructor<?> nullaryConstructor;
        RuntimeReflection.register((Class[])new Class[]{bundleClass});
        try {
            nullaryConstructor = bundleClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            RuntimeReflection.registerConstructorLookup(bundleClass, (Class[])new Class[0]);
            return;
        }
        RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerBundleLookup(ConfigurationCondition condition, String baseName) {
        RuntimeConditionSet conditionSet = RuntimeConditionSet.emptySet();
        RuntimeConditionSet registered = (RuntimeConditionSet)this.registeredBundles.putIfAbsent((Object)baseName, (Object)conditionSet);
        (registered == null ? conditionSet : registered).addCondition(condition);
    }

    public boolean isRegisteredBundleLookup(String baseName, Locale locale, Object controlOrStrategy) {
        if (baseName == null || locale == null || controlOrStrategy == null) {
            return true;
        }
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceResourceBundle(baseName);
        }
        if (this.registeredBundles.containsKey((Object)baseName)) {
            return ((RuntimeConditionSet)this.registeredBundles.get((Object)baseName)).satisfied();
        }
        return false;
    }
}

