/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.ImageInternedStrings;
import com.oracle.svm.core.jdk.RuntimeInternedStrings;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class StringInternSupport
implements LayeredImageSingleton {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Object priorLayersInternedStrings;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private IdentityHashMap<String, String> internedStringsIdentityMap;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Field getInternedStringsField() {
        return ReflectionUtil.lookupField(RuntimeInternedStrings.class, (String)"internedStrings");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public StringInternSupport() {
        this(Set.of());
    }

    private StringInternSupport(Object obj) {
        this.priorLayersInternedStrings = obj;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setImageInternedStrings(String[] newImageInternedStrings) {
        assert (!ImageLayerBuildingSupport.buildingImageLayer());
        ImageInternedStrings.setImageInternedStrings(newImageInternedStrings);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String[] layeredSetImageInternedStrings(Set<String> layerInternedStrings) {
        Set<String> priorInternedStrings;
        assert (ImageLayerBuildingSupport.buildingImageLayer());
        Object object = this.priorLayersInternedStrings;
        if (object instanceof SetGenerator) {
            SetGenerator generator = (SetGenerator)object;
            priorInternedStrings = generator.generateSet();
        } else {
            priorInternedStrings = (Set<String>)this.priorLayersInternedStrings;
        }
        this.priorLayersInternedStrings = null;
        Object[] currentLayerInternedStrings = priorInternedStrings.isEmpty() ? (String[])layerInternedStrings.toArray(String[]::new) : (String[])layerInternedStrings.stream().filter(value -> !priorInternedStrings.contains(value)).toArray(String[]::new);
        Arrays.sort(currentLayerInternedStrings);
        ImageInternedStrings.setImageInternedStrings((String[])currentLayerInternedStrings);
        if (ImageLayerBuildingSupport.buildingSharedLayer()) {
            this.internedStringsIdentityMap = new IdentityHashMap(priorInternedStrings.size() + currentLayerInternedStrings.length);
            for (String value2 : priorInternedStrings) {
                String internedVersion = value2.intern();
                this.internedStringsIdentityMap.put(internedVersion, internedVersion);
            }
            Arrays.stream(currentLayerInternedStrings).forEach(internedString -> this.internedStringsIdentityMap.put((String)internedString, (String)internedString));
        }
        return currentLayerInternedStrings;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IdentityHashMap<String, String> getInternedStringsIdentityMap() {
        assert (this.internedStringsIdentityMap != null);
        return this.internedStringsIdentityMap;
    }

    static String intern(String str) {
        String result = RuntimeInternedStrings.getInternedStrings().get(str);
        if (result != null) {
            return result;
        }
        return StringInternSupport.doIntern(str);
    }

    private static String doIntern(String str) {
        String oldValue;
        Object result = str;
        for (ImageInternedStrings layer : (ImageInternedStrings[])MultiLayeredImageSingleton.getAllLayers(ImageInternedStrings.class)) {
            Object[] layerImageInternedStrings = layer.getImageInternedStrings();
            int imageIdx = Arrays.binarySearch(layerImageInternedStrings, str);
            if (imageIdx < 0) continue;
            result = layerImageInternedStrings[imageIdx];
            break;
        }
        if ((oldValue = RuntimeInternedStrings.getInternedStrings().putIfAbsent((String)result, (String)result)) != null) {
            result = oldValue;
        }
        return result;
    }

    public static Object getImageInternedStrings() {
        return LayeredImageSingletonSupport.singleton().lookup(ImageInternedStrings.class, false, true);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        ArrayList<String> newPriorInternedStrings = new ArrayList<String>(this.internedStringsIdentityMap.size());
        newPriorInternedStrings.addAll(this.internedStringsIdentityMap.keySet());
        writer.writeStringList("internedStrings", newPriorInternedStrings);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        SetGenerator gen = () -> Set.of(loader.readStringList("internedStrings").toArray(new String[0]));
        return new StringInternSupport(gen);
    }

    static interface SetGenerator {
        public Set<String> generateSet();
    }
}

