/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.util.UserError;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class LayeredModuleSingleton
implements LayeredImageSingleton {
    public static final String ALL_UNNAMED_MODULE_NAME = "native-image-all-unnamed";
    public static final String EVERYONE_MODULE_NAME = "native-image-everyone";
    protected final Map<String, Map<String, Set<String>>> moduleOpenPackages;
    protected final Map<String, Map<String, Set<String>>> moduleExportedPackages;
    private final Map<String, Module> moduleNames = new HashMap<String, Module>();
    private Module everyoneModule;
    private Module allUnnamedModule;

    public LayeredModuleSingleton() {
        this(new HashMap<String, Map<String, Set<String>>>(), new HashMap<String, Map<String, Set<String>>>());
    }

    public LayeredModuleSingleton(Map<String, Map<String, Set<String>>> moduleOpenPackages, Map<String, Map<String, Set<String>>> moduleExportedPackages) {
        this.moduleOpenPackages = moduleOpenPackages;
        this.moduleExportedPackages = moduleExportedPackages;
    }

    public static LayeredModuleSingleton singleton() {
        return (LayeredModuleSingleton)ImageSingletons.lookup(LayeredModuleSingleton.class);
    }

    public void setUnnamedModules(Module everyoneModule, Module allUnnamedModule) {
        this.everyoneModule = everyoneModule;
        this.allUnnamedModule = allUnnamedModule;
    }

    public Map<String, Set<String>> getOpenPackages(Module module) {
        return this.moduleOpenPackages.get(module.getName());
    }

    public Map<String, Set<String>> getExportedPackages(Module module) {
        return this.moduleExportedPackages.get(module.getName());
    }

    public Collection<Module> getModules() {
        return this.moduleNames.values();
    }

    public void setOpenPackages(Module module, Map<String, Set<Module>> openPackages) {
        this.setPackages(module, this.moduleOpenPackages, openPackages, "opened");
    }

    public void setExportedPackages(Module module, Map<String, Set<Module>> exportedPackages) {
        this.setPackages(module, this.moduleExportedPackages, exportedPackages, "exported");
    }

    private void setPackages(Module module, Map<String, Map<String, Set<String>>> modulePackages, Map<String, Set<Module>> packages, String mode) {
        Module oldValue = this.moduleNames.put(module.toString(), module);
        if (oldValue != null && oldValue != module) {
            throw UserError.abort("Layered images require all modules to have a different name because their identity hash code is not consistent across layers. The modules %s and %s have the same name and were added to the %s packages", module, oldValue, mode);
        }
        Map namesMap = modulePackages.computeIfAbsent(module.getName(), k -> new HashMap());
        for (Map.Entry<String, Set<Module>> entry : packages.entrySet()) {
            Set modules = namesMap.computeIfAbsent(entry.getKey(), k -> new HashSet());
            modules.addAll(entry.getValue().stream().map(Module::getName).toList());
            modules.remove(null);
            if (entry.getValue().contains(this.allUnnamedModule)) {
                modules.add(ALL_UNNAMED_MODULE_NAME);
            }
            if (!entry.getValue().contains(this.everyoneModule)) continue;
            modules.add(EVERYONE_MODULE_NAME);
        }
    }
}

