/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class AbstractClassRegistry {
    private final EconomicMap<Symbol<Type>, Class<?>> aotClasses = SubstrateUtil.HOSTED ? ImageHeapMap.createNonLayeredMap() : null;
    protected final ConcurrentHashMap<Symbol<Type>, Object> runtimeClasses;

    AbstractClassRegistry(ConcurrentHashMap<Symbol<Type>, Object> runtimeClasses) {
        this.runtimeClasses = runtimeClasses;
    }

    protected final Class<?> findAOTLoadedClass(Symbol<Type> name) {
        if (this.aotClasses == null) {
            return null;
        }
        return (Class)this.aotClasses.get(name);
    }

    public final Class<?> findLoadedClass(Symbol<Type> name) {
        Class<?> aotClass = this.findAOTLoadedClass(name);
        if (aotClass != null || this.runtimeClasses == null) {
            return aotClass;
        }
        Object maybeClass = this.runtimeClasses.get(name);
        if (maybeClass instanceof Class) {
            Class entry = (Class)maybeClass;
            return entry;
        }
        return null;
    }

    public abstract ClassLoader getClassLoader();

    public abstract Class<?> loadClass(Symbol<Type> var1) throws ClassNotFoundException;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public final void addAOTType(Class<?> cls) {
        assert (!cls.isArray() && !cls.isPrimitive());
        TypeSymbols types = ClassRegistries.singleton().getTypes();
        ByteSequence typeBytes = ByteSequence.createTypeFromName((String)cls.getName());
        Symbol key = types.getOrCreateValidType(typeBytes, true);
        assert (key != null) : typeBytes;
        Class prev = (Class)this.aotClasses.put((Object)key, cls);
        assert (prev == null || prev == cls);
    }
}

