/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.hub.registry.AbstractClassRegistry;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import java.util.concurrent.ConcurrentHashMap;

public final class AOTClassRegistry
extends AbstractClassRegistry {
    private final ClassLoader classLoader;

    public AOTClassRegistry(ClassLoader classLoader) {
        super(classLoader == null ? null : new ConcurrentHashMap());
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClass(Symbol<Type> type) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(type);
        if (cls != null || this.classLoader == null) {
            return cls;
        }
        assert (type.byteAt(0) == 76 && type.byteAt(type.length() - 1) == 59) : type;
        String name = type.subSequence(1, type.length() - 1).toString().replace('/', '.');
        cls = this.classLoader.loadClass(name);
        Class<?> prev = this.runtimeClasses.put(type, cls);
        assert (prev == null || prev == cls);
        return cls;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

