/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.BuildingImageLayerPredicate;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import java.util.EnumSet;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(onlyWith={BuildingImageLayerPredicate.class})
public class LayeredReflectionMetadataSingleton
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    private final EconomicMap<Integer, DynamicHub.ReflectionMetadata> reflectionMetadataMap = EconomicMap.create();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static LayeredReflectionMetadataSingleton currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(LayeredReflectionMetadataSingleton.class, false, true);
    }

    public static LayeredReflectionMetadataSingleton[] singletons() {
        return (LayeredReflectionMetadataSingleton[])MultiLayeredImageSingleton.getAllLayers(LayeredReflectionMetadataSingleton.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReflectionMetadata(DynamicHub hub, DynamicHub.ReflectionMetadata reflectionMetadata) {
        assert (!this.reflectionMetadataMap.containsKey((Object)hub.getTypeID())) : "The hub %s was added twice in the same layered reflection metadata".formatted(hub);
        this.reflectionMetadataMap.put((Object)hub.getTypeID(), (Object)reflectionMetadata);
    }

    public DynamicHub.ReflectionMetadata getReflectionMetadata(DynamicHub hub) {
        return (DynamicHub.ReflectionMetadata)this.reflectionMetadataMap.get((Object)hub.getTypeID());
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }
}

