/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.heap.PodReferenceMapDecoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SubstrateObjectCloneSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor CLONE = SnippetRuntime.findForeignCall(SubstrateObjectCloneSnippets.class, "doClone", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any());
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CLONE};
    private final SnippetTemplate.SnippetInfo doClone;

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/hotspot/share/prims/jvm.cpp#L645-L694")
    private static Object doClone(Object original) throws CloneNotSupportedException {
        Object result;
        if (original == null) {
            throw new NullPointerException();
        }
        if (!(original instanceof Cloneable)) {
            throw new CloneNotSupportedException("Object is no instance of Cloneable: " + original.getClass().getName());
        }
        DynamicHub hub = KnownIntrinsics.readHub(original);
        if (hub.getHubType() == 1) {
            throw new CloneNotSupportedException("Subclasses of java.lang.ref.Reference are not cloneable: " + hub.getName());
        }
        int layoutEncoding = hub.getLayoutEncoding();
        boolean isArrayLike = LayoutEncoding.isArrayLike(layoutEncoding);
        if (isArrayLike) {
            if (BranchProbabilityNode.probability((double)0.99, (boolean)LayoutEncoding.isArray(layoutEncoding))) {
                int length = ArrayLengthNode.arrayLength((Object)original);
                Object newArray = KnownIntrinsics.unvalidatedNewArray(DynamicHub.toClass(hub.getComponentHub()), length);
                if (LayoutEncoding.isObjectArray(layoutEncoding)) {
                    JavaMemoryUtil.copyObjectArrayForward(original, 0, newArray, 0, length, layoutEncoding);
                    return newArray;
                } else {
                    JavaMemoryUtil.copyPrimitiveArrayForward(original, 0, newArray, 0, length, layoutEncoding);
                }
                return newArray;
            }
            if (!Pod.RuntimeSupport.isPresent() || !hub.isPodInstanceClass()) throw VMError.shouldNotReachHere("Hybrid classes do not support Object.clone().");
            result = PodReferenceMapDecoder.clone(original, hub, layoutEncoding);
        } else {
            result = KnownIntrinsics.unvalidatedAllocateInstance(DynamicHub.toClass(hub));
        }
        Pointer refMapPos = (Pointer)DynamicHubSupport.getInstanceReferenceMap(hub);
        int entryCount = refMapPos.readInt(0);
        refMapPos = refMapPos.add(4);
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        assert (entryCount >= 0);
        UnsignedWord sizeOfEntries = Word.unsigned((int)8).multiply(entryCount);
        Pointer refMapEnd = refMapPos.add(sizeOfEntries);
        long curOffset = ConfigurationValues.getObjectLayout().getFirstFieldOffset();
        while (refMapPos.belowThan((UnsignedWord)refMapEnd)) {
            int objectOffset = refMapPos.readInt(0);
            refMapPos = refMapPos.add(4);
            long count = refMapPos.readInt(0);
            refMapPos = refMapPos.add(4);
            long primitiveDataSize = (long)objectOffset - curOffset;
            assert (primitiveDataSize >= 0L);
            assert (curOffset >= 0L);
            JavaMemoryUtil.copyForward(original, Word.unsigned((long)curOffset), result, Word.unsigned((long)curOffset), Word.unsigned((long)primitiveDataSize));
            assert ((curOffset += primitiveDataSize) >= 0L);
            assert (count >= 0L);
            JavaMemoryUtil.copyReferencesForward(original, Word.unsigned((long)curOffset), result, Word.unsigned((long)curOffset), Word.unsigned((long)count));
            curOffset += count * (long)referenceSize;
        }
        int endOffset = isArrayLike ? LayoutEncoding.getArrayBaseOffsetAsInt(layoutEncoding) : UnsignedUtils.safeToInt(LayoutEncoding.getPureInstanceAllocationSize(layoutEncoding));
        long primitiveDataSize = (long)endOffset - curOffset;
        assert (primitiveDataSize >= 0L);
        assert (curOffset >= 0L);
        JavaMemoryUtil.copyForward(original, Word.unsigned((long)curOffset), result, Word.unsigned((long)curOffset), Word.unsigned((long)primitiveDataSize));
        assert ((curOffset += primitiveDataSize) == (long)endOffset);
        int monitorOffset = hub.getMonitorOffset();
        if (monitorOffset != 0) {
            BarrieredAccess.writeObject((Object)result, (int)monitorOffset, null);
        }
        if (ConfigurationValues.getObjectLayout().isIdentityHashFieldAtTypeSpecificOffset()) {
            int offset = LayoutEncoding.getIdentityHashOffset(result);
            ObjectAccess.writeInt((Object)result, (int)offset, (int)0);
        }
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_STORE);
        return result;
    }

    static boolean canVirtualize(ObjectClone node, VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(node.getObject());
        if (alias instanceof VirtualObjectNode) {
            return true;
        }
        ResolvedJavaType type = ObjectClone.getConcreteType((Stamp)alias.stamp(NodeView.DEFAULT));
        if (type instanceof SharedType) {
            int encoding = ((SharedType)type).getHub().getLayoutEncoding();
            return !LayoutEncoding.isHybrid(encoding);
        }
        return type != null && type.isArray();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callClone(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Snippet
    public static Object cloneSnippet(Object thisObj) {
        Object result = SubstrateObjectCloneSnippets.callClone(CLONE, thisObj);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new SubstrateObjectCloneSnippets(options, providers, lowerings);
    }

    private SubstrateObjectCloneSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.doClone = this.snippet(providers, SubstrateObjectCloneSnippets.class, "cloneSnippet", new LocationIdentity[0]);
        ObjectCloneLowering objectCloneLowering = new ObjectCloneLowering();
        lowerings.put(SubstrateObjectCloneNode.class, objectCloneLowering);
        ObjectCloneWithExceptionLowering objectCloneWithExceptionLowering = new ObjectCloneWithExceptionLowering(this);
        lowerings.put(SubstrateObjectCloneWithExceptionNode.class, objectCloneWithExceptionLowering);
    }

    final class ObjectCloneLowering
    implements NodeLoweringProvider<SubstrateObjectCloneNode> {
        ObjectCloneLowering() {
        }

        @Override
        public void lower(SubstrateObjectCloneNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage().areFrameStatesAtSideEffects()) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(SubstrateObjectCloneSnippets.this.doClone, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("thisObj", (Object)node.getObject());
            SubstrateObjectCloneSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    final class ObjectCloneWithExceptionLowering
    implements NodeLoweringProvider<SubstrateObjectCloneWithExceptionNode> {
        ObjectCloneWithExceptionLowering(SubstrateObjectCloneSnippets this$0) {
        }

        @Override
        public void lower(SubstrateObjectCloneWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)CLONE, new ValueNode[]{node.getObject()}));
            call.setBci(node.bci());
            call.setStamp(node.stamp(NodeView.DEFAULT));
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }
}

