/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SubstrateMetaAccessExtensionProvider
implements MetaAccessExtensionProvider {
    public JavaKind getStorageKind(JavaType type) {
        return ((SharedType)type).getStorageKind();
    }

    public boolean canConstantFoldDynamicAllocation(ResolvedJavaType type) {
        return type != null && ((SharedType)type).getHub().isInstantiated();
    }

    public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
        if (method == null) {
            return false;
        }
        SharedMethod sharedMethod = (SharedMethod)method;
        if (sharedMethod.isUninterruptible()) {
            return false;
        }
        if (!isDirect) {
            for (SharedMethod implementation : sharedMethod.getImplementations()) {
                if (!implementation.isUninterruptible()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canVirtualize(ResolvedJavaType instanceType) {
        return true;
    }

    public ResolvedJavaField getStaticFieldForAccess(JavaConstant base, long offset, JavaKind accessKind) {
        return null;
    }
}

