/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.BooleanPointer;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.TlabSupport;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSupport;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatPodNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatStoredContinuationNode;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.JfrAllocationEvents;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawFieldOffset;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public final class ThreadLocalAllocation {
    static final FastThreadLocalWord<UnsignedWord> allocatedAlignedBytes = FastThreadLocalFactory.createWord("ThreadLocalAllocation.allocatedAlignedBytes");
    private static final FastThreadLocalWord<UnsignedWord> allocatedUnalignedBytes = FastThreadLocalFactory.createWord("ThreadLocalAllocation.allocatedUnalignedBytes");
    private static final FastThreadLocalBytes<Descriptor> regularTLAB = (FastThreadLocalBytes)FastThreadLocalFactory.createBytes(ThreadLocalAllocation::getTlabDescriptorSize, "ThreadLocalAllocation.regularTLAB").setMaxOffset(127);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ThreadLocalAllocation() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getTlabDescriptorSize() {
        return SizeOf.get(Descriptor.class);
    }

    public static Word getTlabAddress() {
        return (Word)regularTLAB.getAddress();
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    public static Descriptor getTlab(IsolateThread vmThread) {
        return regularTLAB.getAddress(vmThread);
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    static Descriptor getTlab() {
        return regularTLAB.getAddress();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getAllocatedBytes(IsolateThread thread) {
        return allocatedAlignedBytes.getVolatile(thread).add(allocatedUnalignedBytes.getVolatile(thread));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getAlignedAllocatedBytes(IsolateThread thread) {
        return allocatedAlignedBytes.getVolatile(thread);
    }

    private static void runSlowPathHooks() {
        GCImpl.getPolicy().updateSizeParameters();
    }

    public static Object slowPathNewInstance(Word objectHeader) {
        UnsignedWord size;
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
        Object result = ThreadLocalAllocation.allocateInstanceInCurrentTlab(hub, size = LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding()));
        if (result == null) {
            result = ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating(hub, size);
            ThreadLocalAllocation.runSlowPathHooks();
            ThreadLocalAllocation.sampleSlowPathAllocation(result, size, Integer.MIN_VALUE);
        }
        return result;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewInstanceWithoutAllocating(DynamicHub hub, UnsignedWord size) {
        HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating", DynamicHub.toClass(hub).getName());
        GCImpl.getGCImpl().maybeCollectOnAllocation(size);
        return ThreadLocalAllocation.slowPathNewInstanceWithoutAllocation0(hub, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Possible use of StackValue in virtual thread.")
    private static Object slowPathNewInstanceWithoutAllocation0(DynamicHub hub, UnsignedWord size) {
        long startTicks = JfrTicks.elapsedTicks();
        BooleanPointer allocatedOutsideTlab = (BooleanPointer)StackValue.get(BooleanPointer.class);
        allocatedOutsideTlab.write(false);
        try {
            Object object = ThreadLocalAllocation.allocateInstanceSlow(hub, size, allocatedOutsideTlab);
            return object;
        }
        finally {
            JfrAllocationEvents.emit(startTicks, hub, size, ThreadLocalAllocation.getTlabSize(), allocatedOutsideTlab.read());
        }
    }

    public static Object slowPathNewArrayLikeObject(Word objectHeader, int length, byte[] podReferenceMap) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
        UnsignedWord size = LayoutEncoding.getArrayAllocationSize(hub.getLayoutEncoding(), length);
        GCImpl.getPolicy().ensureSizeParametersInitialized();
        if (GCImpl.getPolicy().isOutOfMemory(size) && !GCImpl.shouldIgnoreOutOfMemory()) {
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Array allocation too large.");
            throw OutOfMemoryUtil.reportOutOfMemoryError(outOfMemoryError);
        }
        Object result = ThreadLocalAllocation.slowPathNewArrayLikeObjectWithoutAllocating(hub, length, size, podReferenceMap);
        ThreadLocalAllocation.runSlowPathHooks();
        ThreadLocalAllocation.sampleSlowPathAllocation(result, size, length);
        return result;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewArrayLikeObjectWithoutAllocating(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap) {
        HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.slowPathNewArrayLikeObjectWithoutAllocating", DynamicHub.toClass(hub).getName());
        GCImpl.getGCImpl().maybeCollectOnAllocation(size);
        return ThreadLocalAllocation.slowPathNewArrayLikeObjectWithoutAllocation0(hub, length, size, podReferenceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Possible use of StackValue in virtual thread.")
    private static Object slowPathNewArrayLikeObjectWithoutAllocation0(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap) {
        long startTicks = JfrTicks.elapsedTicks();
        UnsignedWord tlabSize = (UnsignedWord)Word.zero();
        BooleanPointer allocatedOutsideTlab = (BooleanPointer)StackValue.get(BooleanPointer.class);
        allocatedOutsideTlab.write(false);
        try {
            if (!GenScavengeAllocationSupport.arrayAllocatedInAlignedChunk(size)) {
                int layoutEncoding = hub.getLayoutEncoding();
                assert (LayoutEncoding.isArray(layoutEncoding) || StoredContinuation.class.isAssignableFrom(DynamicHub.toClass(hub)));
                boolean needsZeroing = !HeapChunkProvider.areUnalignedChunksZeroed();
                UnalignedHeapChunk.UnalignedHeader newTlabChunk = HeapImpl.getChunkProvider().produceUnalignedChunk(size);
                tlabSize = UnalignedHeapChunk.getChunkSizeForObject(size);
                Object object = ThreadLocalAllocation.allocateLargeArrayLikeObjectInNewTlab(hub, length, size, newTlabChunk, needsZeroing, podReferenceMap);
                return object;
            }
            Object array = ThreadLocalAllocation.allocateSmallArrayLikeObjectInCurrentTlab(hub, length, size, podReferenceMap);
            if (array == null) {
                array = ThreadLocalAllocation.allocateArraySlow(hub, length, size, podReferenceMap, allocatedOutsideTlab);
            }
            tlabSize = ThreadLocalAllocation.getTlabSize();
            Object object = array;
            return object;
        }
        finally {
            JfrAllocationEvents.emit(startTicks, hub, size, tlabSize, allocatedOutsideTlab.read());
        }
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateInstanceInCurrentTlab(DynamicHub hub, UnsignedWord size) {
        if (!ThreadLocalAllocation.fitsInTlab(ThreadLocalAllocation.getTlab(), size)) {
            return null;
        }
        assert (size.equal(LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding())));
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInTlab(size, ThreadLocalAllocation.getTlab());
        return FormatObjectNode.formatObject(memory, DynamicHub.toClass(hub), false, AllocationSnippets.FillContent.WITH_ZEROES, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateInstanceSlow(DynamicHub hub, UnsignedWord size, BooleanPointer allocatedOutsideTlab) {
        assert (size.equal(LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding())));
        Pointer memory = ThreadLocalAllocation.allocateRawMemory(size, allocatedOutsideTlab);
        return FormatObjectNode.formatObject(memory, DynamicHub.toClass(hub), false, AllocationSnippets.FillContent.WITH_ZEROES, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateSmallArrayLikeObjectInCurrentTlab(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap) {
        if (!ThreadLocalAllocation.fitsInTlab(ThreadLocalAllocation.getTlab(), size)) {
            return null;
        }
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInTlab(size, ThreadLocalAllocation.getTlab());
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, false, AllocationSnippets.FillContent.WITH_ZEROES, podReferenceMap);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateArraySlow(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap, BooleanPointer allocatedOutsideTlab) {
        Pointer memory = ThreadLocalAllocation.allocateRawMemory(size, allocatedOutsideTlab);
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, false, AllocationSnippets.FillContent.WITH_ZEROES, podReferenceMap);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/shared/memAllocator.cpp#L333-L341")
    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Pointer allocateRawMemory(UnsignedWord size, BooleanPointer allocatedOutsideTlab) {
        Pointer memory = TlabSupport.allocateRawMemoryInTlabSlow(size);
        if (memory.isNonNull()) {
            return memory;
        }
        return ThreadLocalAllocation.allocateRawMemoryOutsideTlab(size, allocatedOutsideTlab);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+25/src/hotspot/share/gc/shared/memAllocator.cpp#L239-L251")
    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Pointer allocateRawMemoryOutsideTlab(UnsignedWord size, BooleanPointer allocatedOutsideTlab) {
        allocatedOutsideTlab.write(true);
        Pointer memory = YoungGeneration.getHeapAllocation().allocateOutsideTlab(size);
        allocatedAlignedBytes.set(allocatedAlignedBytes.get().add(size));
        return memory;
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateLargeArrayLikeObjectInNewTlab(DynamicHub hub, int length, UnsignedWord size, UnalignedHeapChunk.UnalignedHeader newTlabChunk, boolean needsZeroing, byte[] podReferenceMap) {
        Descriptor tlab = ThreadLocalAllocation.getTlab();
        HeapChunk.setNext(newTlabChunk, tlab.getUnalignedChunk());
        tlab.setUnalignedChunk(newTlabChunk);
        allocatedUnalignedBytes.set(allocatedUnalignedBytes.get().add(size));
        HeapImpl.getAccounting().increaseEdenUsedBytes(size);
        Pointer memory = UnalignedHeapChunk.allocateMemory(newTlabChunk, size);
        assert (memory.isNonNull());
        if (!needsZeroing && SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            ThreadLocalAllocation.guaranteeZeroed(memory, size);
        }
        AllocationSnippets.FillContent fillKind = needsZeroing ? AllocationSnippets.FillContent.WITH_ZEROES : AllocationSnippets.FillContent.DO_NOT_FILL;
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, true, fillKind, podReferenceMap);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object formatArrayLikeObject(Pointer memory, DynamicHub hub, int length, boolean unaligned, AllocationSnippets.FillContent fillContent, byte[] podReferenceMap) {
        Class<?> clazz = DynamicHub.toClass(hub);
        if (ContinuationSupport.isSupported() && clazz == StoredContinuation.class) {
            return FormatStoredContinuationNode.formatStoredContinuation(memory, clazz, length, false, unaligned, true);
        }
        if (Pod.RuntimeSupport.isPresent() && podReferenceMap != null) {
            return FormatPodNode.formatPod(memory, clazz, length, podReferenceMap, false, unaligned, fillContent, true);
        }
        return FormatArrayNode.formatArray(memory, clazz, length, false, unaligned, fillContent, true);
    }

    @Uninterruptible(reason="Returns uninitialized memory, modifies TLAB", callerMustBe=true)
    private static Pointer allocateRawMemoryInTlab(UnsignedWord size, Descriptor tlab) {
        assert (ThreadLocalAllocation.fitsInTlab(tlab, size)) : "Not enough TLAB space for allocation";
        Pointer top = KnownIntrinsics.nonNullPointer((Pointer)tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY));
        tlab.setAllocationTop(top.add(size), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        return top;
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static boolean fitsInTlab(Descriptor tlab, UnsignedWord size) {
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        Word end = tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        assert (top.belowOrEqual((UnsignedWord)end));
        Pointer newTop = top.add(size);
        return newTop.belowOrEqual((UnsignedWord)end);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void guaranteeZeroed(Pointer memory, UnsignedWord size) {
        int wordSize = ConfigurationValues.getTarget().wordSize;
        VMError.guarantee(UnsignedUtils.isAMultiple(size, Word.unsigned((int)wordSize)));
        Pointer pos = memory;
        Pointer end = memory.add(size);
        while (pos.belowThan((UnsignedWord)end)) {
            Word v = (Word)pos.readWord(0);
            VMError.guarantee(v.equal(0));
            pos = pos.add(wordSize);
        }
    }

    private static void sampleSlowPathAllocation(Object obj, UnsignedWord allocatedSize, int arrayLength) {
        if (HasJfrSupport.get()) {
            SubstrateJVM.getOldObjectProfiler().sample(obj, allocatedSize, arrayLength);
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static UnsignedWord getTlabSize() {
        Descriptor tlab = ThreadLocalAllocation.getTlab();
        Word allocationEnd = tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        Word allocationStart = tlab.getAlignedAllocationStart(SubstrateAllocationSnippets.TLAB_START_IDENTITY);
        assert (allocationStart.belowThan((UnsignedWord)allocationEnd) || allocationStart.equal(0) && allocationEnd.equal(0));
        UnsignedWord tlabSize = allocationEnd.subtract((UnsignedWord)allocationStart);
        assert (UnsignedUtils.isAMultiple(tlabSize, Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment())));
        return tlabSize;
    }

    @RawStructure
    public static interface Descriptor
    extends PointerBase {
        @RawField
        public Word getAlignedAllocationStart(LocationIdentity var1);

        @RawField
        public void setAlignedAllocationStart(Pointer var1, LocationIdentity var2);

        @RawField
        @UniqueLocationIdentity
        public UnalignedHeapChunk.UnalignedHeader getUnalignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setUnalignedChunk(UnalignedHeapChunk.UnalignedHeader var1);

        @RawField
        public Word getAllocationTop(LocationIdentity var1);

        @RawField
        public void setAllocationTop(Pointer var1, LocationIdentity var2);

        @RawFieldOffset
        public static int offsetOfAllocationTop() {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @RawField
        public Word getAllocationEnd(LocationIdentity var1);

        @RawField
        public void setAllocationEnd(Pointer var1, LocationIdentity var2);

        @RawFieldOffset
        public static int offsetOfAllocationEnd() {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }
}

