/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.hub.DynamicHub;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class RuntimeCodeCacheReachabilityAnalyzer
implements ObjectReferenceVisitor {
    private static final UnreachableObjectsException UNREACHABLE_OBJECTS_EXCEPTION = new UnreachableObjectsException();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheReachabilityAnalyzer() {
    }

    @Override
    public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
        Pointer pos = firstObjRef;
        Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
        while (pos.belowThan((UnsignedWord)end)) {
            RuntimeCodeCacheReachabilityAnalyzer.visitObjectReference(pos, compressed);
            pos = pos.add(referenceSize);
        }
    }

    private static void visitObjectReference(Pointer ptrPtrToObject, boolean compressed) {
        Word ptrToObj = ReferenceAccess.singleton().readObjectAsUntrackedPointer(ptrPtrToObject, compressed);
        if (ptrToObj.isNonNull() && !RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)ptrToObj)) {
            throw UNREACHABLE_OBJECTS_EXCEPTION;
        }
    }

    public static boolean isReachable(Pointer ptrToObj) {
        assert (ptrToObj.isNonNull());
        if (HeapImpl.getHeapImpl().isInImageHeap(ptrToObj)) {
            return true;
        }
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Word header = ohi.readHeaderFromPointer(ptrToObj);
        if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
            return true;
        }
        if (SerialGCOptions.useCompactingOldGen() && ObjectHeaderImpl.isMarkedHeader((UnsignedWord)header)) {
            return true;
        }
        Space space = HeapChunk.getSpace(HeapChunk.getEnclosingHeapChunk(ptrToObj, (UnsignedWord)header));
        if (space.isToSpace()) {
            return true;
        }
        if (space.isCompactingOldSpace() && !GCImpl.getGCImpl().isCompleteCollection()) {
            return true;
        }
        Class<?> clazz = DynamicHub.toClass(ohi.dynamicHubFromObjectHeader(header));
        return RuntimeCodeCacheReachabilityAnalyzer.isAssumedReachable(clazz);
    }

    private static boolean isAssumedReachable(Class<?> clazz) {
        Class<?>[] classesAssumedReachable;
        for (Class<?> aClass : classesAssumedReachable = RuntimeCodeCacheCleaner.CLASSES_ASSUMED_REACHABLE) {
            if (!aClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static final class UnreachableObjectsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        UnreachableObjectsException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

