/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

abstract class MemoryWalkerAccessBase
implements MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> {
    private final String regionName;
    private final boolean isWritable;
    private final boolean consistsOfHugeObjects;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    MemoryWalkerAccessBase(String regionName, boolean isWritable, boolean consistsOfHugeObjects) {
        this.regionName = regionName;
        this.isWritable = isWritable;
        this.consistsOfHugeObjects = consistsOfHugeObjects;
    }

    @Override
    public UnsignedWord getSize(ImageHeapInfo info) {
        Word firstStart = Word.objectToUntrackedPointer((Object)this.getFirstObject(info));
        if (firstStart.isNull()) {
            return (UnsignedWord)Word.zero();
        }
        Pointer lastEnd = LayoutEncoding.getImageHeapObjectEnd(this.getLastObject(info));
        return lastEnd.subtract((UnsignedWord)firstStart);
    }

    @Override
    public String getRegionName(ImageHeapInfo region) {
        return this.regionName;
    }

    @Override
    public boolean isWritable(ImageHeapInfo region) {
        return this.isWritable;
    }

    @Override
    public boolean consistsOfHugeObjects(ImageHeapInfo region) {
        return this.consistsOfHugeObjects;
    }

    @Override
    public final void visitObjects(ImageHeapInfo region, ObjectVisitor visitor) {
        boolean alignedChunks = !this.consistsOfHugeObjects;
        ImageHeapWalker.walkPartition(this.getFirstObject(region), this.getLastObject(region), visitor, alignedChunks);
    }
}

