/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AdaptiveCollectionPolicy;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.UnsignedWord;

class LibGraalCollectionPolicy
extends AdaptiveCollectionPolicy {
    protected static final UnsignedWord INITIAL_HEAP_SIZE = Word.unsigned((long)0x4000000L);
    protected static final UnsignedWord FULL_GC_BONUS = Word.unsigned((long)0x200000L);
    protected static final UnsignedWord MAXIMUM_HEAP_SIZE = Word.unsigned((long)0x400000000L);
    protected static final UnsignedWord MAXIMUM_YOUNG_SIZE = Word.unsigned((long)0x140000000L);
    private UnsignedWord sizeBefore = (UnsignedWord)Word.zero();
    private GCCause lastGCCause = null;

    LibGraalCollectionPolicy() {
    }

    @Override
    public String getName() {
        return "libgraal";
    }

    @Override
    public boolean shouldCollectOnHint(boolean fullGC) {
        this.guaranteeSizeParametersInitialized();
        UnsignedWord edenUsedBytes = HeapImpl.getAccounting().getEdenUsedBytes();
        if (fullGC) {
            edenUsedBytes = edenUsedBytes.add(FULL_GC_BONUS);
        }
        return edenUsedBytes.aboveOrEqual(Word.unsigned((long)Options.ExpectedEdenSize.getValue())) || UnsignedUtils.toDouble(edenUsedBytes) / UnsignedUtils.toDouble(this.edenSize) >= Options.UsedEdenProportionThreshold.getValue();
    }

    @Override
    protected UnsignedWord getInitialHeapSize() {
        return INITIAL_HEAP_SIZE;
    }

    @Override
    protected UnsignedWord getHeapSizeLimit() {
        return UnsignedUtils.min(super.getHeapSizeLimit(), MAXIMUM_HEAP_SIZE);
    }

    @Override
    protected UnsignedWord getYoungSizeLimit(UnsignedWord maxHeap) {
        return UnsignedUtils.min(super.getYoungSizeLimit(maxHeap), MAXIMUM_YOUNG_SIZE);
    }

    @Override
    public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
        this.sizeBefore = GCImpl.getChunkBytes();
        super.onCollectionBegin(completeCollection, requestingNanoTime);
    }

    @Override
    public void onCollectionEnd(boolean completeCollection, GCCause cause) {
        super.onCollectionEnd(completeCollection, cause);
        this.sizeBefore = (UnsignedWord)Word.zero();
        this.lastGCCause = cause;
    }

    @Override
    protected boolean shouldUpdateStats(GCCause cause) {
        return cause == GCCause.HintedGC || super.shouldUpdateStats(cause);
    }

    @Override
    protected void computeEdenSpaceSize(boolean completeCollection, GCCause cause) {
        if (cause == GCCause.HintedGC) {
            UnsignedWord newEdenSize;
            if (completeCollection && this.lastGCCause == GCCause.HintedGC && this.edenSize.aboveThan(newEdenSize = UnsignedUtils.max(this.sizes.initialEdenSize, LibGraalCollectionPolicy.alignUp(this.edenSize.unsignedDivide(2))))) {
                this.edenSize = newEdenSize;
            }
        } else {
            UnsignedWord sizeAfter = GCImpl.getChunkBytes();
            if (this.sizeBefore.notEqual(0) && this.sizeBefore.belowThan(sizeAfter.multiply(2))) {
                UnsignedWord newEdenSize = UnsignedUtils.min(this.getMaximumEdenSize(), LibGraalCollectionPolicy.alignUp(this.edenSize.multiply(2)));
                if (this.edenSize.belowThan(newEdenSize)) {
                    this.edenSize = newEdenSize;
                }
            } else {
                super.computeEdenSpaceSize(completeCollection, cause);
            }
        }
    }

    public static final class Options {
        public static final RuntimeOptionKey<Double> UsedEdenProportionThreshold = new RuntimeOptionKey<Double>(Double.valueOf(0.75), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Long> ExpectedEdenSize = new RuntimeOptionKey<Long>(Long.valueOf(0x2000000L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

