/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HostedImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.RuntimeImageHeapChunkWriter;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.word.UnsignedWord;

public class ChunkedImageHeapLayouter
implements ImageHeapLayouter {
    private static final int READ_ONLY_REGULAR = 0;
    private static final int READ_ONLY_RELOCATABLE = 1;
    private static final int WRITABLE_PATCHED = 2;
    private static final int WRITABLE_REGULAR = 3;
    private static final int WRITABLE_HUGE = 4;
    private static final int READ_ONLY_HUGE = 5;
    private static final int PARTITION_COUNT = 6;
    private static final String ALIGNED_HEAP_CHUNK_OPTION = SubstrateOptionsParser.commandArgument(SerialAndEpsilonGCOptions.AlignedHeapChunkSize, "<2^n>");
    private final ChunkedImageHeapPartition[] partitions = new ChunkedImageHeapPartition[6];
    private final ImageHeapInfo heapInfo;
    private final long startOffset;
    private final long hugeObjectThreshold;
    private ChunkedImageHeapAllocator allocator;

    public ChunkedImageHeapLayouter(ImageHeapInfo heapInfo, long startOffset) {
        this.partitions[0] = new ChunkedImageHeapPartition("readOnly", false, false);
        this.partitions[1] = new ChunkedImageHeapPartition("readOnlyRelocatable", false, false);
        this.partitions[2] = new ChunkedImageHeapPartition("writablePatched", true, false);
        this.partitions[3] = new ChunkedImageHeapPartition("writable", true, false);
        this.partitions[4] = new ChunkedImageHeapPartition("writableHuge", true, true);
        this.partitions[5] = new ChunkedImageHeapPartition("readOnlyHuge", false, true);
        this.heapInfo = heapInfo;
        this.startOffset = startOffset;
        UnsignedWord alignedHeaderSize = RememberedSet.get().getHeaderSizeOfAlignedChunk();
        UnsignedWord hugeThreshold = HeapParameters.getAlignedHeapChunkSize().subtract(alignedHeaderSize);
        this.hugeObjectThreshold = hugeThreshold.rawValue();
    }

    public ChunkedImageHeapPartition[] getPartitions() {
        return this.partitions;
    }

    @Override
    public void assignObjectToPartition(ImageHeapObject info, boolean immutable, boolean references, boolean relocatable, boolean patched) {
        ChunkedImageHeapPartition partition = this.choosePartition(info, immutable, relocatable, patched);
        info.setHeapPartition(partition);
        partition.assign(info);
    }

    private ChunkedImageHeapPartition choosePartition(ImageHeapObject info, boolean immutable, boolean hasRelocatables, boolean patched) {
        if (patched) {
            return this.getWritablePatched();
        }
        if (immutable) {
            if (info.getSize() >= this.hugeObjectThreshold) {
                if (hasRelocatables) {
                    if (info.getObjectClass() == DynamicHub.class) {
                        throw this.reportHugeObjectError(info, "Class metadata (dynamic hubs) cannot be huge objects: the dynamic hub %s", info.getObject().toString());
                    }
                    throw this.reportHugeObjectError(info, "Objects in image heap with relocatable pointers cannot be huge objects. Detected an object of type %s", info.getObject().getClass().getTypeName());
                }
                return this.getReadOnlyHuge();
            }
            if (hasRelocatables) {
                return this.getReadOnlyRelocatable();
            }
            return this.getReadOnlyRegular();
        }
        assert (info.getObjectClass() != DynamicHub.class) : "Class metadata (dynamic hubs) cannot be writable";
        if (info.getSize() >= this.hugeObjectThreshold) {
            return this.getWritableHuge();
        }
        return this.getWritableRegular();
    }

    private Error reportHugeObjectError(ImageHeapObject info, String objectTypeMsg, String objectText) {
        String msg = String.format(objectTypeMsg + " with size %d B and the limit is %d B. Use '%s' to increase GC chunk size to be larger than the object.", objectText, info.getSize(), this.hugeObjectThreshold, ALIGNED_HEAP_CHUNK_OPTION);
        if (ImageInfo.inImageBuildtimeCode()) {
            throw UserError.abort(msg, new Object[0]);
        }
        throw VMError.shouldNotReachHere(msg);
    }

    @Override
    public ImageHeapLayoutInfo layout(ImageHeap imageHeap, int pageSize, ImageHeapLayouter.ImageHeapLayouterCallback callback) {
        ImageHeapLayouter.ImageHeapLayouterControl control = new ImageHeapLayouter.ImageHeapLayouterControl(callback);
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        assert (pageSize % objectAlignment == 0) : "Page size does not match object alignment";
        ImageHeapLayoutInfo layoutInfo = this.doLayout(imageHeap, pageSize, control);
        for (ChunkedImageHeapPartition partition : this.getPartitions()) {
            assert (partition.getStartOffset() % (long)objectAlignment == 0L) : partition;
            assert ((partition.getStartOffset() + partition.getSize()) % (long)objectAlignment == 0L) : partition;
        }
        assert (layoutInfo.getImageHeapSize() % (long)pageSize == 0L) : "Image heap size is not a multiple of page size";
        return layoutInfo;
    }

    private ImageHeapLayoutInfo doLayout(ImageHeap imageHeap, int pageSize, ImageHeapLayouter.ImageHeapLayouterControl control) {
        this.allocator = new ChunkedImageHeapAllocator(this.startOffset);
        for (ChunkedImageHeapPartition partition : this.getPartitions()) {
            control.poll();
            partition.layout(this.allocator, control);
        }
        return this.populateInfoObjects(imageHeap.countAndVerifyDynamicHubs(), pageSize, control);
    }

    private ImageHeapLayoutInfo populateInfoObjects(int dynamicHubCount, int pageSize, ImageHeapLayouter.ImageHeapLayouterControl control) {
        long offsetOfFirstWritableAlignedChunk = -1L;
        for (ChunkedImageHeapAllocator.AlignedChunk chunk : this.allocator.getAlignedChunks()) {
            if (!chunk.isWritable()) continue;
            offsetOfFirstWritableAlignedChunk = chunk.getBegin();
            break;
        }
        control.poll();
        VMError.guarantee(offsetOfFirstWritableAlignedChunk >= 0L && offsetOfFirstWritableAlignedChunk % (long)pageSize == 0L, "Start of the writable part is assumed to be page-aligned");
        long offsetOfFirstWritableUnalignedChunk = -1L;
        long offsetOfLastWritableUnalignedChunk = -1L;
        for (ChunkedImageHeapAllocator.UnalignedChunk chunk : this.allocator.getUnalignedChunks()) {
            if (!chunk.isWritable()) break;
            if (offsetOfFirstWritableUnalignedChunk == -1L) {
                offsetOfFirstWritableUnalignedChunk = chunk.getBegin();
            }
            offsetOfLastWritableUnalignedChunk = chunk.getBegin();
        }
        control.poll();
        this.heapInfo.initialize(this.getReadOnlyRegular().firstObject, this.getReadOnlyRegular().lastObject, this.getReadOnlyRelocatable().firstObject, this.getReadOnlyRelocatable().lastObject, this.getWritablePatched().firstObject, this.getWritablePatched().lastObject, this.getWritableRegular().firstObject, this.getWritableRegular().lastObject, this.getWritableHuge().firstObject, this.getWritableHuge().lastObject, this.getReadOnlyHuge().firstObject, this.getReadOnlyHuge().lastObject, offsetOfFirstWritableAlignedChunk, offsetOfFirstWritableUnalignedChunk, offsetOfLastWritableUnalignedChunk, dynamicHubCount);
        control.poll();
        long writableEnd = this.getWritableHuge().getStartOffset() + this.getWritableHuge().getSize();
        long writableSize = writableEnd - offsetOfFirstWritableAlignedChunk;
        long imageHeapEnd = NumUtil.roundUp((long)(this.getReadOnlyHuge().getStartOffset() + this.getReadOnlyHuge().getSize()), (long)pageSize);
        long imageHeapSize = imageHeapEnd - this.startOffset;
        return new ImageHeapLayoutInfo(this.startOffset, imageHeapSize, offsetOfFirstWritableAlignedChunk, writableSize, this.getReadOnlyRelocatable().getStartOffset(), this.getReadOnlyRelocatable().getSize(), this.getWritablePatched().getStartOffset(), this.getWritablePatched().getSize());
    }

    @Override
    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
        long layoutToBufferOffsetAddend = imageHeapOffsetInBuffer - this.startOffset;
        ImageHeapChunkWriter writer = SubstrateUtil.HOSTED ? new HostedImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend) : new RuntimeImageHeapChunkWriter(imageHeapBytes, layoutToBufferOffsetAddend);
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getAlignedChunks());
        ChunkedImageHeapLayouter.writeHeaders(writer, this.allocator.getUnalignedChunks());
    }

    private static void writeHeaders(ImageHeapChunkWriter writer, List<? extends ChunkedImageHeapAllocator.Chunk> chunks) {
        ChunkedImageHeapAllocator.Chunk previous = null;
        ChunkedImageHeapAllocator.Chunk current = null;
        for (ChunkedImageHeapAllocator.Chunk chunk : chunks) {
            ChunkedImageHeapLayouter.writeHeader(writer, previous, current, chunk);
            previous = current;
            current = chunk;
        }
        ChunkedImageHeapLayouter.writeHeader(writer, previous, current, null);
    }

    private static void writeHeader(ImageHeapChunkWriter writer, ChunkedImageHeapAllocator.Chunk previous, ChunkedImageHeapAllocator.Chunk current, ChunkedImageHeapAllocator.Chunk next) {
        if (current != null) {
            long offsetToPrevious = previous != null ? previous.getBegin() - current.getBegin() : 0L;
            long offsetToNext = next != null ? next.getBegin() - current.getBegin() : 0L;
            int chunkPosition = NumUtil.safeToInt((long)current.getBegin());
            if (current instanceof ChunkedImageHeapAllocator.AlignedChunk) {
                ChunkedImageHeapAllocator.AlignedChunk aligned = (ChunkedImageHeapAllocator.AlignedChunk)current;
                writer.initializeAlignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext);
                writer.enableRememberedSetForAlignedChunk(chunkPosition, aligned.getObjects());
            } else {
                ChunkedImageHeapAllocator.UnalignedChunk unalignedChunk = (ChunkedImageHeapAllocator.UnalignedChunk)current;
                writer.initializeUnalignedChunk(chunkPosition, current.getTopOffset(), current.getEndOffset(), offsetToPrevious, offsetToNext, unalignedChunk.getObjectSize());
                writer.enableRememberedSetForUnalignedChunk(chunkPosition, unalignedChunk.getObjectSize());
            }
        }
    }

    private ChunkedImageHeapPartition getReadOnlyRegular() {
        return this.partitions[0];
    }

    private ChunkedImageHeapPartition getReadOnlyRelocatable() {
        return this.partitions[1];
    }

    private ChunkedImageHeapPartition getWritablePatched() {
        return this.partitions[2];
    }

    private ChunkedImageHeapPartition getWritableRegular() {
        return this.partitions[3];
    }

    private ChunkedImageHeapPartition getWritableHuge() {
        return this.partitions[4];
    }

    private ChunkedImageHeapPartition getReadOnlyHuge() {
        return this.partitions[5];
    }
}

